/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Computes the inverse of one or more square invertible matrices or their
 * <p>
 * adjoints (conjugate transposes).
 * <p>
 * The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
 * form square matrices. The output is a tensor of the same shape as the input
 * containing the inverse for all input submatrices `[..., :, :]`.
 * <p>
 * The op uses LU decomposition with partial pivoting to compute the inverses.
 * <p>
 * If a matrix is not invertible there is no guarantee what the op does. It
 * may detect the condition and raise an exception or it may simply return a
 * garbage result.
 * 
 * @param <T> data type for {@code output()} output
 */
@Operator
public final class MatrixInverse<T> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.MatrixInverse}
   */
  public static class Options {
    
    /**
     * @param adjoint 
     */
    public Options adjoint(Boolean adjoint) {
      this.adjoint = adjoint;
      return this;
    }
    
    private Boolean adjoint;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new MatrixInverse operation to the graph.
   * 
   * @param scope current graph scope
   * @param input Shape is `[..., M, M]`.
   * @param options carries optional attributes values
   * @return a new instance of MatrixInverse
   */
  public static <T> MatrixInverse<T> create(Scope scope, Operand<T> input, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("MatrixInverse", scope.makeOpName("MatrixInverse"));
    opBuilder.addInput(input.asOutput());
    if (options != null) {
      for (Options opts : options) {
        if (opts.adjoint != null) {
          opBuilder.setAttr("adjoint", opts.adjoint);
        }
      }
    }
    return new MatrixInverse<T>(opBuilder.build());
  }
  
  /**
   * @param adjoint 
   */
  public static Options adjoint(Boolean adjoint) {
    return new Options().adjoint(adjoint);
  }
  
  /**
   * Shape is `[..., M, M]`.
   * <p>
   * @compatibility(numpy)
   * Equivalent to np.linalg.inv
   * @end_compatibility
   */
  public Output<T> output() {
    return output;
  }
  
  @Override
  public Output<T> asOutput() {
    return output;
  }
  
  private Output<T> output;
  
  private MatrixInverse(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
