/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Inverse fast Fourier transform.
 * <p>
 * Computes the inverse 1-dimensional discrete Fourier transform over the
 * inner-most dimension of `input`.
 * 
 * @param <T> data type for {@code output()} output
 */
@Operator
public final class IFFT<T> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Factory method to create a class to wrap a new IFFT operation to the graph.
   * 
   * @param scope current graph scope
   * @param input A complex64 tensor.
   * @return a new instance of IFFT
   */
  public static <T> IFFT<T> create(Scope scope, Operand<T> input) {
    OperationBuilder opBuilder = scope.graph().opBuilder("IFFT", scope.makeOpName("IFFT"));
    opBuilder.addInput(input.asOutput());
    return new IFFT<T>(opBuilder.build());
  }
  
  /**
   * A complex64 tensor of the same shape as `input`. The inner-most
   *   dimension of `input` is replaced with its inverse 1D Fourier transform.
   * <p>
   * @compatibility(numpy)
   * Equivalent to np.fft.ifft
   * @end_compatibility
   */
  public Output<T> output() {
    return output;
  }
  
  @Override
  public Output<T> asOutput() {
    return output;
  }
  
  private Output<T> output;
  
  private IFFT(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
