/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Compute gradients for a FakeQuantWithMinMaxVarsPerChannel operation.
 */
@Operator
public final class FakeQuantWithMinMaxVarsPerChannelGradient extends PrimitiveOp {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.FakeQuantWithMinMaxVarsPerChannelGradient}
   */
  public static class Options {
    
    /**
     * @param numBits The bitwidth of the quantization; between 2 and 16, inclusive.
     */
    public Options numBits(Long numBits) {
      this.numBits = numBits;
      return this;
    }
    
    /**
     * @param narrowRange Whether to quantize into 2^num_bits - 1 distinct values.
     */
    public Options narrowRange(Boolean narrowRange) {
      this.narrowRange = narrowRange;
      return this;
    }
    
    private Long numBits;
    private Boolean narrowRange;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new FakeQuantWithMinMaxVarsPerChannelGradient operation to the graph.
   * 
   * @param scope current graph scope
   * @param gradients Backpropagated gradients above the FakeQuantWithMinMaxVars operation,
   * shape one of: `[d]`, `[b, d]`,  `[b, h, w, d]`.
   * @param inputs Values passed as inputs to the FakeQuantWithMinMaxVars operation, shape
   *   same as `gradients`.
   * min, max: Quantization interval, floats of shape `[d]`.
   * @param min 
   * @param max 
   * @param options carries optional attributes values
   * @return a new instance of FakeQuantWithMinMaxVarsPerChannelGradient
   */
  public static FakeQuantWithMinMaxVarsPerChannelGradient create(Scope scope, Operand<Float> gradients, Operand<Float> inputs, Operand<Float> min, Operand<Float> max, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("FakeQuantWithMinMaxVarsPerChannelGradient", scope.makeOpName("FakeQuantWithMinMaxVarsPerChannelGradient"));
    opBuilder.addInput(gradients.asOutput());
    opBuilder.addInput(inputs.asOutput());
    opBuilder.addInput(min.asOutput());
    opBuilder.addInput(max.asOutput());
    if (options != null) {
      for (Options opts : options) {
        if (opts.numBits != null) {
          opBuilder.setAttr("num_bits", opts.numBits);
        }
        if (opts.narrowRange != null) {
          opBuilder.setAttr("narrow_range", opts.narrowRange);
        }
      }
    }
    return new FakeQuantWithMinMaxVarsPerChannelGradient(opBuilder.build());
  }
  
  /**
   * @param numBits The bitwidth of the quantization; between 2 and 16, inclusive.
   */
  public static Options numBits(Long numBits) {
    return new Options().numBits(numBits);
  }
  
  /**
   * @param narrowRange Whether to quantize into 2^num_bits - 1 distinct values.
   */
  public static Options narrowRange(Boolean narrowRange) {
    return new Options().narrowRange(narrowRange);
  }
  
  /**
   * Backpropagated gradients w.r.t. inputs, shape same as
   * `inputs`:
   *   `gradients * (inputs >= min && inputs <= max)`.
   */
  public Output<Float> backpropsWrtInput() {
    return backpropsWrtInput;
  }
  
  /**
   * Backpropagated gradients w.r.t. min parameter, shape `[d]`:
   * `sum_per_d(gradients * (inputs < min))`.
   */
  public Output<Float> backpropWrtMin() {
    return backpropWrtMin;
  }
  
  /**
   * Backpropagated gradients w.r.t. max parameter, shape `[d]`:
   * `sum_per_d(gradients * (inputs > max))`.
   */
  public Output<Float> backpropWrtMax() {
    return backpropWrtMax;
  }
  
  private Output<Float> backpropsWrtInput;
  private Output<Float> backpropWrtMin;
  private Output<Float> backpropWrtMax;
  
  private FakeQuantWithMinMaxVarsPerChannelGradient(Operation operation) {
    super(operation);
    int outputIdx = 0;
    backpropsWrtInput = operation.output(outputIdx++);
    backpropWrtMin = operation.output(outputIdx++);
    backpropWrtMax = operation.output(outputIdx++);
  }
}
