/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedResizeBilinear<T>
extends PrimitiveOp {
    private Output<T> resizedImages;
    private Output<Float> outMin;
    private Output<Float> outMax;

    public static <T> QuantizedResizeBilinear<T> create(Scope scope, Operand<T> images, Operand<Integer> size, Operand<Float> min, Operand<Float> max, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("QuantizedResizeBilinear", scope.makeOpName("QuantizedResizeBilinear"));
        opBuilder.addInput(images.asOutput());
        opBuilder.addInput(size.asOutput());
        opBuilder.addInput(min.asOutput());
        opBuilder.addInput(max.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.alignCorners == null) continue;
                opBuilder.setAttr("align_corners", opts.alignCorners);
            }
        }
        return new QuantizedResizeBilinear<T>(opBuilder.build());
    }

    public static Options alignCorners(Boolean alignCorners) {
        return new Options().alignCorners(alignCorners);
    }

    public Output<T> resizedImages() {
        return this.resizedImages;
    }

    public Output<Float> outMin() {
        return this.outMin;
    }

    public Output<Float> outMax() {
        return this.outMax;
    }

    private QuantizedResizeBilinear(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.resizedImages = operation.output(outputIdx++);
        this.outMin = operation.output(outputIdx++);
        this.outMax = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean alignCorners;

        public Options alignCorners(Boolean alignCorners) {
            this.alignCorners = alignCorners;
            return this;
        }

        private Options() {
        }
    }
}

