/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class MapUnstageNoKey
extends PrimitiveOp {
    private Output<Long> key;
    private List<Output<?>> values;

    public static MapUnstageNoKey create(Scope scope, Operand<Integer> indices, List<Class<?>> dtypes, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("MapUnstageNoKey", scope.makeOpName("MapUnstageNoKey"));
        opBuilder.addInput(indices.asOutput());
        DataType[] dtypesArray = new DataType[dtypes.size()];
        for (int i = 0; i < dtypesArray.length; ++i) {
            dtypesArray[i] = DataType.fromClass(dtypes.get(i));
        }
        opBuilder.setAttr("dtypes", dtypesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.capacity != null) {
                    opBuilder.setAttr("capacity", opts.capacity);
                }
                if (opts.memoryLimit != null) {
                    opBuilder.setAttr("memory_limit", opts.memoryLimit);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new MapUnstageNoKey(opBuilder.build());
    }

    public static Options capacity(Long capacity) {
        return new Options().capacity(capacity);
    }

    public static Options memoryLimit(Long memoryLimit) {
        return new Options().memoryLimit(memoryLimit);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<Long> key() {
        return this.key;
    }

    public List<Output<?>> values() {
        return this.values;
    }

    private MapUnstageNoKey(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.key = operation.output(outputIdx++);
        int valuesLength = operation.outputListLength("values");
        this.values = Arrays.asList(operation.outputList(outputIdx, valuesLength));
        outputIdx += valuesLength;
    }

    public static class Options {
        private Long capacity;
        private Long memoryLimit;
        private String container;
        private String sharedName;

        public Options capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Options memoryLimit(Long memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

