/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.tensorflow.Graph;
import org.tensorflow.Session;
import org.tensorflow.TensorFlow;

public class SavedModelBundle
implements AutoCloseable {
    private final Graph graph;
    private final Session session;
    private final byte[] metaGraphDef;

    public static SavedModelBundle load(String exportDir, String ... tags) {
        return SavedModelBundle.load(exportDir, tags, null);
    }

    public byte[] metaGraphDef() {
        return this.metaGraphDef;
    }

    public Graph graph() {
        return this.graph;
    }

    public Session session() {
        return this.session;
    }

    @Override
    public void close() {
        this.session.close();
        this.graph.close();
    }

    private SavedModelBundle(Graph graph, Session session, byte[] metaGraphDef) {
        this.graph = graph;
        this.session = session;
        this.metaGraphDef = metaGraphDef;
    }

    private static SavedModelBundle fromHandle(long graphHandle, long sessionHandle, byte[] metaGraphDef) {
        Graph graph = new Graph(graphHandle);
        Session session = new Session(graph, sessionHandle);
        return new SavedModelBundle(graph, session, metaGraphDef);
    }

    private static native SavedModelBundle load(String var0, String[] var1, byte[] var2);

    static {
        TensorFlow.init();
    }
}

