/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=KeyboardButtonRequestUsersBuilderImpl.class)
public class KeyboardButtonRequestUsers
implements Validable,
BotApiObject {
    private static final String REQUEST_ID_FIELD = "request_id";
    private static final String USER_IS_BOT_FIELD = "user_is_bot";
    private static final String USER_IS_PREMIUM_FIELD = "user_is_premium";
    private static final String MAX_QUANTITY_FIELD = "max_quantity";
    private static final String REQUEST_NAME_FIELD = "request_name";
    private static final String REQUEST_USERNAME_FIELD = "request_username";
    private static final String REQUEST_PHOTO_FIELD = "request_photo";
    @JsonProperty(value="request_id")
    @NonNull
    private String requestId;
    @JsonProperty(value="user_is_bot")
    private Boolean userIsBot;
    @JsonProperty(value="user_is_premium")
    private Boolean userIsPremium;
    @JsonProperty(value="max_quantity")
    private Integer maxQuantity;
    @JsonProperty(value="request_name")
    private Boolean requestName;
    @JsonProperty(value="request_username")
    private Boolean requestUsername;
    @JsonProperty(value="request_photo")
    private Boolean requestPhoto;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.requestId.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
        if (this.maxQuantity != null && (this.maxQuantity < 1 || this.maxQuantity > 10)) {
            throw new TelegramApiValidationException("MaxQuantity parameter must be between 1 and 10", this);
        }
    }

    @Generated
    protected KeyboardButtonRequestUsers(KeyboardButtonRequestUsersBuilder<?, ?> b) {
        this.requestId = b.requestId;
        if (this.requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        this.userIsBot = b.userIsBot;
        this.userIsPremium = b.userIsPremium;
        this.maxQuantity = b.maxQuantity;
        this.requestName = b.requestName;
        this.requestUsername = b.requestUsername;
        this.requestPhoto = b.requestPhoto;
    }

    @Generated
    public static KeyboardButtonRequestUsersBuilder<?, ?> builder() {
        return new KeyboardButtonRequestUsersBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyboardButtonRequestUsers)) {
            return false;
        }
        KeyboardButtonRequestUsers other = (KeyboardButtonRequestUsers)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$userIsBot = this.getUserIsBot();
        Boolean other$userIsBot = other.getUserIsBot();
        if (this$userIsBot == null ? other$userIsBot != null : !((Object)this$userIsBot).equals(other$userIsBot)) {
            return false;
        }
        Boolean this$userIsPremium = this.getUserIsPremium();
        Boolean other$userIsPremium = other.getUserIsPremium();
        if (this$userIsPremium == null ? other$userIsPremium != null : !((Object)this$userIsPremium).equals(other$userIsPremium)) {
            return false;
        }
        Integer this$maxQuantity = this.getMaxQuantity();
        Integer other$maxQuantity = other.getMaxQuantity();
        if (this$maxQuantity == null ? other$maxQuantity != null : !((Object)this$maxQuantity).equals(other$maxQuantity)) {
            return false;
        }
        Boolean this$requestName = this.getRequestName();
        Boolean other$requestName = other.getRequestName();
        if (this$requestName == null ? other$requestName != null : !((Object)this$requestName).equals(other$requestName)) {
            return false;
        }
        Boolean this$requestUsername = this.getRequestUsername();
        Boolean other$requestUsername = other.getRequestUsername();
        if (this$requestUsername == null ? other$requestUsername != null : !((Object)this$requestUsername).equals(other$requestUsername)) {
            return false;
        }
        Boolean this$requestPhoto = this.getRequestPhoto();
        Boolean other$requestPhoto = other.getRequestPhoto();
        if (this$requestPhoto == null ? other$requestPhoto != null : !((Object)this$requestPhoto).equals(other$requestPhoto)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        return !(this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyboardButtonRequestUsers;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $userIsBot = this.getUserIsBot();
        result = result * 59 + ($userIsBot == null ? 43 : ((Object)$userIsBot).hashCode());
        Boolean $userIsPremium = this.getUserIsPremium();
        result = result * 59 + ($userIsPremium == null ? 43 : ((Object)$userIsPremium).hashCode());
        Integer $maxQuantity = this.getMaxQuantity();
        result = result * 59 + ($maxQuantity == null ? 43 : ((Object)$maxQuantity).hashCode());
        Boolean $requestName = this.getRequestName();
        result = result * 59 + ($requestName == null ? 43 : ((Object)$requestName).hashCode());
        Boolean $requestUsername = this.getRequestUsername();
        result = result * 59 + ($requestUsername == null ? 43 : ((Object)$requestUsername).hashCode());
        Boolean $requestPhoto = this.getRequestPhoto();
        result = result * 59 + ($requestPhoto == null ? 43 : ((Object)$requestPhoto).hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public Boolean getUserIsBot() {
        return this.userIsBot;
    }

    @Generated
    public Boolean getUserIsPremium() {
        return this.userIsPremium;
    }

    @Generated
    public Integer getMaxQuantity() {
        return this.maxQuantity;
    }

    @Generated
    public Boolean getRequestName() {
        return this.requestName;
    }

    @Generated
    public Boolean getRequestUsername() {
        return this.requestUsername;
    }

    @Generated
    public Boolean getRequestPhoto() {
        return this.requestPhoto;
    }

    @JsonProperty(value="request_id")
    @Generated
    public void setRequestId(@NonNull String requestId) {
        if (requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        this.requestId = requestId;
    }

    @JsonProperty(value="user_is_bot")
    @Generated
    public void setUserIsBot(Boolean userIsBot) {
        this.userIsBot = userIsBot;
    }

    @JsonProperty(value="user_is_premium")
    @Generated
    public void setUserIsPremium(Boolean userIsPremium) {
        this.userIsPremium = userIsPremium;
    }

    @JsonProperty(value="max_quantity")
    @Generated
    public void setMaxQuantity(Integer maxQuantity) {
        this.maxQuantity = maxQuantity;
    }

    @JsonProperty(value="request_name")
    @Generated
    public void setRequestName(Boolean requestName) {
        this.requestName = requestName;
    }

    @JsonProperty(value="request_username")
    @Generated
    public void setRequestUsername(Boolean requestUsername) {
        this.requestUsername = requestUsername;
    }

    @JsonProperty(value="request_photo")
    @Generated
    public void setRequestPhoto(Boolean requestPhoto) {
        this.requestPhoto = requestPhoto;
    }

    @Generated
    public String toString() {
        return "KeyboardButtonRequestUsers(requestId=" + this.getRequestId() + ", userIsBot=" + this.getUserIsBot() + ", userIsPremium=" + this.getUserIsPremium() + ", maxQuantity=" + this.getMaxQuantity() + ", requestName=" + this.getRequestName() + ", requestUsername=" + this.getRequestUsername() + ", requestPhoto=" + this.getRequestPhoto() + ")";
    }

    @Generated
    public KeyboardButtonRequestUsers(@NonNull String requestId) {
        if (requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        this.requestId = requestId;
    }

    @Generated
    public KeyboardButtonRequestUsers(@NonNull String requestId, Boolean userIsBot, Boolean userIsPremium, Integer maxQuantity, Boolean requestName, Boolean requestUsername, Boolean requestPhoto) {
        if (requestId == null) {
            throw new NullPointerException("requestId is marked non-null but is null");
        }
        this.requestId = requestId;
        this.userIsBot = userIsBot;
        this.userIsPremium = userIsPremium;
        this.maxQuantity = maxQuantity;
        this.requestName = requestName;
        this.requestUsername = requestUsername;
        this.requestPhoto = requestPhoto;
    }

    @Generated
    public static abstract class KeyboardButtonRequestUsersBuilder<C extends KeyboardButtonRequestUsers, B extends KeyboardButtonRequestUsersBuilder<C, B>> {
        @Generated
        private String requestId;
        @Generated
        private Boolean userIsBot;
        @Generated
        private Boolean userIsPremium;
        @Generated
        private Integer maxQuantity;
        @Generated
        private Boolean requestName;
        @Generated
        private Boolean requestUsername;
        @Generated
        private Boolean requestPhoto;

        @JsonProperty(value="request_id")
        @Generated
        public B requestId(@NonNull String requestId) {
            if (requestId == null) {
                throw new NullPointerException("requestId is marked non-null but is null");
            }
            this.requestId = requestId;
            return this.self();
        }

        @JsonProperty(value="user_is_bot")
        @Generated
        public B userIsBot(Boolean userIsBot) {
            this.userIsBot = userIsBot;
            return this.self();
        }

        @JsonProperty(value="user_is_premium")
        @Generated
        public B userIsPremium(Boolean userIsPremium) {
            this.userIsPremium = userIsPremium;
            return this.self();
        }

        @JsonProperty(value="max_quantity")
        @Generated
        public B maxQuantity(Integer maxQuantity) {
            this.maxQuantity = maxQuantity;
            return this.self();
        }

        @JsonProperty(value="request_name")
        @Generated
        public B requestName(Boolean requestName) {
            this.requestName = requestName;
            return this.self();
        }

        @JsonProperty(value="request_username")
        @Generated
        public B requestUsername(Boolean requestUsername) {
            this.requestUsername = requestUsername;
            return this.self();
        }

        @JsonProperty(value="request_photo")
        @Generated
        public B requestPhoto(Boolean requestPhoto) {
            this.requestPhoto = requestPhoto;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "KeyboardButtonRequestUsers.KeyboardButtonRequestUsersBuilder(requestId=" + this.requestId + ", userIsBot=" + this.userIsBot + ", userIsPremium=" + this.userIsPremium + ", maxQuantity=" + this.maxQuantity + ", requestName=" + this.requestName + ", requestUsername=" + this.requestUsername + ", requestPhoto=" + this.requestPhoto + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class KeyboardButtonRequestUsersBuilderImpl
    extends KeyboardButtonRequestUsersBuilder<KeyboardButtonRequestUsers, KeyboardButtonRequestUsersBuilderImpl> {
        @Generated
        private KeyboardButtonRequestUsersBuilderImpl() {
        }

        @Override
        @Generated
        protected KeyboardButtonRequestUsersBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public KeyboardButtonRequestUsers build() {
            return new KeyboardButtonRequestUsers(this);
        }
    }
}

