/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.LinkPreviewOptions;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InputTextMessageContentBuilderImpl.class)
public class InputTextMessageContent
implements InputMessageContent {
    private static final String MESSAGETEXT_FIELD = "message_text";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String DISABLEWEBPAGEPREVIEW_FIELD = "disable_web_page_preview";
    private static final String ENTITIES_FIELD = "entities";
    private static final String LINK_PREVIEW_OPTIONS_FIELD = "link_preview_options";
    @JsonProperty(value="message_text")
    @NonNull
    private String messageText;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="disable_web_page_preview")
    private Boolean disableWebPagePreview;
    @JsonProperty(value="entities")
    private List<MessageEntity> entities;
    @JsonProperty(value="link_preview_options")
    private LinkPreviewOptions linkPreviewOptions;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.messageText.isEmpty()) {
            throw new TelegramApiValidationException("MessageText parameter can't be empty", this);
        }
        if (this.parseMode != null && this.entities != null && !this.entities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.linkPreviewOptions != null) {
            this.linkPreviewOptions.validate();
        }
    }

    @Generated
    protected InputTextMessageContent(InputTextMessageContentBuilder<?, ?> b) {
        this.messageText = b.messageText;
        if (this.messageText == null) {
            throw new NullPointerException("messageText is marked non-null but is null");
        }
        this.parseMode = b.parseMode;
        this.disableWebPagePreview = b.disableWebPagePreview;
        this.entities = b.entities;
        this.linkPreviewOptions = b.linkPreviewOptions;
    }

    @Generated
    public static InputTextMessageContentBuilder<?, ?> builder() {
        return new InputTextMessageContentBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputTextMessageContent)) {
            return false;
        }
        InputTextMessageContent other = (InputTextMessageContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$disableWebPagePreview = this.getDisableWebPagePreview();
        Boolean other$disableWebPagePreview = other.getDisableWebPagePreview();
        if (this$disableWebPagePreview == null ? other$disableWebPagePreview != null : !((Object)this$disableWebPagePreview).equals(other$disableWebPagePreview)) {
            return false;
        }
        String this$messageText = this.getMessageText();
        String other$messageText = other.getMessageText();
        if (this$messageText == null ? other$messageText != null : !this$messageText.equals(other$messageText)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$entities = this.getEntities();
        List<MessageEntity> other$entities = other.getEntities();
        if (this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities)) {
            return false;
        }
        LinkPreviewOptions this$linkPreviewOptions = this.getLinkPreviewOptions();
        LinkPreviewOptions other$linkPreviewOptions = other.getLinkPreviewOptions();
        return !(this$linkPreviewOptions == null ? other$linkPreviewOptions != null : !((Object)this$linkPreviewOptions).equals(other$linkPreviewOptions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputTextMessageContent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $disableWebPagePreview = this.getDisableWebPagePreview();
        result = result * 59 + ($disableWebPagePreview == null ? 43 : ((Object)$disableWebPagePreview).hashCode());
        String $messageText = this.getMessageText();
        result = result * 59 + ($messageText == null ? 43 : $messageText.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        LinkPreviewOptions $linkPreviewOptions = this.getLinkPreviewOptions();
        result = result * 59 + ($linkPreviewOptions == null ? 43 : ((Object)$linkPreviewOptions).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getMessageText() {
        return this.messageText;
    }

    @Generated
    public String getParseMode() {
        return this.parseMode;
    }

    @Generated
    public Boolean getDisableWebPagePreview() {
        return this.disableWebPagePreview;
    }

    @Generated
    public List<MessageEntity> getEntities() {
        return this.entities;
    }

    @Generated
    public LinkPreviewOptions getLinkPreviewOptions() {
        return this.linkPreviewOptions;
    }

    @JsonProperty(value="message_text")
    @Generated
    public void setMessageText(@NonNull String messageText) {
        if (messageText == null) {
            throw new NullPointerException("messageText is marked non-null but is null");
        }
        this.messageText = messageText;
    }

    @JsonProperty(value="parse_mode")
    @Generated
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="disable_web_page_preview")
    @Generated
    public void setDisableWebPagePreview(Boolean disableWebPagePreview) {
        this.disableWebPagePreview = disableWebPagePreview;
    }

    @JsonProperty(value="entities")
    @Generated
    public void setEntities(List<MessageEntity> entities) {
        this.entities = entities;
    }

    @JsonProperty(value="link_preview_options")
    @Generated
    public void setLinkPreviewOptions(LinkPreviewOptions linkPreviewOptions) {
        this.linkPreviewOptions = linkPreviewOptions;
    }

    @Generated
    public String toString() {
        return "InputTextMessageContent(messageText=" + this.getMessageText() + ", parseMode=" + this.getParseMode() + ", disableWebPagePreview=" + this.getDisableWebPagePreview() + ", entities=" + this.getEntities() + ", linkPreviewOptions=" + this.getLinkPreviewOptions() + ")";
    }

    @Generated
    public InputTextMessageContent(@NonNull String messageText) {
        if (messageText == null) {
            throw new NullPointerException("messageText is marked non-null but is null");
        }
        this.messageText = messageText;
    }

    @Generated
    public InputTextMessageContent(@NonNull String messageText, String parseMode, Boolean disableWebPagePreview, List<MessageEntity> entities, LinkPreviewOptions linkPreviewOptions) {
        if (messageText == null) {
            throw new NullPointerException("messageText is marked non-null but is null");
        }
        this.messageText = messageText;
        this.parseMode = parseMode;
        this.disableWebPagePreview = disableWebPagePreview;
        this.entities = entities;
        this.linkPreviewOptions = linkPreviewOptions;
    }

    @Generated
    public static abstract class InputTextMessageContentBuilder<C extends InputTextMessageContent, B extends InputTextMessageContentBuilder<C, B>> {
        @Generated
        private String messageText;
        @Generated
        private String parseMode;
        @Generated
        private Boolean disableWebPagePreview;
        @Generated
        private List<MessageEntity> entities;
        @Generated
        private LinkPreviewOptions linkPreviewOptions;

        @JsonProperty(value="message_text")
        @Generated
        public B messageText(@NonNull String messageText) {
            if (messageText == null) {
                throw new NullPointerException("messageText is marked non-null but is null");
            }
            this.messageText = messageText;
            return this.self();
        }

        @JsonProperty(value="parse_mode")
        @Generated
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this.self();
        }

        @JsonProperty(value="disable_web_page_preview")
        @Generated
        public B disableWebPagePreview(Boolean disableWebPagePreview) {
            this.disableWebPagePreview = disableWebPagePreview;
            return this.self();
        }

        @JsonProperty(value="entities")
        @Generated
        public B entities(List<MessageEntity> entities) {
            this.entities = entities;
            return this.self();
        }

        @JsonProperty(value="link_preview_options")
        @Generated
        public B linkPreviewOptions(LinkPreviewOptions linkPreviewOptions) {
            this.linkPreviewOptions = linkPreviewOptions;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InputTextMessageContent.InputTextMessageContentBuilder(messageText=" + this.messageText + ", parseMode=" + this.parseMode + ", disableWebPagePreview=" + this.disableWebPagePreview + ", entities=" + this.entities + ", linkPreviewOptions=" + this.linkPreviewOptions + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class InputTextMessageContentBuilderImpl
    extends InputTextMessageContentBuilder<InputTextMessageContent, InputTextMessageContentBuilderImpl> {
        @Generated
        private InputTextMessageContentBuilderImpl() {
        }

        @Override
        @Generated
        protected InputTextMessageContentBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InputTextMessageContent build() {
            return new InputTextMessageContent(this);
        }
    }
}

