/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.checklist;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=InputChecklistTaskBuilderImpl.class)
public class InputChecklistTask
implements BotApiObject,
Validable {
    private static final String ID_FIELD = "id";
    private static final String TEXT_FIELD = "text";
    private static final String PARSE_MODE_FIELD = "parse_mode";
    private static final String TEXT_ENTITIES_FIELD = "text_entities";
    @JsonProperty(value="id")
    @NonNull
    private Integer id;
    @JsonProperty(value="text")
    @NonNull
    private String text;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="text_entities")
    private List<MessageEntity> textEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id == null || this.id <= 0) {
            throw new TelegramApiValidationException("Task id must be positive", this);
        }
        if (this.text == null || this.text.isEmpty()) {
            throw new TelegramApiValidationException("Task text can't be empty", this);
        }
        if (this.text.length() > 100) {
            throw new TelegramApiValidationException("Task text can't be longer than 100 characters", this);
        }
    }

    @Generated
    protected InputChecklistTask(InputChecklistTaskBuilder<?, ?> b) {
        this.id = b.id;
        if (this.id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.text = b.text;
        if (this.text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.parseMode = b.parseMode;
        this.textEntities = b.textEntities;
    }

    @Generated
    public static InputChecklistTaskBuilder<?, ?> builder() {
        return new InputChecklistTaskBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputChecklistTask)) {
            return false;
        }
        InputChecklistTask other = (InputChecklistTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$textEntities = this.getTextEntities();
        List<MessageEntity> other$textEntities = other.getTextEntities();
        return !(this$textEntities == null ? other$textEntities != null : !((Object)this$textEntities).equals(other$textEntities));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputChecklistTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $textEntities = this.getTextEntities();
        result = result * 59 + ($textEntities == null ? 43 : ((Object)$textEntities).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public Integer getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public String getParseMode() {
        return this.parseMode;
    }

    @Generated
    public List<MessageEntity> getTextEntities() {
        return this.textEntities;
    }

    @JsonProperty(value="id")
    @Generated
    public void setId(@NonNull Integer id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="text")
    @Generated
    public void setText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @JsonProperty(value="parse_mode")
    @Generated
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="text_entities")
    @Generated
    public void setTextEntities(List<MessageEntity> textEntities) {
        this.textEntities = textEntities;
    }

    @Generated
    public String toString() {
        return "InputChecklistTask(id=" + this.getId() + ", text=" + this.getText() + ", parseMode=" + this.getParseMode() + ", textEntities=" + this.getTextEntities() + ")";
    }

    @Generated
    public InputChecklistTask() {
    }

    @Generated
    public InputChecklistTask(@NonNull Integer id, @NonNull String text) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.id = id;
        this.text = text;
    }

    @Generated
    public InputChecklistTask(@NonNull Integer id, @NonNull String text, String parseMode, List<MessageEntity> textEntities) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.id = id;
        this.text = text;
        this.parseMode = parseMode;
        this.textEntities = textEntities;
    }

    @Generated
    public static abstract class InputChecklistTaskBuilder<C extends InputChecklistTask, B extends InputChecklistTaskBuilder<C, B>> {
        @Generated
        private Integer id;
        @Generated
        private String text;
        @Generated
        private String parseMode;
        @Generated
        private List<MessageEntity> textEntities;

        @JsonProperty(value="id")
        @Generated
        public B id(@NonNull Integer id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this.self();
        }

        @JsonProperty(value="text")
        @Generated
        public B text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return this.self();
        }

        @JsonProperty(value="parse_mode")
        @Generated
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this.self();
        }

        @JsonProperty(value="text_entities")
        @Generated
        public B textEntities(List<MessageEntity> textEntities) {
            this.textEntities = textEntities;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InputChecklistTask.InputChecklistTaskBuilder(id=" + this.id + ", text=" + this.text + ", parseMode=" + this.parseMode + ", textEntities=" + this.textEntities + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class InputChecklistTaskBuilderImpl
    extends InputChecklistTaskBuilder<InputChecklistTask, InputChecklistTaskBuilderImpl> {
        @Generated
        private InputChecklistTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected InputChecklistTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InputChecklistTask build() {
            return new InputChecklistTask(this);
        }
    }
}

