/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.checklist;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.checklist.InputChecklistTask;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=InputChecklistBuilderImpl.class)
public class InputChecklist
implements BotApiObject,
Validable {
    private static final String TITLE_FIELD = "title";
    private static final String PARSE_MODE_FIELD = "parse_mode";
    private static final String TITLE_ENTITIES_FIELD = "title_entities";
    private static final String TASKS_FIELD = "tasks";
    private static final String OTHERS_CAN_ADD_TASKS_FIELD = "others_can_add_tasks";
    private static final String OTHERS_CAN_MARK_TASKS_AS_DONE_FIELD = "others_can_mark_tasks_as_done";
    @JsonProperty(value="title")
    @NonNull
    private String title;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="title_entities")
    private List<MessageEntity> titleEntities;
    @JsonProperty(value="tasks")
    @NonNull
    private List<InputChecklistTask> tasks;
    @JsonProperty(value="others_can_add_tasks")
    private Boolean othersCanAddTasks;
    @JsonProperty(value="others_can_mark_tasks_as_done")
    private Boolean othersCanMarkTasksAsDone;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.title == null || this.title.isEmpty()) {
            throw new TelegramApiValidationException("Checklist title can't be empty", this);
        }
        if (this.title.length() > 255) {
            throw new TelegramApiValidationException("Checklist title can't be longer than 255 characters", this);
        }
        if (this.tasks == null || this.tasks.isEmpty()) {
            throw new TelegramApiValidationException("Checklist tasks can't be empty", this);
        }
        if (this.tasks.size() > 30) {
            throw new TelegramApiValidationException("Checklist can't have more than 30 tasks", this);
        }
        for (InputChecklistTask task : this.tasks) {
            task.validate();
        }
    }

    @Generated
    protected InputChecklist(InputChecklistBuilder<?, ?> b) {
        this.title = b.title;
        if (this.title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.parseMode = b.parseMode;
        this.titleEntities = b.titleEntities;
        this.tasks = b.tasks;
        if (this.tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        this.othersCanAddTasks = b.othersCanAddTasks;
        this.othersCanMarkTasksAsDone = b.othersCanMarkTasksAsDone;
    }

    @Generated
    public static InputChecklistBuilder<?, ?> builder() {
        return new InputChecklistBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputChecklist)) {
            return false;
        }
        InputChecklist other = (InputChecklist)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$othersCanAddTasks = this.getOthersCanAddTasks();
        Boolean other$othersCanAddTasks = other.getOthersCanAddTasks();
        if (this$othersCanAddTasks == null ? other$othersCanAddTasks != null : !((Object)this$othersCanAddTasks).equals(other$othersCanAddTasks)) {
            return false;
        }
        Boolean this$othersCanMarkTasksAsDone = this.getOthersCanMarkTasksAsDone();
        Boolean other$othersCanMarkTasksAsDone = other.getOthersCanMarkTasksAsDone();
        if (this$othersCanMarkTasksAsDone == null ? other$othersCanMarkTasksAsDone != null : !((Object)this$othersCanMarkTasksAsDone).equals(other$othersCanMarkTasksAsDone)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$titleEntities = this.getTitleEntities();
        List<MessageEntity> other$titleEntities = other.getTitleEntities();
        if (this$titleEntities == null ? other$titleEntities != null : !((Object)this$titleEntities).equals(other$titleEntities)) {
            return false;
        }
        List<InputChecklistTask> this$tasks = this.getTasks();
        List<InputChecklistTask> other$tasks = other.getTasks();
        return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputChecklist;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $othersCanAddTasks = this.getOthersCanAddTasks();
        result = result * 59 + ($othersCanAddTasks == null ? 43 : ((Object)$othersCanAddTasks).hashCode());
        Boolean $othersCanMarkTasksAsDone = this.getOthersCanMarkTasksAsDone();
        result = result * 59 + ($othersCanMarkTasksAsDone == null ? 43 : ((Object)$othersCanMarkTasksAsDone).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $titleEntities = this.getTitleEntities();
        result = result * 59 + ($titleEntities == null ? 43 : ((Object)$titleEntities).hashCode());
        List<InputChecklistTask> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getParseMode() {
        return this.parseMode;
    }

    @Generated
    public List<MessageEntity> getTitleEntities() {
        return this.titleEntities;
    }

    @NonNull
    @Generated
    public List<InputChecklistTask> getTasks() {
        return this.tasks;
    }

    @Generated
    public Boolean getOthersCanAddTasks() {
        return this.othersCanAddTasks;
    }

    @Generated
    public Boolean getOthersCanMarkTasksAsDone() {
        return this.othersCanMarkTasksAsDone;
    }

    @JsonProperty(value="title")
    @Generated
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @JsonProperty(value="parse_mode")
    @Generated
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="title_entities")
    @Generated
    public void setTitleEntities(List<MessageEntity> titleEntities) {
        this.titleEntities = titleEntities;
    }

    @JsonProperty(value="tasks")
    @Generated
    public void setTasks(@NonNull List<InputChecklistTask> tasks) {
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        this.tasks = tasks;
    }

    @JsonProperty(value="others_can_add_tasks")
    @Generated
    public void setOthersCanAddTasks(Boolean othersCanAddTasks) {
        this.othersCanAddTasks = othersCanAddTasks;
    }

    @JsonProperty(value="others_can_mark_tasks_as_done")
    @Generated
    public void setOthersCanMarkTasksAsDone(Boolean othersCanMarkTasksAsDone) {
        this.othersCanMarkTasksAsDone = othersCanMarkTasksAsDone;
    }

    @Generated
    public String toString() {
        return "InputChecklist(title=" + this.getTitle() + ", parseMode=" + this.getParseMode() + ", titleEntities=" + this.getTitleEntities() + ", tasks=" + this.getTasks() + ", othersCanAddTasks=" + this.getOthersCanAddTasks() + ", othersCanMarkTasksAsDone=" + this.getOthersCanMarkTasksAsDone() + ")";
    }

    @Generated
    public InputChecklist() {
    }

    @Generated
    public InputChecklist(@NonNull String title, @NonNull List<InputChecklistTask> tasks) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        this.title = title;
        this.tasks = tasks;
    }

    @Generated
    public InputChecklist(@NonNull String title, String parseMode, List<MessageEntity> titleEntities, @NonNull List<InputChecklistTask> tasks, Boolean othersCanAddTasks, Boolean othersCanMarkTasksAsDone) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        this.title = title;
        this.parseMode = parseMode;
        this.titleEntities = titleEntities;
        this.tasks = tasks;
        this.othersCanAddTasks = othersCanAddTasks;
        this.othersCanMarkTasksAsDone = othersCanMarkTasksAsDone;
    }

    @Generated
    public static abstract class InputChecklistBuilder<C extends InputChecklist, B extends InputChecklistBuilder<C, B>> {
        @Generated
        private String title;
        @Generated
        private String parseMode;
        @Generated
        private List<MessageEntity> titleEntities;
        @Generated
        private List<InputChecklistTask> tasks;
        @Generated
        private Boolean othersCanAddTasks;
        @Generated
        private Boolean othersCanMarkTasksAsDone;

        @JsonProperty(value="title")
        @Generated
        public B title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this.self();
        }

        @JsonProperty(value="parse_mode")
        @Generated
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this.self();
        }

        @JsonProperty(value="title_entities")
        @Generated
        public B titleEntities(List<MessageEntity> titleEntities) {
            this.titleEntities = titleEntities;
            return this.self();
        }

        @JsonProperty(value="tasks")
        @Generated
        public B tasks(@NonNull List<InputChecklistTask> tasks) {
            if (tasks == null) {
                throw new NullPointerException("tasks is marked non-null but is null");
            }
            this.tasks = tasks;
            return this.self();
        }

        @JsonProperty(value="others_can_add_tasks")
        @Generated
        public B othersCanAddTasks(Boolean othersCanAddTasks) {
            this.othersCanAddTasks = othersCanAddTasks;
            return this.self();
        }

        @JsonProperty(value="others_can_mark_tasks_as_done")
        @Generated
        public B othersCanMarkTasksAsDone(Boolean othersCanMarkTasksAsDone) {
            this.othersCanMarkTasksAsDone = othersCanMarkTasksAsDone;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "InputChecklist.InputChecklistBuilder(title=" + this.title + ", parseMode=" + this.parseMode + ", titleEntities=" + this.titleEntities + ", tasks=" + this.tasks + ", othersCanAddTasks=" + this.othersCanAddTasks + ", othersCanMarkTasksAsDone=" + this.othersCanMarkTasksAsDone + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class InputChecklistBuilderImpl
    extends InputChecklistBuilder<InputChecklist, InputChecklistBuilderImpl> {
        @Generated
        private InputChecklistBuilderImpl() {
        }

        @Override
        @Generated
        protected InputChecklistBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InputChecklist build() {
            return new InputChecklist(this);
        }
    }
}

