/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.suggestedpost;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=ApproveSuggestedPostBuilderImpl.class)
public class ApproveSuggestedPost
extends BotApiMethod<Boolean> {
    public static final String PATH = "approveSuggestedPost";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_ID_FIELD = "message_id";
    private static final String SEND_DATE_FIELD = "send_date";
    @JsonProperty(value="chat_id")
    @NonNull
    private Integer chatId;
    @JsonProperty(value="message_id")
    @NonNull
    private Integer messageId;
    @JsonProperty(value="send_date")
    private Integer sendDate;

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Boolean.class);
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.messageId == null) {
            throw new TelegramApiValidationException("MessageId parameter can't be empty", this);
        }
        if (this.sendDate != null) {
            long currentTime = System.currentTimeMillis() / 1000L;
            if ((long)this.sendDate.intValue() > currentTime + 2678400L) {
                throw new TelegramApiValidationException("SendDate can't be more than 30 days in the future", this);
            }
        }
    }

    @Generated
    protected ApproveSuggestedPost(ApproveSuggestedPostBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageId = b.messageId;
        if (this.messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.sendDate = b.sendDate;
    }

    @Generated
    public static ApproveSuggestedPostBuilder<?, ?> builder() {
        return new ApproveSuggestedPostBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApproveSuggestedPost)) {
            return false;
        }
        ApproveSuggestedPost other = (ApproveSuggestedPost)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$chatId = this.getChatId();
        Integer other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !((Object)this$chatId).equals(other$chatId)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Integer this$sendDate = this.getSendDate();
        Integer other$sendDate = other.getSendDate();
        return !(this$sendDate == null ? other$sendDate != null : !((Object)this$sendDate).equals(other$sendDate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApproveSuggestedPost;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : ((Object)$chatId).hashCode());
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Integer $sendDate = this.getSendDate();
        result = result * 59 + ($sendDate == null ? 43 : ((Object)$sendDate).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public Integer getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public Integer getMessageId() {
        return this.messageId;
    }

    @Generated
    public Integer getSendDate() {
        return this.sendDate;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull Integer chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    @Generated
    public void setMessageId(@NonNull Integer messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
    }

    @JsonProperty(value="send_date")
    @Generated
    public void setSendDate(Integer sendDate) {
        this.sendDate = sendDate;
    }

    @Generated
    public String toString() {
        return "ApproveSuggestedPost(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", sendDate=" + this.getSendDate() + ")";
    }

    @Generated
    protected ApproveSuggestedPost() {
    }

    @Generated
    public ApproveSuggestedPost(@NonNull Integer chatId, @NonNull Integer messageId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
    }

    @Generated
    public ApproveSuggestedPost(@NonNull Integer chatId, @NonNull Integer messageId, Integer sendDate) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
        this.sendDate = sendDate;
    }

    @Generated
    public static abstract class ApproveSuggestedPostBuilder<C extends ApproveSuggestedPost, B extends ApproveSuggestedPostBuilder<C, B>>
    extends BotApiMethod.BotApiMethodBuilder<Boolean, C, B> {
        @Generated
        private Integer chatId;
        @Generated
        private Integer messageId;
        @Generated
        private Integer sendDate;

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull Integer chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_id")
        @Generated
        public B messageId(@NonNull Integer messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
            return (B)this.self();
        }

        @JsonProperty(value="send_date")
        @Generated
        public B sendDate(Integer sendDate) {
            this.sendDate = sendDate;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ApproveSuggestedPost.ApproveSuggestedPostBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageId=" + this.messageId + ", sendDate=" + this.sendDate + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class ApproveSuggestedPostBuilderImpl
    extends ApproveSuggestedPostBuilder<ApproveSuggestedPost, ApproveSuggestedPostBuilderImpl> {
        @Generated
        private ApproveSuggestedPostBuilderImpl() {
        }

        @Override
        @Generated
        protected ApproveSuggestedPostBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ApproveSuggestedPost build() {
            return new ApproveSuggestedPost(this);
        }
    }
}

