/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stories;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.stories.Story;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class RepostStory
extends BotApiMethod<Story> {
    public static final String PATH = "repostStory";
    private static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    private static final String FROM_CHAT_ID_FIELD = "from_chat_id";
    private static final String FROM_STORY_ID_FIELD = "from_story_id";
    private static final String ACTIVE_PERIOD_FIELD = "active_period";
    private static final String POST_TO_CHAT_PAGE_FIELD = "post_to_chat_page";
    private static final String PROTECT_CONTENT_FIELD = "protect_content";
    @JsonProperty(value="business_connection_id")
    @NonNull
    private String businessConnectionId;
    @JsonProperty(value="from_chat_id")
    @NonNull
    private Long fromChatId;
    @JsonProperty(value="from_story_id")
    @NonNull
    private Integer fromStoryId;
    @JsonProperty(value="active_period")
    @NonNull
    private Integer activePeriod;
    @JsonProperty(value="post_to_chat_page")
    private Boolean postToChatPage;
    @JsonProperty(value="protect_content")
    private Boolean protectContent;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Story deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Story.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.businessConnectionId == null || this.businessConnectionId.isEmpty()) {
            throw new TelegramApiValidationException("BusinessConnectionId can't be empty", this);
        }
        if (this.fromChatId == null || this.fromChatId == 0L) {
            throw new TelegramApiValidationException("FromChatId can't be empty", this);
        }
        if (this.fromStoryId == null || this.fromStoryId == 0) {
            throw new TelegramApiValidationException("FromStoryId can't be empty", this);
        }
        if (this.activePeriod == null) {
            throw new TelegramApiValidationException("ActivePeriod can't be null", this);
        }
        if (this.activePeriod != 21600 && this.activePeriod != 43200 && this.activePeriod != 86400 && this.activePeriod != 172800) {
            throw new TelegramApiValidationException("ActivePeriod must be one of 6*3600, 12*3600, 86400, or 2*86400", this);
        }
    }

    @Generated
    public static RepostStoryBuilder builder() {
        return new RepostStoryBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepostStory)) {
            return false;
        }
        RepostStory other = (RepostStory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$fromChatId = this.getFromChatId();
        Long other$fromChatId = other.getFromChatId();
        if (this$fromChatId == null ? other$fromChatId != null : !((Object)this$fromChatId).equals(other$fromChatId)) {
            return false;
        }
        Integer this$fromStoryId = this.getFromStoryId();
        Integer other$fromStoryId = other.getFromStoryId();
        if (this$fromStoryId == null ? other$fromStoryId != null : !((Object)this$fromStoryId).equals(other$fromStoryId)) {
            return false;
        }
        Integer this$activePeriod = this.getActivePeriod();
        Integer other$activePeriod = other.getActivePeriod();
        if (this$activePeriod == null ? other$activePeriod != null : !((Object)this$activePeriod).equals(other$activePeriod)) {
            return false;
        }
        Boolean this$postToChatPage = this.getPostToChatPage();
        Boolean other$postToChatPage = other.getPostToChatPage();
        if (this$postToChatPage == null ? other$postToChatPage != null : !((Object)this$postToChatPage).equals(other$postToChatPage)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        return !(this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RepostStory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $fromChatId = this.getFromChatId();
        result = result * 59 + ($fromChatId == null ? 43 : ((Object)$fromChatId).hashCode());
        Integer $fromStoryId = this.getFromStoryId();
        result = result * 59 + ($fromStoryId == null ? 43 : ((Object)$fromStoryId).hashCode());
        Integer $activePeriod = this.getActivePeriod();
        result = result * 59 + ($activePeriod == null ? 43 : ((Object)$activePeriod).hashCode());
        Boolean $postToChatPage = this.getPostToChatPage();
        result = result * 59 + ($postToChatPage == null ? 43 : ((Object)$postToChatPage).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @NonNull
    @Generated
    public Long getFromChatId() {
        return this.fromChatId;
    }

    @NonNull
    @Generated
    public Integer getFromStoryId() {
        return this.fromStoryId;
    }

    @NonNull
    @Generated
    public Integer getActivePeriod() {
        return this.activePeriod;
    }

    @Generated
    public Boolean getPostToChatPage() {
        return this.postToChatPage;
    }

    @Generated
    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(@NonNull String businessConnectionId) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
    }

    @JsonProperty(value="from_chat_id")
    @Generated
    public void setFromChatId(@NonNull Long fromChatId) {
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        this.fromChatId = fromChatId;
    }

    @JsonProperty(value="from_story_id")
    @Generated
    public void setFromStoryId(@NonNull Integer fromStoryId) {
        if (fromStoryId == null) {
            throw new NullPointerException("fromStoryId is marked non-null but is null");
        }
        this.fromStoryId = fromStoryId;
    }

    @JsonProperty(value="active_period")
    @Generated
    public void setActivePeriod(@NonNull Integer activePeriod) {
        if (activePeriod == null) {
            throw new NullPointerException("activePeriod is marked non-null but is null");
        }
        this.activePeriod = activePeriod;
    }

    @JsonProperty(value="post_to_chat_page")
    @Generated
    public void setPostToChatPage(Boolean postToChatPage) {
        this.postToChatPage = postToChatPage;
    }

    @JsonProperty(value="protect_content")
    @Generated
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @Generated
    public String toString() {
        return "RepostStory(businessConnectionId=" + this.getBusinessConnectionId() + ", fromChatId=" + this.getFromChatId() + ", fromStoryId=" + this.getFromStoryId() + ", activePeriod=" + this.getActivePeriod() + ", postToChatPage=" + this.getPostToChatPage() + ", protectContent=" + this.getProtectContent() + ")";
    }

    @Generated
    public RepostStory() {
    }

    @Generated
    public RepostStory(@NonNull String businessConnectionId, @NonNull Long fromChatId, @NonNull Integer fromStoryId, @NonNull Integer activePeriod) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        if (fromStoryId == null) {
            throw new NullPointerException("fromStoryId is marked non-null but is null");
        }
        if (activePeriod == null) {
            throw new NullPointerException("activePeriod is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
        this.fromChatId = fromChatId;
        this.fromStoryId = fromStoryId;
        this.activePeriod = activePeriod;
    }

    @Generated
    public RepostStory(@NonNull String businessConnectionId, @NonNull Long fromChatId, @NonNull Integer fromStoryId, @NonNull Integer activePeriod, Boolean postToChatPage, Boolean protectContent) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        if (fromStoryId == null) {
            throw new NullPointerException("fromStoryId is marked non-null but is null");
        }
        if (activePeriod == null) {
            throw new NullPointerException("activePeriod is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
        this.fromChatId = fromChatId;
        this.fromStoryId = fromStoryId;
        this.activePeriod = activePeriod;
        this.postToChatPage = postToChatPage;
        this.protectContent = protectContent;
    }

    @Generated
    public static class RepostStoryBuilder {
        @Generated
        private String businessConnectionId;
        @Generated
        private Long fromChatId;
        @Generated
        private Integer fromStoryId;
        @Generated
        private Integer activePeriod;
        @Generated
        private Boolean postToChatPage;
        @Generated
        private Boolean protectContent;

        @Generated
        RepostStoryBuilder() {
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public RepostStoryBuilder businessConnectionId(@NonNull String businessConnectionId) {
            if (businessConnectionId == null) {
                throw new NullPointerException("businessConnectionId is marked non-null but is null");
            }
            this.businessConnectionId = businessConnectionId;
            return this;
        }

        @JsonProperty(value="from_chat_id")
        @Generated
        public RepostStoryBuilder fromChatId(@NonNull Long fromChatId) {
            if (fromChatId == null) {
                throw new NullPointerException("fromChatId is marked non-null but is null");
            }
            this.fromChatId = fromChatId;
            return this;
        }

        @JsonProperty(value="from_story_id")
        @Generated
        public RepostStoryBuilder fromStoryId(@NonNull Integer fromStoryId) {
            if (fromStoryId == null) {
                throw new NullPointerException("fromStoryId is marked non-null but is null");
            }
            this.fromStoryId = fromStoryId;
            return this;
        }

        @JsonProperty(value="active_period")
        @Generated
        public RepostStoryBuilder activePeriod(@NonNull Integer activePeriod) {
            if (activePeriod == null) {
                throw new NullPointerException("activePeriod is marked non-null but is null");
            }
            this.activePeriod = activePeriod;
            return this;
        }

        @JsonProperty(value="post_to_chat_page")
        @Generated
        public RepostStoryBuilder postToChatPage(Boolean postToChatPage) {
            this.postToChatPage = postToChatPage;
            return this;
        }

        @JsonProperty(value="protect_content")
        @Generated
        public RepostStoryBuilder protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return this;
        }

        @Generated
        public RepostStory build() {
            return new RepostStory(this.businessConnectionId, this.fromChatId, this.fromStoryId, this.activePeriod, this.postToChatPage, this.protectContent);
        }

        @Generated
        public String toString() {
            return "RepostStory.RepostStoryBuilder(businessConnectionId=" + this.businessConnectionId + ", fromChatId=" + this.fromChatId + ", fromStoryId=" + this.fromStoryId + ", activePeriod=" + this.activePeriod + ", postToChatPage=" + this.postToChatPage + ", protectContent=" + this.protectContent + ")";
        }
    }
}

