/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.send.SendMediaBotMethod;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.message.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.suggestedpost.SuggestedPostParameters;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=SendVideoBuilderImpl.class)
public class SendVideo
extends SendMediaBotMethod<Message> {
    public static final String PATH = "sendvideo";
    public static final String VIDEO_FIELD = "video";
    public static final String DURATION_FIELD = "duration";
    public static final String CAPTION_FIELD = "caption";
    public static final String WIDTH_FIELD = "width";
    public static final String HEIGHT_FIELD = "height";
    public static final String SUPPORTS_STREAMING_FIELD = "supports_streaming";
    public static final String PARSE_MODE_FIELD = "parse_mode";
    public static final String THUMBNAIL_FIELD = "thumbnail";
    public static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    public static final String HAS_SPOILER_FIELD = "has_spoiler";
    public static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    public static final String SHOW_CAPTION_ABOVE_MEDIA_FIELD = "show_caption_above_media";
    public static final String COVER_FIELD = "cover";
    public static final String START_TIMESTAMP_FIELD = "start_timestamp";
    @NonNull
    private String chatId;
    private Integer messageThreadId;
    private Integer directMessagesTopicId;
    @NonNull
    private InputFile video;
    private Integer duration;
    private String caption;
    private Integer width;
    private Integer height;
    private Boolean supportsStreaming;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;
    private String parseMode;
    private InputFile thumbnail;
    private List<MessageEntity> captionEntities;
    private Boolean allowSendingWithoutReply;
    private Boolean protectContent;
    private Boolean hasSpoiler;
    private ReplyParameters replyParameters;
    private String businessConnectionId;
    private String messageEffectId;
    private Boolean showCaptionAboveMedia;
    private Boolean allowPaidBroadcast;
    private InputFile cover;
    private Integer startTimestamp;
    private SuggestedPostParameters suggestedPostParameters;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = false;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Message.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredChatId(this.chatId, this);
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        this.video.validate();
        if (this.thumbnail != null) {
            this.thumbnail.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
        if (this.cover != null) {
            this.cover.validate();
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public InputFile getFile() {
        return this.video;
    }

    @Override
    public String getFileField() {
        return VIDEO_FIELD;
    }

    @Generated
    protected SendVideo(SendVideoBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        this.directMessagesTopicId = b.directMessagesTopicId;
        this.video = b.video;
        if (this.video == null) {
            throw new NullPointerException("video is marked non-null but is null");
        }
        this.duration = b.duration;
        this.caption = b.caption;
        this.width = b.width;
        this.height = b.height;
        this.supportsStreaming = b.supportsStreaming;
        this.disableNotification = b.disableNotification;
        this.replyToMessageId = b.replyToMessageId;
        this.replyMarkup = b.replyMarkup;
        this.parseMode = b.parseMode;
        this.thumbnail = b.thumbnail;
        this.captionEntities = switch (b.captionEntities == null ? 0 : b.captionEntities.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.captionEntities.get(0));
            default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(b.captionEntities));
        };
        this.allowSendingWithoutReply = b.allowSendingWithoutReply;
        this.protectContent = b.protectContent;
        this.hasSpoiler = b.hasSpoiler;
        this.replyParameters = b.replyParameters;
        this.businessConnectionId = b.businessConnectionId;
        this.messageEffectId = b.messageEffectId;
        this.showCaptionAboveMedia = b.showCaptionAboveMedia;
        this.allowPaidBroadcast = b.allowPaidBroadcast;
        this.cover = b.cover;
        this.startTimestamp = b.startTimestamp;
        this.suggestedPostParameters = b.suggestedPostParameters;
    }

    @Generated
    public static SendVideoBuilder<?, ?> builder() {
        return new SendVideoBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendVideo)) {
            return false;
        }
        SendVideo other = (SendVideo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Integer this$directMessagesTopicId = this.getDirectMessagesTopicId();
        Integer other$directMessagesTopicId = other.getDirectMessagesTopicId();
        if (this$directMessagesTopicId == null ? other$directMessagesTopicId != null : !((Object)this$directMessagesTopicId).equals(other$directMessagesTopicId)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Boolean this$supportsStreaming = this.getSupportsStreaming();
        Boolean other$supportsStreaming = other.getSupportsStreaming();
        if (this$supportsStreaming == null ? other$supportsStreaming != null : !((Object)this$supportsStreaming).equals(other$supportsStreaming)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        Boolean this$hasSpoiler = this.getHasSpoiler();
        Boolean other$hasSpoiler = other.getHasSpoiler();
        if (this$hasSpoiler == null ? other$hasSpoiler != null : !((Object)this$hasSpoiler).equals(other$hasSpoiler)) {
            return false;
        }
        Boolean this$showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        Boolean other$showCaptionAboveMedia = other.getShowCaptionAboveMedia();
        if (this$showCaptionAboveMedia == null ? other$showCaptionAboveMedia != null : !((Object)this$showCaptionAboveMedia).equals(other$showCaptionAboveMedia)) {
            return false;
        }
        Boolean this$allowPaidBroadcast = this.getAllowPaidBroadcast();
        Boolean other$allowPaidBroadcast = other.getAllowPaidBroadcast();
        if (this$allowPaidBroadcast == null ? other$allowPaidBroadcast != null : !((Object)this$allowPaidBroadcast).equals(other$allowPaidBroadcast)) {
            return false;
        }
        Integer this$startTimestamp = this.getStartTimestamp();
        Integer other$startTimestamp = other.getStartTimestamp();
        if (this$startTimestamp == null ? other$startTimestamp != null : !((Object)this$startTimestamp).equals(other$startTimestamp)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        InputFile this$video = this.getVideo();
        InputFile other$video = other.getVideo();
        if (this$video == null ? other$video != null : !((Object)this$video).equals(other$video)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        InputFile this$thumbnail = this.getThumbnail();
        InputFile other$thumbnail = other.getThumbnail();
        if (this$thumbnail == null ? other$thumbnail != null : !((Object)this$thumbnail).equals(other$thumbnail)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        if (this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        if (this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        if (this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId)) {
            return false;
        }
        String this$messageEffectId = this.getMessageEffectId();
        String other$messageEffectId = other.getMessageEffectId();
        if (this$messageEffectId == null ? other$messageEffectId != null : !this$messageEffectId.equals(other$messageEffectId)) {
            return false;
        }
        InputFile this$cover = this.getCover();
        InputFile other$cover = other.getCover();
        if (this$cover == null ? other$cover != null : !((Object)this$cover).equals(other$cover)) {
            return false;
        }
        SuggestedPostParameters this$suggestedPostParameters = this.getSuggestedPostParameters();
        SuggestedPostParameters other$suggestedPostParameters = other.getSuggestedPostParameters();
        return !(this$suggestedPostParameters == null ? other$suggestedPostParameters != null : !((Object)this$suggestedPostParameters).equals(other$suggestedPostParameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SendVideo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Integer $directMessagesTopicId = this.getDirectMessagesTopicId();
        result = result * 59 + ($directMessagesTopicId == null ? 43 : ((Object)$directMessagesTopicId).hashCode());
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Boolean $supportsStreaming = this.getSupportsStreaming();
        result = result * 59 + ($supportsStreaming == null ? 43 : ((Object)$supportsStreaming).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        Boolean $hasSpoiler = this.getHasSpoiler();
        result = result * 59 + ($hasSpoiler == null ? 43 : ((Object)$hasSpoiler).hashCode());
        Boolean $showCaptionAboveMedia = this.getShowCaptionAboveMedia();
        result = result * 59 + ($showCaptionAboveMedia == null ? 43 : ((Object)$showCaptionAboveMedia).hashCode());
        Boolean $allowPaidBroadcast = this.getAllowPaidBroadcast();
        result = result * 59 + ($allowPaidBroadcast == null ? 43 : ((Object)$allowPaidBroadcast).hashCode());
        Integer $startTimestamp = this.getStartTimestamp();
        result = result * 59 + ($startTimestamp == null ? 43 : ((Object)$startTimestamp).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        InputFile $video = this.getVideo();
        result = result * 59 + ($video == null ? 43 : ((Object)$video).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        InputFile $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : ((Object)$thumbnail).hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        String $messageEffectId = this.getMessageEffectId();
        result = result * 59 + ($messageEffectId == null ? 43 : $messageEffectId.hashCode());
        InputFile $cover = this.getCover();
        result = result * 59 + ($cover == null ? 43 : ((Object)$cover).hashCode());
        SuggestedPostParameters $suggestedPostParameters = this.getSuggestedPostParameters();
        result = result * 59 + ($suggestedPostParameters == null ? 43 : ((Object)$suggestedPostParameters).hashCode());
        return result;
    }

    @Override
    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @Override
    @Generated
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @Override
    @Generated
    public Integer getDirectMessagesTopicId() {
        return this.directMessagesTopicId;
    }

    @NonNull
    @Generated
    public InputFile getVideo() {
        return this.video;
    }

    @Generated
    public Integer getDuration() {
        return this.duration;
    }

    @Generated
    public String getCaption() {
        return this.caption;
    }

    @Generated
    public Integer getWidth() {
        return this.width;
    }

    @Generated
    public Integer getHeight() {
        return this.height;
    }

    @Generated
    public Boolean getSupportsStreaming() {
        return this.supportsStreaming;
    }

    @Override
    @Generated
    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    @Override
    @Generated
    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    @Override
    @Generated
    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    @Generated
    public String getParseMode() {
        return this.parseMode;
    }

    @Generated
    public InputFile getThumbnail() {
        return this.thumbnail;
    }

    @Generated
    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @Override
    @Generated
    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    @Override
    @Generated
    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @Generated
    public Boolean getHasSpoiler() {
        return this.hasSpoiler;
    }

    @Override
    @Generated
    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @Override
    @Generated
    public String getMessageEffectId() {
        return this.messageEffectId;
    }

    @Generated
    public Boolean getShowCaptionAboveMedia() {
        return this.showCaptionAboveMedia;
    }

    @Override
    @Generated
    public Boolean getAllowPaidBroadcast() {
        return this.allowPaidBroadcast;
    }

    @Generated
    public InputFile getCover() {
        return this.cover;
    }

    @Generated
    public Integer getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    @Generated
    public SuggestedPostParameters getSuggestedPostParameters() {
        return this.suggestedPostParameters;
    }

    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @Generated
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @Generated
    public void setDirectMessagesTopicId(Integer directMessagesTopicId) {
        this.directMessagesTopicId = directMessagesTopicId;
    }

    @Generated
    public void setVideo(@NonNull InputFile video) {
        if (video == null) {
            throw new NullPointerException("video is marked non-null but is null");
        }
        this.video = video;
    }

    @Generated
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @Generated
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @Generated
    public void setWidth(Integer width) {
        this.width = width;
    }

    @Generated
    public void setHeight(Integer height) {
        this.height = height;
    }

    @Generated
    public void setSupportsStreaming(Boolean supportsStreaming) {
        this.supportsStreaming = supportsStreaming;
    }

    @Generated
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @Generated
    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    @Generated
    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @Generated
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @Generated
    public void setThumbnail(InputFile thumbnail) {
        this.thumbnail = thumbnail;
    }

    @Generated
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    @Generated
    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    @Generated
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @Generated
    public void setHasSpoiler(Boolean hasSpoiler) {
        this.hasSpoiler = hasSpoiler;
    }

    @Generated
    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    @Generated
    public void setBusinessConnectionId(String businessConnectionId) {
        this.businessConnectionId = businessConnectionId;
    }

    @Generated
    public void setMessageEffectId(String messageEffectId) {
        this.messageEffectId = messageEffectId;
    }

    @Generated
    public void setShowCaptionAboveMedia(Boolean showCaptionAboveMedia) {
        this.showCaptionAboveMedia = showCaptionAboveMedia;
    }

    @Generated
    public void setAllowPaidBroadcast(Boolean allowPaidBroadcast) {
        this.allowPaidBroadcast = allowPaidBroadcast;
    }

    @Generated
    public void setCover(InputFile cover) {
        this.cover = cover;
    }

    @Generated
    public void setStartTimestamp(Integer startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    @Generated
    public void setSuggestedPostParameters(SuggestedPostParameters suggestedPostParameters) {
        this.suggestedPostParameters = suggestedPostParameters;
    }

    @Generated
    public String toString() {
        return "SendVideo(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", directMessagesTopicId=" + this.getDirectMessagesTopicId() + ", video=" + this.getVideo() + ", duration=" + this.getDuration() + ", caption=" + this.getCaption() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", supportsStreaming=" + this.getSupportsStreaming() + ", disableNotification=" + this.getDisableNotification() + ", replyToMessageId=" + this.getReplyToMessageId() + ", replyMarkup=" + this.getReplyMarkup() + ", parseMode=" + this.getParseMode() + ", thumbnail=" + this.getThumbnail() + ", captionEntities=" + this.getCaptionEntities() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", protectContent=" + this.getProtectContent() + ", hasSpoiler=" + this.getHasSpoiler() + ", replyParameters=" + this.getReplyParameters() + ", businessConnectionId=" + this.getBusinessConnectionId() + ", messageEffectId=" + this.getMessageEffectId() + ", showCaptionAboveMedia=" + this.getShowCaptionAboveMedia() + ", allowPaidBroadcast=" + this.getAllowPaidBroadcast() + ", cover=" + this.getCover() + ", startTimestamp=" + this.getStartTimestamp() + ", suggestedPostParameters=" + this.getSuggestedPostParameters() + ")";
    }

    @Generated
    public SendVideo(@NonNull String chatId, @NonNull InputFile video) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (video == null) {
            throw new NullPointerException("video is marked non-null but is null");
        }
        this.chatId = chatId;
        this.video = video;
    }

    @Generated
    public SendVideo(@NonNull String chatId, Integer messageThreadId, Integer directMessagesTopicId, @NonNull InputFile video, Integer duration, String caption, Integer width, Integer height, Boolean supportsStreaming, Boolean disableNotification, Integer replyToMessageId, ReplyKeyboard replyMarkup, String parseMode, InputFile thumbnail, List<MessageEntity> captionEntities, Boolean allowSendingWithoutReply, Boolean protectContent, Boolean hasSpoiler, ReplyParameters replyParameters, String businessConnectionId, String messageEffectId, Boolean showCaptionAboveMedia, Boolean allowPaidBroadcast, InputFile cover, Integer startTimestamp, SuggestedPostParameters suggestedPostParameters) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (video == null) {
            throw new NullPointerException("video is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.directMessagesTopicId = directMessagesTopicId;
        this.video = video;
        this.duration = duration;
        this.caption = caption;
        this.width = width;
        this.height = height;
        this.supportsStreaming = supportsStreaming;
        this.disableNotification = disableNotification;
        this.replyToMessageId = replyToMessageId;
        this.replyMarkup = replyMarkup;
        this.parseMode = parseMode;
        this.thumbnail = thumbnail;
        this.captionEntities = captionEntities;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.protectContent = protectContent;
        this.hasSpoiler = hasSpoiler;
        this.replyParameters = replyParameters;
        this.businessConnectionId = businessConnectionId;
        this.messageEffectId = messageEffectId;
        this.showCaptionAboveMedia = showCaptionAboveMedia;
        this.allowPaidBroadcast = allowPaidBroadcast;
        this.cover = cover;
        this.startTimestamp = startTimestamp;
        this.suggestedPostParameters = suggestedPostParameters;
    }

    public static abstract class SendVideoBuilder<C extends SendVideo, B extends SendVideoBuilder<C, B>>
    extends SendMediaBotMethod.SendMediaBotMethodBuilder<Message, C, B> {
        @Generated
        private String chatId;
        @Generated
        private Integer messageThreadId;
        @Generated
        private Integer directMessagesTopicId;
        @Generated
        private InputFile video;
        @Generated
        private Integer duration;
        @Generated
        private String caption;
        @Generated
        private Integer width;
        @Generated
        private Integer height;
        @Generated
        private Boolean supportsStreaming;
        @Generated
        private Boolean disableNotification;
        @Generated
        private Integer replyToMessageId;
        @Generated
        private ReplyKeyboard replyMarkup;
        @Generated
        private String parseMode;
        @Generated
        private InputFile thumbnail;
        @Generated
        private ArrayList<MessageEntity> captionEntities;
        @Generated
        private Boolean allowSendingWithoutReply;
        @Generated
        private Boolean protectContent;
        @Generated
        private Boolean hasSpoiler;
        @Generated
        private ReplyParameters replyParameters;
        @Generated
        private String businessConnectionId;
        @Generated
        private String messageEffectId;
        @Generated
        private Boolean showCaptionAboveMedia;
        @Generated
        private Boolean allowPaidBroadcast;
        @Generated
        private InputFile cover;
        @Generated
        private Integer startTimestamp;
        @Generated
        private SuggestedPostParameters suggestedPostParameters;

        public SendVideoBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @Generated
        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        @Generated
        public B directMessagesTopicId(Integer directMessagesTopicId) {
            this.directMessagesTopicId = directMessagesTopicId;
            return (B)this.self();
        }

        @Generated
        public B video(@NonNull InputFile video) {
            if (video == null) {
                throw new NullPointerException("video is marked non-null but is null");
            }
            this.video = video;
            return (B)this.self();
        }

        @Generated
        public B duration(Integer duration) {
            this.duration = duration;
            return (B)this.self();
        }

        @Generated
        public B caption(String caption) {
            this.caption = caption;
            return (B)this.self();
        }

        @Generated
        public B width(Integer width) {
            this.width = width;
            return (B)this.self();
        }

        @Generated
        public B height(Integer height) {
            this.height = height;
            return (B)this.self();
        }

        @Generated
        public B supportsStreaming(Boolean supportsStreaming) {
            this.supportsStreaming = supportsStreaming;
            return (B)this.self();
        }

        @Generated
        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        @Generated
        public B replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return (B)this.self();
        }

        @Generated
        public B replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @Generated
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return (B)this.self();
        }

        @Generated
        public B thumbnail(InputFile thumbnail) {
            this.thumbnail = thumbnail;
            return (B)this.self();
        }

        @Generated
        public B captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return (B)this.self();
        }

        @Generated
        public B captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return (B)this.self();
        }

        @Generated
        public B clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return (B)this.self();
        }

        @Generated
        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        @Generated
        public B hasSpoiler(Boolean hasSpoiler) {
            this.hasSpoiler = hasSpoiler;
            return (B)this.self();
        }

        @Generated
        public B replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return (B)this.self();
        }

        @Generated
        public B businessConnectionId(String businessConnectionId) {
            this.businessConnectionId = businessConnectionId;
            return (B)this.self();
        }

        @Generated
        public B messageEffectId(String messageEffectId) {
            this.messageEffectId = messageEffectId;
            return (B)this.self();
        }

        @Generated
        public B showCaptionAboveMedia(Boolean showCaptionAboveMedia) {
            this.showCaptionAboveMedia = showCaptionAboveMedia;
            return (B)this.self();
        }

        @Generated
        public B allowPaidBroadcast(Boolean allowPaidBroadcast) {
            this.allowPaidBroadcast = allowPaidBroadcast;
            return (B)this.self();
        }

        @Generated
        public B cover(InputFile cover) {
            this.cover = cover;
            return (B)this.self();
        }

        @Generated
        public B startTimestamp(Integer startTimestamp) {
            this.startTimestamp = startTimestamp;
            return (B)this.self();
        }

        @Generated
        public B suggestedPostParameters(SuggestedPostParameters suggestedPostParameters) {
            this.suggestedPostParameters = suggestedPostParameters;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SendVideo.SendVideoBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", directMessagesTopicId=" + this.directMessagesTopicId + ", video=" + this.video + ", duration=" + this.duration + ", caption=" + this.caption + ", width=" + this.width + ", height=" + this.height + ", supportsStreaming=" + this.supportsStreaming + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", parseMode=" + this.parseMode + ", thumbnail=" + this.thumbnail + ", captionEntities=" + this.captionEntities + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", protectContent=" + this.protectContent + ", hasSpoiler=" + this.hasSpoiler + ", replyParameters=" + this.replyParameters + ", businessConnectionId=" + this.businessConnectionId + ", messageEffectId=" + this.messageEffectId + ", showCaptionAboveMedia=" + this.showCaptionAboveMedia + ", allowPaidBroadcast=" + this.allowPaidBroadcast + ", cover=" + this.cover + ", startTimestamp=" + this.startTimestamp + ", suggestedPostParameters=" + this.suggestedPostParameters + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SendVideoBuilderImpl
    extends SendVideoBuilder<SendVideo, SendVideoBuilderImpl> {
        @Generated
        private SendVideoBuilderImpl() {
        }

        @Override
        @Generated
        protected SendVideoBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SendVideo build() {
            return new SendVideo(this);
        }
    }
}

