/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.send.SendMediaBotMethod;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.message.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.suggestedpost.SuggestedPostParameters;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=SendStickerBuilderImpl.class)
public class SendSticker
extends SendMediaBotMethod<Message> {
    public static final String PATH = "sendsticker";
    public static final String STICKER_FIELD = "sticker";
    public static final String EMOJI_FIELD = "emoji";
    public static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    @NonNull
    private String chatId;
    private Integer messageThreadId;
    private Integer directMessagesTopicId;
    @NonNull
    private InputFile sticker;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;
    private Boolean allowSendingWithoutReply;
    private Boolean protectContent;
    private String emoji;
    private ReplyParameters replyParameters;
    private String businessConnectionId;
    private String messageEffectId;
    private Boolean allowPaidBroadcast;
    private SuggestedPostParameters suggestedPostParameters;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = false;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Message.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        Validations.requiredChatId(this.chatId, this);
        this.sticker.validate();
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public InputFile getFile() {
        return this.sticker;
    }

    @Override
    public String getFileField() {
        return STICKER_FIELD;
    }

    @Generated
    protected SendSticker(SendStickerBuilder<?, ?> b) {
        super(b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        this.directMessagesTopicId = b.directMessagesTopicId;
        this.sticker = b.sticker;
        if (this.sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.disableNotification = b.disableNotification;
        this.replyToMessageId = b.replyToMessageId;
        this.replyMarkup = b.replyMarkup;
        this.allowSendingWithoutReply = b.allowSendingWithoutReply;
        this.protectContent = b.protectContent;
        this.emoji = b.emoji;
        this.replyParameters = b.replyParameters;
        this.businessConnectionId = b.businessConnectionId;
        this.messageEffectId = b.messageEffectId;
        this.allowPaidBroadcast = b.allowPaidBroadcast;
        this.suggestedPostParameters = b.suggestedPostParameters;
    }

    @Generated
    public static SendStickerBuilder<?, ?> builder() {
        return new SendStickerBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendSticker)) {
            return false;
        }
        SendSticker other = (SendSticker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Integer this$directMessagesTopicId = this.getDirectMessagesTopicId();
        Integer other$directMessagesTopicId = other.getDirectMessagesTopicId();
        if (this$directMessagesTopicId == null ? other$directMessagesTopicId != null : !((Object)this$directMessagesTopicId).equals(other$directMessagesTopicId)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        Boolean this$allowPaidBroadcast = this.getAllowPaidBroadcast();
        Boolean other$allowPaidBroadcast = other.getAllowPaidBroadcast();
        if (this$allowPaidBroadcast == null ? other$allowPaidBroadcast != null : !((Object)this$allowPaidBroadcast).equals(other$allowPaidBroadcast)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        InputFile this$sticker = this.getSticker();
        InputFile other$sticker = other.getSticker();
        if (this$sticker == null ? other$sticker != null : !((Object)this$sticker).equals(other$sticker)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        String this$emoji = this.getEmoji();
        String other$emoji = other.getEmoji();
        if (this$emoji == null ? other$emoji != null : !this$emoji.equals(other$emoji)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        if (this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        if (this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId)) {
            return false;
        }
        String this$messageEffectId = this.getMessageEffectId();
        String other$messageEffectId = other.getMessageEffectId();
        if (this$messageEffectId == null ? other$messageEffectId != null : !this$messageEffectId.equals(other$messageEffectId)) {
            return false;
        }
        SuggestedPostParameters this$suggestedPostParameters = this.getSuggestedPostParameters();
        SuggestedPostParameters other$suggestedPostParameters = other.getSuggestedPostParameters();
        return !(this$suggestedPostParameters == null ? other$suggestedPostParameters != null : !((Object)this$suggestedPostParameters).equals(other$suggestedPostParameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SendSticker;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Integer $directMessagesTopicId = this.getDirectMessagesTopicId();
        result = result * 59 + ($directMessagesTopicId == null ? 43 : ((Object)$directMessagesTopicId).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        Boolean $allowPaidBroadcast = this.getAllowPaidBroadcast();
        result = result * 59 + ($allowPaidBroadcast == null ? 43 : ((Object)$allowPaidBroadcast).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        InputFile $sticker = this.getSticker();
        result = result * 59 + ($sticker == null ? 43 : ((Object)$sticker).hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        String $emoji = this.getEmoji();
        result = result * 59 + ($emoji == null ? 43 : $emoji.hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        String $messageEffectId = this.getMessageEffectId();
        result = result * 59 + ($messageEffectId == null ? 43 : $messageEffectId.hashCode());
        SuggestedPostParameters $suggestedPostParameters = this.getSuggestedPostParameters();
        result = result * 59 + ($suggestedPostParameters == null ? 43 : ((Object)$suggestedPostParameters).hashCode());
        return result;
    }

    @Override
    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @Override
    @Generated
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @Override
    @Generated
    public Integer getDirectMessagesTopicId() {
        return this.directMessagesTopicId;
    }

    @NonNull
    @Generated
    public InputFile getSticker() {
        return this.sticker;
    }

    @Override
    @Generated
    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    @Override
    @Generated
    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    @Override
    @Generated
    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    @Override
    @Generated
    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    @Override
    @Generated
    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @Generated
    public String getEmoji() {
        return this.emoji;
    }

    @Override
    @Generated
    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @Override
    @Generated
    public String getMessageEffectId() {
        return this.messageEffectId;
    }

    @Override
    @Generated
    public Boolean getAllowPaidBroadcast() {
        return this.allowPaidBroadcast;
    }

    @Override
    @Generated
    public SuggestedPostParameters getSuggestedPostParameters() {
        return this.suggestedPostParameters;
    }

    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @Generated
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @Generated
    public void setDirectMessagesTopicId(Integer directMessagesTopicId) {
        this.directMessagesTopicId = directMessagesTopicId;
    }

    @Generated
    public void setSticker(@NonNull InputFile sticker) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
    }

    @Generated
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @Generated
    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    @Generated
    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @Generated
    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    @Generated
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @Generated
    public void setEmoji(String emoji) {
        this.emoji = emoji;
    }

    @Generated
    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    @Generated
    public void setBusinessConnectionId(String businessConnectionId) {
        this.businessConnectionId = businessConnectionId;
    }

    @Generated
    public void setMessageEffectId(String messageEffectId) {
        this.messageEffectId = messageEffectId;
    }

    @Generated
    public void setAllowPaidBroadcast(Boolean allowPaidBroadcast) {
        this.allowPaidBroadcast = allowPaidBroadcast;
    }

    @Generated
    public void setSuggestedPostParameters(SuggestedPostParameters suggestedPostParameters) {
        this.suggestedPostParameters = suggestedPostParameters;
    }

    @Generated
    public String toString() {
        return "SendSticker(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", directMessagesTopicId=" + this.getDirectMessagesTopicId() + ", sticker=" + this.getSticker() + ", disableNotification=" + this.getDisableNotification() + ", replyToMessageId=" + this.getReplyToMessageId() + ", replyMarkup=" + this.getReplyMarkup() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", protectContent=" + this.getProtectContent() + ", emoji=" + this.getEmoji() + ", replyParameters=" + this.getReplyParameters() + ", businessConnectionId=" + this.getBusinessConnectionId() + ", messageEffectId=" + this.getMessageEffectId() + ", allowPaidBroadcast=" + this.getAllowPaidBroadcast() + ", suggestedPostParameters=" + this.getSuggestedPostParameters() + ")";
    }

    @Generated
    public SendSticker(@NonNull String chatId, @NonNull InputFile sticker) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.chatId = chatId;
        this.sticker = sticker;
    }

    @Generated
    public SendSticker(@NonNull String chatId, Integer messageThreadId, Integer directMessagesTopicId, @NonNull InputFile sticker, Boolean disableNotification, Integer replyToMessageId, ReplyKeyboard replyMarkup, Boolean allowSendingWithoutReply, Boolean protectContent, String emoji, ReplyParameters replyParameters, String businessConnectionId, String messageEffectId, Boolean allowPaidBroadcast, SuggestedPostParameters suggestedPostParameters) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.directMessagesTopicId = directMessagesTopicId;
        this.sticker = sticker;
        this.disableNotification = disableNotification;
        this.replyToMessageId = replyToMessageId;
        this.replyMarkup = replyMarkup;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.protectContent = protectContent;
        this.emoji = emoji;
        this.replyParameters = replyParameters;
        this.businessConnectionId = businessConnectionId;
        this.messageEffectId = messageEffectId;
        this.allowPaidBroadcast = allowPaidBroadcast;
        this.suggestedPostParameters = suggestedPostParameters;
    }

    public static abstract class SendStickerBuilder<C extends SendSticker, B extends SendStickerBuilder<C, B>>
    extends SendMediaBotMethod.SendMediaBotMethodBuilder<Message, C, B> {
        @Generated
        private String chatId;
        @Generated
        private Integer messageThreadId;
        @Generated
        private Integer directMessagesTopicId;
        @Generated
        private InputFile sticker;
        @Generated
        private Boolean disableNotification;
        @Generated
        private Integer replyToMessageId;
        @Generated
        private ReplyKeyboard replyMarkup;
        @Generated
        private Boolean allowSendingWithoutReply;
        @Generated
        private Boolean protectContent;
        @Generated
        private String emoji;
        @Generated
        private ReplyParameters replyParameters;
        @Generated
        private String businessConnectionId;
        @Generated
        private String messageEffectId;
        @Generated
        private Boolean allowPaidBroadcast;
        @Generated
        private SuggestedPostParameters suggestedPostParameters;

        public SendStickerBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @Generated
        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        @Generated
        public B directMessagesTopicId(Integer directMessagesTopicId) {
            this.directMessagesTopicId = directMessagesTopicId;
            return (B)this.self();
        }

        @Generated
        public B sticker(@NonNull InputFile sticker) {
            if (sticker == null) {
                throw new NullPointerException("sticker is marked non-null but is null");
            }
            this.sticker = sticker;
            return (B)this.self();
        }

        @Generated
        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        @Generated
        public B replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return (B)this.self();
        }

        @Generated
        public B replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @Generated
        public B allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return (B)this.self();
        }

        @Generated
        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        @Generated
        public B emoji(String emoji) {
            this.emoji = emoji;
            return (B)this.self();
        }

        @Generated
        public B replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return (B)this.self();
        }

        @Generated
        public B businessConnectionId(String businessConnectionId) {
            this.businessConnectionId = businessConnectionId;
            return (B)this.self();
        }

        @Generated
        public B messageEffectId(String messageEffectId) {
            this.messageEffectId = messageEffectId;
            return (B)this.self();
        }

        @Generated
        public B allowPaidBroadcast(Boolean allowPaidBroadcast) {
            this.allowPaidBroadcast = allowPaidBroadcast;
            return (B)this.self();
        }

        @Generated
        public B suggestedPostParameters(SuggestedPostParameters suggestedPostParameters) {
            this.suggestedPostParameters = suggestedPostParameters;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SendSticker.SendStickerBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", directMessagesTopicId=" + this.directMessagesTopicId + ", sticker=" + this.sticker + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", protectContent=" + this.protectContent + ", emoji=" + this.emoji + ", replyParameters=" + this.replyParameters + ", businessConnectionId=" + this.businessConnectionId + ", messageEffectId=" + this.messageEffectId + ", allowPaidBroadcast=" + this.allowPaidBroadcast + ", suggestedPostParameters=" + this.suggestedPostParameters + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SendStickerBuilderImpl
    extends SendStickerBuilder<SendSticker, SendStickerBuilderImpl> {
        @Generated
        private SendStickerBuilderImpl() {
        }

        @Override
        @Generated
        protected SendStickerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SendSticker build() {
            return new SendSticker(this);
        }
    }
}

