/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=SendMessageDraftBuilderImpl.class)
public class SendMessageDraft
extends BotApiMethodBoolean {
    public static final String PATH = "sendMessageDraft";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_THREAD_ID_FIELD = "message_thread_id";
    private static final String DRAFT_ID_FIELD = "draft_id";
    private static final String TEXT_FIELD = "text";
    private static final String PARSE_MODE_FIELD = "parse_mode";
    private static final String ENTITIES_FIELD = "entities";
    @JsonProperty(value="chat_id")
    @NonNull
    private Long chatId;
    @JsonProperty(value="message_thread_id")
    private Integer messageThreadId;
    @JsonProperty(value="draft_id")
    @NonNull
    private Integer draftId;
    @JsonProperty(value="text")
    @NonNull
    private String text;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="entities")
    private List<MessageEntity> entities;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId == 0L) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.draftId == null || this.draftId == 0) {
            throw new TelegramApiValidationException("DraftId can't be empty and must be non-zero", this);
        }
        if (this.text == null || this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text can't be empty", this);
        }
        if (this.text.length() > 4096) {
            throw new TelegramApiValidationException("Text can't be longer than 4096 characters", this);
        }
    }

    @Generated
    protected SendMessageDraft(SendMessageDraftBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.messageThreadId = b.messageThreadId;
        this.draftId = b.draftId;
        if (this.draftId == null) {
            throw new NullPointerException("draftId is marked non-null but is null");
        }
        this.text = b.text;
        if (this.text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.parseMode = b.parseMode;
        this.entities = b.entities;
    }

    @Generated
    public static SendMessageDraftBuilder<?, ?> builder() {
        return new SendMessageDraftBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendMessageDraft)) {
            return false;
        }
        SendMessageDraft other = (SendMessageDraft)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$chatId = this.getChatId();
        Long other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !((Object)this$chatId).equals(other$chatId)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Integer this$draftId = this.getDraftId();
        Integer other$draftId = other.getDraftId();
        if (this$draftId == null ? other$draftId != null : !((Object)this$draftId).equals(other$draftId)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$entities = this.getEntities();
        List<MessageEntity> other$entities = other.getEntities();
        return !(this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SendMessageDraft;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : ((Object)$chatId).hashCode());
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Integer $draftId = this.getDraftId();
        result = result * 59 + ($draftId == null ? 43 : ((Object)$draftId).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public Long getChatId() {
        return this.chatId;
    }

    @Generated
    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    @Generated
    public Integer getDraftId() {
        return this.draftId;
    }

    @NonNull
    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public String getParseMode() {
        return this.parseMode;
    }

    @Generated
    public List<MessageEntity> getEntities() {
        return this.entities;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    @Generated
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="draft_id")
    @Generated
    public void setDraftId(@NonNull Integer draftId) {
        if (draftId == null) {
            throw new NullPointerException("draftId is marked non-null but is null");
        }
        this.draftId = draftId;
    }

    @JsonProperty(value="text")
    @Generated
    public void setText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @JsonProperty(value="parse_mode")
    @Generated
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="entities")
    @Generated
    public void setEntities(List<MessageEntity> entities) {
        this.entities = entities;
    }

    @Generated
    public String toString() {
        return "SendMessageDraft(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", draftId=" + this.getDraftId() + ", text=" + this.getText() + ", parseMode=" + this.getParseMode() + ", entities=" + this.getEntities() + ")";
    }

    @Generated
    public SendMessageDraft(@NonNull Long chatId, @NonNull Integer draftId, @NonNull String text) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (draftId == null) {
            throw new NullPointerException("draftId is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.chatId = chatId;
        this.draftId = draftId;
        this.text = text;
    }

    @Generated
    public SendMessageDraft(@NonNull Long chatId, Integer messageThreadId, @NonNull Integer draftId, @NonNull String text, String parseMode, List<MessageEntity> entities) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (draftId == null) {
            throw new NullPointerException("draftId is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.draftId = draftId;
        this.text = text;
        this.parseMode = parseMode;
        this.entities = entities;
    }

    @Generated
    public static abstract class SendMessageDraftBuilder<C extends SendMessageDraft, B extends SendMessageDraftBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        @Generated
        private Long chatId;
        @Generated
        private Integer messageThreadId;
        @Generated
        private Integer draftId;
        @Generated
        private String text;
        @Generated
        private String parseMode;
        @Generated
        private List<MessageEntity> entities;

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="message_thread_id")
        @Generated
        public B messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return (B)this.self();
        }

        @JsonProperty(value="draft_id")
        @Generated
        public B draftId(@NonNull Integer draftId) {
            if (draftId == null) {
                throw new NullPointerException("draftId is marked non-null but is null");
            }
            this.draftId = draftId;
            return (B)this.self();
        }

        @JsonProperty(value="text")
        @Generated
        public B text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return (B)this.self();
        }

        @JsonProperty(value="parse_mode")
        @Generated
        public B parseMode(String parseMode) {
            this.parseMode = parseMode;
            return (B)this.self();
        }

        @JsonProperty(value="entities")
        @Generated
        public B entities(List<MessageEntity> entities) {
            this.entities = entities;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SendMessageDraft.SendMessageDraftBuilder(super=" + super.toString() + ", chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", draftId=" + this.draftId + ", text=" + this.text + ", parseMode=" + this.parseMode + ", entities=" + this.entities + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SendMessageDraftBuilderImpl
    extends SendMessageDraftBuilder<SendMessageDraft, SendMessageDraftBuilderImpl> {
        @Generated
        private SendMessageDraftBuilderImpl() {
        }

        @Override
        @Generated
        protected SendMessageDraftBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SendMessageDraft build() {
            return new SendMessageDraft(this);
        }
    }
}

