/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.gifts;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.gifts.owned.OwnedGifts;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GetChatGifts
extends BotApiMethod<OwnedGifts> {
    public static final String PATH = "getChatGifts";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String EXCLUDE_UNSAVED_FIELD = "exclude_unsaved";
    private static final String EXCLUDE_SAVED_FIELD = "exclude_saved";
    private static final String EXCLUDE_UNLIMITED_FIELD = "exclude_unlimited";
    private static final String EXCLUDE_LIMITED_UPGRADABLE_FIELD = "exclude_limited_upgradable";
    private static final String EXCLUDE_LIMITED_NON_UPGRADABLE_FIELD = "exclude_limited_non_upgradable";
    private static final String EXCLUDE_FROM_BLOCKCHAIN_FIELD = "exclude_from_blockchain";
    private static final String EXCLUDE_UNIQUE_FIELD = "exclude_unique";
    private static final String SORT_BY_PRICE_FIELD = "sort_by_price";
    private static final String OFFSET_FIELD = "offset";
    private static final String LIMIT_FIELD = "limit";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="exclude_unsaved")
    private Boolean excludeUnsaved;
    @JsonProperty(value="exclude_saved")
    private Boolean excludeSaved;
    @JsonProperty(value="exclude_unlimited")
    private Boolean excludeUnlimited;
    @JsonProperty(value="exclude_limited_upgradable")
    private Boolean excludeLimitedUpgradable;
    @JsonProperty(value="exclude_limited_non_upgradable")
    private Boolean excludeLimitedNonUpgradable;
    @JsonProperty(value="exclude_from_blockchain")
    private Boolean excludeFromBlockchain;
    @JsonProperty(value="exclude_unique")
    private Boolean excludeUnique;
    @JsonProperty(value="sort_by_price")
    private Boolean sortByPrice;
    @JsonProperty(value="offset")
    private String offset;
    @JsonProperty(value="limit")
    private Integer limit;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public OwnedGifts deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, OwnedGifts.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.limit != null && (this.limit < 1 || this.limit > 100)) {
            throw new TelegramApiValidationException("Limit must be between 1 and 100", this);
        }
    }

    @Generated
    public static GetChatGiftsBuilder builder() {
        return new GetChatGiftsBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetChatGifts)) {
            return false;
        }
        GetChatGifts other = (GetChatGifts)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$excludeUnsaved = this.getExcludeUnsaved();
        Boolean other$excludeUnsaved = other.getExcludeUnsaved();
        if (this$excludeUnsaved == null ? other$excludeUnsaved != null : !((Object)this$excludeUnsaved).equals(other$excludeUnsaved)) {
            return false;
        }
        Boolean this$excludeSaved = this.getExcludeSaved();
        Boolean other$excludeSaved = other.getExcludeSaved();
        if (this$excludeSaved == null ? other$excludeSaved != null : !((Object)this$excludeSaved).equals(other$excludeSaved)) {
            return false;
        }
        Boolean this$excludeUnlimited = this.getExcludeUnlimited();
        Boolean other$excludeUnlimited = other.getExcludeUnlimited();
        if (this$excludeUnlimited == null ? other$excludeUnlimited != null : !((Object)this$excludeUnlimited).equals(other$excludeUnlimited)) {
            return false;
        }
        Boolean this$excludeLimitedUpgradable = this.getExcludeLimitedUpgradable();
        Boolean other$excludeLimitedUpgradable = other.getExcludeLimitedUpgradable();
        if (this$excludeLimitedUpgradable == null ? other$excludeLimitedUpgradable != null : !((Object)this$excludeLimitedUpgradable).equals(other$excludeLimitedUpgradable)) {
            return false;
        }
        Boolean this$excludeLimitedNonUpgradable = this.getExcludeLimitedNonUpgradable();
        Boolean other$excludeLimitedNonUpgradable = other.getExcludeLimitedNonUpgradable();
        if (this$excludeLimitedNonUpgradable == null ? other$excludeLimitedNonUpgradable != null : !((Object)this$excludeLimitedNonUpgradable).equals(other$excludeLimitedNonUpgradable)) {
            return false;
        }
        Boolean this$excludeFromBlockchain = this.getExcludeFromBlockchain();
        Boolean other$excludeFromBlockchain = other.getExcludeFromBlockchain();
        if (this$excludeFromBlockchain == null ? other$excludeFromBlockchain != null : !((Object)this$excludeFromBlockchain).equals(other$excludeFromBlockchain)) {
            return false;
        }
        Boolean this$excludeUnique = this.getExcludeUnique();
        Boolean other$excludeUnique = other.getExcludeUnique();
        if (this$excludeUnique == null ? other$excludeUnique != null : !((Object)this$excludeUnique).equals(other$excludeUnique)) {
            return false;
        }
        Boolean this$sortByPrice = this.getSortByPrice();
        Boolean other$sortByPrice = other.getSortByPrice();
        if (this$sortByPrice == null ? other$sortByPrice != null : !((Object)this$sortByPrice).equals(other$sortByPrice)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$offset = this.getOffset();
        String other$offset = other.getOffset();
        return !(this$offset == null ? other$offset != null : !this$offset.equals(other$offset));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GetChatGifts;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $excludeUnsaved = this.getExcludeUnsaved();
        result = result * 59 + ($excludeUnsaved == null ? 43 : ((Object)$excludeUnsaved).hashCode());
        Boolean $excludeSaved = this.getExcludeSaved();
        result = result * 59 + ($excludeSaved == null ? 43 : ((Object)$excludeSaved).hashCode());
        Boolean $excludeUnlimited = this.getExcludeUnlimited();
        result = result * 59 + ($excludeUnlimited == null ? 43 : ((Object)$excludeUnlimited).hashCode());
        Boolean $excludeLimitedUpgradable = this.getExcludeLimitedUpgradable();
        result = result * 59 + ($excludeLimitedUpgradable == null ? 43 : ((Object)$excludeLimitedUpgradable).hashCode());
        Boolean $excludeLimitedNonUpgradable = this.getExcludeLimitedNonUpgradable();
        result = result * 59 + ($excludeLimitedNonUpgradable == null ? 43 : ((Object)$excludeLimitedNonUpgradable).hashCode());
        Boolean $excludeFromBlockchain = this.getExcludeFromBlockchain();
        result = result * 59 + ($excludeFromBlockchain == null ? 43 : ((Object)$excludeFromBlockchain).hashCode());
        Boolean $excludeUnique = this.getExcludeUnique();
        result = result * 59 + ($excludeUnique == null ? 43 : ((Object)$excludeUnique).hashCode());
        Boolean $sortByPrice = this.getSortByPrice();
        result = result * 59 + ($sortByPrice == null ? 43 : ((Object)$sortByPrice).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : $offset.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @Generated
    public Boolean getExcludeUnsaved() {
        return this.excludeUnsaved;
    }

    @Generated
    public Boolean getExcludeSaved() {
        return this.excludeSaved;
    }

    @Generated
    public Boolean getExcludeUnlimited() {
        return this.excludeUnlimited;
    }

    @Generated
    public Boolean getExcludeLimitedUpgradable() {
        return this.excludeLimitedUpgradable;
    }

    @Generated
    public Boolean getExcludeLimitedNonUpgradable() {
        return this.excludeLimitedNonUpgradable;
    }

    @Generated
    public Boolean getExcludeFromBlockchain() {
        return this.excludeFromBlockchain;
    }

    @Generated
    public Boolean getExcludeUnique() {
        return this.excludeUnique;
    }

    @Generated
    public Boolean getSortByPrice() {
        return this.sortByPrice;
    }

    @Generated
    public String getOffset() {
        return this.offset;
    }

    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="exclude_unsaved")
    @Generated
    public void setExcludeUnsaved(Boolean excludeUnsaved) {
        this.excludeUnsaved = excludeUnsaved;
    }

    @JsonProperty(value="exclude_saved")
    @Generated
    public void setExcludeSaved(Boolean excludeSaved) {
        this.excludeSaved = excludeSaved;
    }

    @JsonProperty(value="exclude_unlimited")
    @Generated
    public void setExcludeUnlimited(Boolean excludeUnlimited) {
        this.excludeUnlimited = excludeUnlimited;
    }

    @JsonProperty(value="exclude_limited_upgradable")
    @Generated
    public void setExcludeLimitedUpgradable(Boolean excludeLimitedUpgradable) {
        this.excludeLimitedUpgradable = excludeLimitedUpgradable;
    }

    @JsonProperty(value="exclude_limited_non_upgradable")
    @Generated
    public void setExcludeLimitedNonUpgradable(Boolean excludeLimitedNonUpgradable) {
        this.excludeLimitedNonUpgradable = excludeLimitedNonUpgradable;
    }

    @JsonProperty(value="exclude_from_blockchain")
    @Generated
    public void setExcludeFromBlockchain(Boolean excludeFromBlockchain) {
        this.excludeFromBlockchain = excludeFromBlockchain;
    }

    @JsonProperty(value="exclude_unique")
    @Generated
    public void setExcludeUnique(Boolean excludeUnique) {
        this.excludeUnique = excludeUnique;
    }

    @JsonProperty(value="sort_by_price")
    @Generated
    public void setSortByPrice(Boolean sortByPrice) {
        this.sortByPrice = sortByPrice;
    }

    @JsonProperty(value="offset")
    @Generated
    public void setOffset(String offset) {
        this.offset = offset;
    }

    @JsonProperty(value="limit")
    @Generated
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Generated
    public String toString() {
        return "GetChatGifts(chatId=" + this.getChatId() + ", excludeUnsaved=" + this.getExcludeUnsaved() + ", excludeSaved=" + this.getExcludeSaved() + ", excludeUnlimited=" + this.getExcludeUnlimited() + ", excludeLimitedUpgradable=" + this.getExcludeLimitedUpgradable() + ", excludeLimitedNonUpgradable=" + this.getExcludeLimitedNonUpgradable() + ", excludeFromBlockchain=" + this.getExcludeFromBlockchain() + ", excludeUnique=" + this.getExcludeUnique() + ", sortByPrice=" + this.getSortByPrice() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ")";
    }

    @Generated
    public GetChatGifts(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @Generated
    public GetChatGifts(@NonNull String chatId, Boolean excludeUnsaved, Boolean excludeSaved, Boolean excludeUnlimited, Boolean excludeLimitedUpgradable, Boolean excludeLimitedNonUpgradable, Boolean excludeFromBlockchain, Boolean excludeUnique, Boolean sortByPrice, String offset, Integer limit) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.excludeUnsaved = excludeUnsaved;
        this.excludeSaved = excludeSaved;
        this.excludeUnlimited = excludeUnlimited;
        this.excludeLimitedUpgradable = excludeLimitedUpgradable;
        this.excludeLimitedNonUpgradable = excludeLimitedNonUpgradable;
        this.excludeFromBlockchain = excludeFromBlockchain;
        this.excludeUnique = excludeUnique;
        this.sortByPrice = sortByPrice;
        this.offset = offset;
        this.limit = limit;
    }

    @Generated
    public static class GetChatGiftsBuilder {
        @Generated
        private String chatId;
        @Generated
        private Boolean excludeUnsaved;
        @Generated
        private Boolean excludeSaved;
        @Generated
        private Boolean excludeUnlimited;
        @Generated
        private Boolean excludeLimitedUpgradable;
        @Generated
        private Boolean excludeLimitedNonUpgradable;
        @Generated
        private Boolean excludeFromBlockchain;
        @Generated
        private Boolean excludeUnique;
        @Generated
        private Boolean sortByPrice;
        @Generated
        private String offset;
        @Generated
        private Integer limit;

        @Generated
        GetChatGiftsBuilder() {
        }

        @JsonProperty(value="chat_id")
        @Generated
        public GetChatGiftsBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="exclude_unsaved")
        @Generated
        public GetChatGiftsBuilder excludeUnsaved(Boolean excludeUnsaved) {
            this.excludeUnsaved = excludeUnsaved;
            return this;
        }

        @JsonProperty(value="exclude_saved")
        @Generated
        public GetChatGiftsBuilder excludeSaved(Boolean excludeSaved) {
            this.excludeSaved = excludeSaved;
            return this;
        }

        @JsonProperty(value="exclude_unlimited")
        @Generated
        public GetChatGiftsBuilder excludeUnlimited(Boolean excludeUnlimited) {
            this.excludeUnlimited = excludeUnlimited;
            return this;
        }

        @JsonProperty(value="exclude_limited_upgradable")
        @Generated
        public GetChatGiftsBuilder excludeLimitedUpgradable(Boolean excludeLimitedUpgradable) {
            this.excludeLimitedUpgradable = excludeLimitedUpgradable;
            return this;
        }

        @JsonProperty(value="exclude_limited_non_upgradable")
        @Generated
        public GetChatGiftsBuilder excludeLimitedNonUpgradable(Boolean excludeLimitedNonUpgradable) {
            this.excludeLimitedNonUpgradable = excludeLimitedNonUpgradable;
            return this;
        }

        @JsonProperty(value="exclude_from_blockchain")
        @Generated
        public GetChatGiftsBuilder excludeFromBlockchain(Boolean excludeFromBlockchain) {
            this.excludeFromBlockchain = excludeFromBlockchain;
            return this;
        }

        @JsonProperty(value="exclude_unique")
        @Generated
        public GetChatGiftsBuilder excludeUnique(Boolean excludeUnique) {
            this.excludeUnique = excludeUnique;
            return this;
        }

        @JsonProperty(value="sort_by_price")
        @Generated
        public GetChatGiftsBuilder sortByPrice(Boolean sortByPrice) {
            this.sortByPrice = sortByPrice;
            return this;
        }

        @JsonProperty(value="offset")
        @Generated
        public GetChatGiftsBuilder offset(String offset) {
            this.offset = offset;
            return this;
        }

        @JsonProperty(value="limit")
        @Generated
        public GetChatGiftsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Generated
        public GetChatGifts build() {
            return new GetChatGifts(this.chatId, this.excludeUnsaved, this.excludeSaved, this.excludeUnlimited, this.excludeLimitedUpgradable, this.excludeLimitedNonUpgradable, this.excludeFromBlockchain, this.excludeUnique, this.sortByPrice, this.offset, this.limit);
        }

        @Generated
        public String toString() {
            return "GetChatGifts.GetChatGiftsBuilder(chatId=" + this.chatId + ", excludeUnsaved=" + this.excludeUnsaved + ", excludeSaved=" + this.excludeSaved + ", excludeUnlimited=" + this.excludeUnlimited + ", excludeLimitedUpgradable=" + this.excludeLimitedUpgradable + ", excludeLimitedNonUpgradable=" + this.excludeLimitedNonUpgradable + ", excludeFromBlockchain=" + this.excludeFromBlockchain + ", excludeUnique=" + this.excludeUnique + ", sortByPrice=" + this.sortByPrice + ", offset=" + this.offset + ", limit=" + this.limit + ")";
        }
    }
}

