/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.checklist;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodMessage;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.checklist.InputChecklist;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.meta.util.Validations;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=SendChecklistBuilderImpl.class)
public class SendChecklist
extends BotApiMethodMessage {
    public static final String PATH = "sendChecklist";
    private static final String BUSINESS_CONNECTION_ID_FIELD = "business_connection_id";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String CHECKLIST_FIELD = "checklist";
    private static final String DISABLE_NOTIFICATION_FIELD = "disable_notification";
    private static final String PROTECT_CONTENT_FIELD = "protect_content";
    private static final String MESSAGE_EFFECT_ID_FIELD = "message_effect_id";
    private static final String REPLY_PARAMETERS_FIELD = "reply_parameters";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    @JsonProperty(value="business_connection_id")
    @NonNull
    private String businessConnectionId;
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="checklist")
    @NonNull
    private InputChecklist checklist;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="protect_content")
    private Boolean protectContent;
    @JsonProperty(value="message_effect_id")
    private String messageEffectId;
    @JsonProperty(value="reply_parameters")
    private ReplyParameters replyParameters;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.businessConnectionId.isEmpty()) {
            throw new TelegramApiValidationException("BusinessConnectionId parameter can't be empty", this);
        }
        Validations.requiredChatId(this.chatId, this);
        this.checklist.validate();
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
    }

    @Generated
    protected SendChecklist(SendChecklistBuilder<?, ?> b) {
        super((BotApiMethodMessage.BotApiMethodMessageBuilder<?, ?>)b);
        this.businessConnectionId = b.businessConnectionId;
        if (this.businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        this.chatId = b.chatId;
        if (this.chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.checklist = b.checklist;
        if (this.checklist == null) {
            throw new NullPointerException("checklist is marked non-null but is null");
        }
        this.disableNotification = b.disableNotification;
        this.protectContent = b.protectContent;
        this.messageEffectId = b.messageEffectId;
        this.replyParameters = b.replyParameters;
        this.replyMarkup = b.replyMarkup;
    }

    @Generated
    public static SendChecklistBuilder<?, ?> builder() {
        return new SendChecklistBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendChecklist)) {
            return false;
        }
        SendChecklist other = (SendChecklist)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$businessConnectionId = this.getBusinessConnectionId();
        String other$businessConnectionId = other.getBusinessConnectionId();
        if (this$businessConnectionId == null ? other$businessConnectionId != null : !this$businessConnectionId.equals(other$businessConnectionId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        InputChecklist this$checklist = this.getChecklist();
        InputChecklist other$checklist = other.getChecklist();
        if (this$checklist == null ? other$checklist != null : !((Object)this$checklist).equals(other$checklist)) {
            return false;
        }
        String this$messageEffectId = this.getMessageEffectId();
        String other$messageEffectId = other.getMessageEffectId();
        if (this$messageEffectId == null ? other$messageEffectId != null : !this$messageEffectId.equals(other$messageEffectId)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        if (this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        return !(this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SendChecklist;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $businessConnectionId = this.getBusinessConnectionId();
        result = result * 59 + ($businessConnectionId == null ? 43 : $businessConnectionId.hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        InputChecklist $checklist = this.getChecklist();
        result = result * 59 + ($checklist == null ? 43 : ((Object)$checklist).hashCode());
        String $messageEffectId = this.getMessageEffectId();
        result = result * 59 + ($messageEffectId == null ? 43 : $messageEffectId.hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getBusinessConnectionId() {
        return this.businessConnectionId;
    }

    @NonNull
    @Generated
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    @Generated
    public InputChecklist getChecklist() {
        return this.checklist;
    }

    @Generated
    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    @Generated
    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @Generated
    public String getMessageEffectId() {
        return this.messageEffectId;
    }

    @Generated
    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    @Generated
    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @JsonProperty(value="business_connection_id")
    @Generated
    public void setBusinessConnectionId(@NonNull String businessConnectionId) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
    }

    @JsonProperty(value="chat_id")
    @Generated
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="checklist")
    @Generated
    public void setChecklist(@NonNull InputChecklist checklist) {
        if (checklist == null) {
            throw new NullPointerException("checklist is marked non-null but is null");
        }
        this.checklist = checklist;
    }

    @JsonProperty(value="disable_notification")
    @Generated
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="protect_content")
    @Generated
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @JsonProperty(value="message_effect_id")
    @Generated
    public void setMessageEffectId(String messageEffectId) {
        this.messageEffectId = messageEffectId;
    }

    @JsonProperty(value="reply_parameters")
    @Generated
    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    @JsonProperty(value="reply_markup")
    @Generated
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @Generated
    public String toString() {
        return "SendChecklist(businessConnectionId=" + this.getBusinessConnectionId() + ", chatId=" + this.getChatId() + ", checklist=" + this.getChecklist() + ", disableNotification=" + this.getDisableNotification() + ", protectContent=" + this.getProtectContent() + ", messageEffectId=" + this.getMessageEffectId() + ", replyParameters=" + this.getReplyParameters() + ", replyMarkup=" + this.getReplyMarkup() + ")";
    }

    @Generated
    protected SendChecklist() {
    }

    @Generated
    public SendChecklist(@NonNull String businessConnectionId, @NonNull String chatId, @NonNull InputChecklist checklist) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (checklist == null) {
            throw new NullPointerException("checklist is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
        this.chatId = chatId;
        this.checklist = checklist;
    }

    @Generated
    public SendChecklist(@NonNull String businessConnectionId, @NonNull String chatId, @NonNull InputChecklist checklist, Boolean disableNotification, Boolean protectContent, String messageEffectId, ReplyParameters replyParameters, InlineKeyboardMarkup replyMarkup) {
        if (businessConnectionId == null) {
            throw new NullPointerException("businessConnectionId is marked non-null but is null");
        }
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (checklist == null) {
            throw new NullPointerException("checklist is marked non-null but is null");
        }
        this.businessConnectionId = businessConnectionId;
        this.chatId = chatId;
        this.checklist = checklist;
        this.disableNotification = disableNotification;
        this.protectContent = protectContent;
        this.messageEffectId = messageEffectId;
        this.replyParameters = replyParameters;
        this.replyMarkup = replyMarkup;
    }

    public static abstract class SendChecklistBuilder<C extends SendChecklist, B extends SendChecklistBuilder<C, B>>
    extends BotApiMethodMessage.BotApiMethodMessageBuilder<C, B> {
        @Generated
        private String businessConnectionId;
        @Generated
        private String chatId;
        @Generated
        private InputChecklist checklist;
        @Generated
        private Boolean disableNotification;
        @Generated
        private Boolean protectContent;
        @Generated
        private String messageEffectId;
        @Generated
        private ReplyParameters replyParameters;
        @Generated
        private InlineKeyboardMarkup replyMarkup;

        public SendChecklistBuilder<C, B> chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        @JsonProperty(value="business_connection_id")
        @Generated
        public B businessConnectionId(@NonNull String businessConnectionId) {
            if (businessConnectionId == null) {
                throw new NullPointerException("businessConnectionId is marked non-null but is null");
            }
            this.businessConnectionId = businessConnectionId;
            return (B)this.self();
        }

        @JsonProperty(value="chat_id")
        @Generated
        public B chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return (B)this.self();
        }

        @JsonProperty(value="checklist")
        @Generated
        public B checklist(@NonNull InputChecklist checklist) {
            if (checklist == null) {
                throw new NullPointerException("checklist is marked non-null but is null");
            }
            this.checklist = checklist;
            return (B)this.self();
        }

        @JsonProperty(value="disable_notification")
        @Generated
        public B disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return (B)this.self();
        }

        @JsonProperty(value="protect_content")
        @Generated
        public B protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return (B)this.self();
        }

        @JsonProperty(value="message_effect_id")
        @Generated
        public B messageEffectId(String messageEffectId) {
            this.messageEffectId = messageEffectId;
            return (B)this.self();
        }

        @JsonProperty(value="reply_parameters")
        @Generated
        public B replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return (B)this.self();
        }

        @JsonProperty(value="reply_markup")
        @Generated
        public B replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SendChecklist.SendChecklistBuilder(super=" + super.toString() + ", businessConnectionId=" + this.businessConnectionId + ", chatId=" + this.chatId + ", checklist=" + this.checklist + ", disableNotification=" + this.disableNotification + ", protectContent=" + this.protectContent + ", messageEffectId=" + this.messageEffectId + ", replyParameters=" + this.replyParameters + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class SendChecklistBuilderImpl
    extends SendChecklistBuilder<SendChecklist, SendChecklistBuilderImpl> {
        @Generated
        private SendChecklistBuilderImpl() {
        }

        @Override
        @Generated
        protected SendChecklistBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SendChecklist build() {
            return new SendChecklist(this);
        }
    }
}

