/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultsButton;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=AnswerInlineQueryBuilderImpl.class)
public class AnswerInlineQuery
extends BotApiMethodBoolean {
    public static final String PATH = "answerInlineQuery";
    private static final String INLINEQUERYID_FIELD = "inline_query_id";
    private static final String RESULTS_FIELD = "results";
    private static final String CACHETIME_FIELD = "cache_time";
    private static final String ISPERSONAL_FIELD = "is_personal";
    private static final String NEXTOFFSET_FIELD = "next_offset";
    private static final String SWITCH_PM_TEXT_FIELD = "switch_pm_text";
    private static final String SWITCH_PM_PARAMETER_FIELD = "switch_pm_parameter";
    private static final String BUTTON_FIELD = "button";
    @JsonProperty(value="inline_query_id")
    @NonNull
    private String inlineQueryId;
    @JsonProperty(value="results")
    @NonNull
    private List<InlineQueryResult> results;
    @JsonProperty(value="cache_time")
    private Integer cacheTime;
    @JsonProperty(value="is_personal")
    private Boolean isPersonal;
    @JsonProperty(value="next_offset")
    private String nextOffset;
    @JsonProperty(value="button")
    private InlineQueryResultsButton button;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineQueryId.isEmpty()) {
            throw new TelegramApiValidationException("InlineQueryId can't be empty", this);
        }
        for (InlineQueryResult result : this.results) {
            result.validate();
        }
        if (this.button != null) {
            this.button.validate();
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Generated
    protected AnswerInlineQuery(AnswerInlineQueryBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.inlineQueryId = b.inlineQueryId;
        if (this.inlineQueryId == null) {
            throw new NullPointerException("inlineQueryId is marked non-null but is null");
        }
        List<Object> results = switch (b.results == null ? 0 : b.results.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.results.get(0));
            default -> Collections.unmodifiableList(new ArrayList<InlineQueryResult>(b.results));
        };
        this.results = results;
        if (results == null) {
            throw new NullPointerException("results is marked non-null but is null");
        }
        this.cacheTime = b.cacheTime;
        this.isPersonal = b.isPersonal;
        this.nextOffset = b.nextOffset;
        this.button = b.button;
    }

    @Generated
    public static AnswerInlineQueryBuilder<?, ?> builder() {
        return new AnswerInlineQueryBuilderImpl();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerInlineQuery)) {
            return false;
        }
        AnswerInlineQuery other = (AnswerInlineQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$cacheTime = this.getCacheTime();
        Integer other$cacheTime = other.getCacheTime();
        if (this$cacheTime == null ? other$cacheTime != null : !((Object)this$cacheTime).equals(other$cacheTime)) {
            return false;
        }
        Boolean this$isPersonal = this.getIsPersonal();
        Boolean other$isPersonal = other.getIsPersonal();
        if (this$isPersonal == null ? other$isPersonal != null : !((Object)this$isPersonal).equals(other$isPersonal)) {
            return false;
        }
        String this$inlineQueryId = this.getInlineQueryId();
        String other$inlineQueryId = other.getInlineQueryId();
        if (this$inlineQueryId == null ? other$inlineQueryId != null : !this$inlineQueryId.equals(other$inlineQueryId)) {
            return false;
        }
        List<InlineQueryResult> this$results = this.getResults();
        List<InlineQueryResult> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        String this$nextOffset = this.getNextOffset();
        String other$nextOffset = other.getNextOffset();
        if (this$nextOffset == null ? other$nextOffset != null : !this$nextOffset.equals(other$nextOffset)) {
            return false;
        }
        InlineQueryResultsButton this$button = this.getButton();
        InlineQueryResultsButton other$button = other.getButton();
        return !(this$button == null ? other$button != null : !((Object)this$button).equals(other$button));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnswerInlineQuery;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $cacheTime = this.getCacheTime();
        result = result * 59 + ($cacheTime == null ? 43 : ((Object)$cacheTime).hashCode());
        Boolean $isPersonal = this.getIsPersonal();
        result = result * 59 + ($isPersonal == null ? 43 : ((Object)$isPersonal).hashCode());
        String $inlineQueryId = this.getInlineQueryId();
        result = result * 59 + ($inlineQueryId == null ? 43 : $inlineQueryId.hashCode());
        List<InlineQueryResult> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        String $nextOffset = this.getNextOffset();
        result = result * 59 + ($nextOffset == null ? 43 : $nextOffset.hashCode());
        InlineQueryResultsButton $button = this.getButton();
        result = result * 59 + ($button == null ? 43 : ((Object)$button).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getInlineQueryId() {
        return this.inlineQueryId;
    }

    @NonNull
    @Generated
    public List<InlineQueryResult> getResults() {
        return this.results;
    }

    @Generated
    public Integer getCacheTime() {
        return this.cacheTime;
    }

    @Generated
    public Boolean getIsPersonal() {
        return this.isPersonal;
    }

    @Generated
    public String getNextOffset() {
        return this.nextOffset;
    }

    @Generated
    public InlineQueryResultsButton getButton() {
        return this.button;
    }

    @JsonProperty(value="inline_query_id")
    @Generated
    public void setInlineQueryId(@NonNull String inlineQueryId) {
        if (inlineQueryId == null) {
            throw new NullPointerException("inlineQueryId is marked non-null but is null");
        }
        this.inlineQueryId = inlineQueryId;
    }

    @JsonProperty(value="results")
    @Generated
    public void setResults(@NonNull List<InlineQueryResult> results) {
        if (results == null) {
            throw new NullPointerException("results is marked non-null but is null");
        }
        this.results = results;
    }

    @JsonProperty(value="cache_time")
    @Generated
    public void setCacheTime(Integer cacheTime) {
        this.cacheTime = cacheTime;
    }

    @JsonProperty(value="is_personal")
    @Generated
    public void setIsPersonal(Boolean isPersonal) {
        this.isPersonal = isPersonal;
    }

    @JsonProperty(value="next_offset")
    @Generated
    public void setNextOffset(String nextOffset) {
        this.nextOffset = nextOffset;
    }

    @JsonProperty(value="button")
    @Generated
    public void setButton(InlineQueryResultsButton button) {
        this.button = button;
    }

    @Generated
    public String toString() {
        return "AnswerInlineQuery(inlineQueryId=" + this.getInlineQueryId() + ", results=" + this.getResults() + ", cacheTime=" + this.getCacheTime() + ", isPersonal=" + this.getIsPersonal() + ", nextOffset=" + this.getNextOffset() + ", button=" + this.getButton() + ")";
    }

    @Generated
    public AnswerInlineQuery(@NonNull String inlineQueryId, @NonNull List<InlineQueryResult> results) {
        if (inlineQueryId == null) {
            throw new NullPointerException("inlineQueryId is marked non-null but is null");
        }
        if (results == null) {
            throw new NullPointerException("results is marked non-null but is null");
        }
        this.inlineQueryId = inlineQueryId;
        this.results = results;
    }

    @Generated
    public AnswerInlineQuery(@NonNull String inlineQueryId, @NonNull List<InlineQueryResult> results, Integer cacheTime, Boolean isPersonal, String nextOffset, InlineQueryResultsButton button) {
        if (inlineQueryId == null) {
            throw new NullPointerException("inlineQueryId is marked non-null but is null");
        }
        if (results == null) {
            throw new NullPointerException("results is marked non-null but is null");
        }
        this.inlineQueryId = inlineQueryId;
        this.results = results;
        this.cacheTime = cacheTime;
        this.isPersonal = isPersonal;
        this.nextOffset = nextOffset;
        this.button = button;
    }

    @Generated
    public static abstract class AnswerInlineQueryBuilder<C extends AnswerInlineQuery, B extends AnswerInlineQueryBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        @Generated
        private String inlineQueryId;
        @Generated
        private ArrayList<InlineQueryResult> results;
        @Generated
        private Integer cacheTime;
        @Generated
        private Boolean isPersonal;
        @Generated
        private String nextOffset;
        @Generated
        private InlineQueryResultsButton button;

        @JsonProperty(value="inline_query_id")
        @Generated
        public B inlineQueryId(@NonNull String inlineQueryId) {
            if (inlineQueryId == null) {
                throw new NullPointerException("inlineQueryId is marked non-null but is null");
            }
            this.inlineQueryId = inlineQueryId;
            return (B)this.self();
        }

        @Generated
        public B result(InlineQueryResult result) {
            if (this.results == null) {
                this.results = new ArrayList();
            }
            this.results.add(result);
            return (B)this.self();
        }

        @JsonProperty(value="results")
        @Generated
        public B results(Collection<? extends InlineQueryResult> results) {
            if (results == null) {
                throw new NullPointerException("results cannot be null");
            }
            if (this.results == null) {
                this.results = new ArrayList();
            }
            this.results.addAll(results);
            return (B)this.self();
        }

        @Generated
        public B clearResults() {
            if (this.results != null) {
                this.results.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="cache_time")
        @Generated
        public B cacheTime(Integer cacheTime) {
            this.cacheTime = cacheTime;
            return (B)this.self();
        }

        @JsonProperty(value="is_personal")
        @Generated
        public B isPersonal(Boolean isPersonal) {
            this.isPersonal = isPersonal;
            return (B)this.self();
        }

        @JsonProperty(value="next_offset")
        @Generated
        public B nextOffset(String nextOffset) {
            this.nextOffset = nextOffset;
            return (B)this.self();
        }

        @JsonProperty(value="button")
        @Generated
        public B button(InlineQueryResultsButton button) {
            this.button = button;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AnswerInlineQuery.AnswerInlineQueryBuilder(super=" + super.toString() + ", inlineQueryId=" + this.inlineQueryId + ", results=" + this.results + ", cacheTime=" + this.cacheTime + ", isPersonal=" + this.isPersonal + ", nextOffset=" + this.nextOffset + ", button=" + this.button + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class AnswerInlineQueryBuilderImpl
    extends AnswerInlineQueryBuilder<AnswerInlineQuery, AnswerInlineQueryBuilderImpl> {
        @Generated
        private AnswerInlineQueryBuilderImpl() {
        }

        @Override
        @Generated
        protected AnswerInlineQueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AnswerInlineQuery build() {
            return new AnswerInlineQuery(this);
        }
    }
}

