/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.exceptions;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.ResponseParameters;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

public class TelegramApiRequestException
extends TelegramApiException {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String ERRORDESCRIPTIONFIELD = "description";
    private static final String ERRORCODEFIELD = "error_code";
    private static final String PARAMETERSFIELD = "parameters";
    private String apiResponse = null;
    private Integer errorCode = 0;
    private ResponseParameters parameters;

    public TelegramApiRequestException(String message) {
        super(message);
    }

    public TelegramApiRequestException(String message, ApiResponse<?> response) {
        super(message);
        this.apiResponse = response.getErrorDescription();
        this.errorCode = response.getErrorCode();
        this.parameters = response.getParameters();
    }

    public TelegramApiRequestException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public String getMessage() {
        if (this.apiResponse == null) {
            return super.getMessage();
        }
        if (this.errorCode == null) {
            return super.getMessage() + ": " + this.apiResponse;
        }
        return super.getMessage() + ": [" + this.errorCode + "] " + this.apiResponse;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public String getApiResponse() {
        return this.apiResponse;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public ResponseParameters getParameters() {
        return this.parameters;
    }
}

