/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.stickers;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.stickers.MaskPosition;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InputStickerBuilderImpl.class)
public class InputSticker
implements BotApiObject,
Validable {
    private static final String STICKER_FIELD = "sticker";
    private static final String EMOJI_LIST_FIELD = "emoji_list";
    private static final String MASK_POSITION_FIELD = "mask_position";
    private static final String KEYWORDS_FIELD = "keywords";
    private static final String FORMAT_FIELD = "format";
    @JsonProperty(value="sticker")
    @NonNull
    private InputFile sticker;
    @JsonProperty(value="emoji_list")
    @NonNull
    private List<String> emojiList;
    @JsonProperty(value="format")
    @NonNull
    private String format;
    @JsonProperty(value="mask_position")
    private MaskPosition maskPosition;
    @JsonProperty(value="keywords")
    private List<String> keywords;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.emojiList.isEmpty() || this.emojiList.size() > 20) {
            throw new TelegramApiValidationException("Emoji list must have between 1 and 20 items", this);
        }
        if (this.keywords != null && this.keywords.size() > 20) {
            throw new TelegramApiValidationException("Keywords list must have between 0 and 20 items", this);
        }
        if (!Arrays.asList("static", "animated", "video").contains(this.format)) {
            throw new TelegramApiValidationException("Format must be 'static', 'animated', 'video'", this);
        }
        if (this.maskPosition != null) {
            this.maskPosition.validate();
        }
        this.sticker.validate();
    }

    protected InputSticker(InputStickerBuilder<?, ?> b) {
        this.sticker = b.sticker;
        if (this.sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        List<Object> emojiList = switch (b.emojiList == null ? 0 : b.emojiList.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.emojiList.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.emojiList));
        };
        this.emojiList = emojiList;
        if (emojiList == null) {
            throw new NullPointerException("emojiList is marked non-null but is null");
        }
        this.format = b.format;
        if (this.format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.maskPosition = b.maskPosition;
        this.keywords = switch (b.keywords == null ? 0 : b.keywords.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.keywords.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.keywords));
        };
    }

    public static InputStickerBuilder<?, ?> builder() {
        return new InputStickerBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputSticker)) {
            return false;
        }
        InputSticker other = (InputSticker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InputFile this$sticker = this.getSticker();
        InputFile other$sticker = other.getSticker();
        if (this$sticker == null ? other$sticker != null : !((Object)this$sticker).equals(other$sticker)) {
            return false;
        }
        List<String> this$emojiList = this.getEmojiList();
        List<String> other$emojiList = other.getEmojiList();
        if (this$emojiList == null ? other$emojiList != null : !((Object)this$emojiList).equals(other$emojiList)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        MaskPosition this$maskPosition = this.getMaskPosition();
        MaskPosition other$maskPosition = other.getMaskPosition();
        if (this$maskPosition == null ? other$maskPosition != null : !((Object)this$maskPosition).equals(other$maskPosition)) {
            return false;
        }
        List<String> this$keywords = this.getKeywords();
        List<String> other$keywords = other.getKeywords();
        return !(this$keywords == null ? other$keywords != null : !((Object)this$keywords).equals(other$keywords));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputSticker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InputFile $sticker = this.getSticker();
        result = result * 59 + ($sticker == null ? 43 : ((Object)$sticker).hashCode());
        List<String> $emojiList = this.getEmojiList();
        result = result * 59 + ($emojiList == null ? 43 : ((Object)$emojiList).hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        MaskPosition $maskPosition = this.getMaskPosition();
        result = result * 59 + ($maskPosition == null ? 43 : ((Object)$maskPosition).hashCode());
        List<String> $keywords = this.getKeywords();
        result = result * 59 + ($keywords == null ? 43 : ((Object)$keywords).hashCode());
        return result;
    }

    @NonNull
    public InputFile getSticker() {
        return this.sticker;
    }

    @NonNull
    public List<String> getEmojiList() {
        return this.emojiList;
    }

    @NonNull
    public String getFormat() {
        return this.format;
    }

    public MaskPosition getMaskPosition() {
        return this.maskPosition;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="sticker")
    public void setSticker(@NonNull InputFile sticker) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
    }

    @JsonProperty(value="emoji_list")
    public void setEmojiList(@NonNull List<String> emojiList) {
        if (emojiList == null) {
            throw new NullPointerException("emojiList is marked non-null but is null");
        }
        this.emojiList = emojiList;
    }

    @JsonProperty(value="format")
    public void setFormat(@NonNull String format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = format;
    }

    @JsonProperty(value="mask_position")
    public void setMaskPosition(MaskPosition maskPosition) {
        this.maskPosition = maskPosition;
    }

    @JsonProperty(value="keywords")
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public String toString() {
        return "InputSticker(sticker=" + this.getSticker() + ", emojiList=" + this.getEmojiList() + ", format=" + this.getFormat() + ", maskPosition=" + this.getMaskPosition() + ", keywords=" + this.getKeywords() + ")";
    }

    public InputSticker(@NonNull InputFile sticker, @NonNull List<String> emojiList, @NonNull String format) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        if (emojiList == null) {
            throw new NullPointerException("emojiList is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.sticker = sticker;
        this.emojiList = emojiList;
        this.format = format;
    }

    public InputSticker(@NonNull InputFile sticker, @NonNull List<String> emojiList, @NonNull String format, MaskPosition maskPosition, List<String> keywords) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        if (emojiList == null) {
            throw new NullPointerException("emojiList is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.sticker = sticker;
        this.emojiList = emojiList;
        this.format = format;
        this.maskPosition = maskPosition;
        this.keywords = keywords;
    }

    public static abstract class InputStickerBuilder<C extends InputSticker, B extends InputStickerBuilder<C, B>> {
        private InputFile sticker;
        private ArrayList<String> emojiList;
        private String format;
        private MaskPosition maskPosition;
        private ArrayList<String> keywords;

        @JsonProperty(value="sticker")
        public B sticker(@NonNull InputFile sticker) {
            if (sticker == null) {
                throw new NullPointerException("sticker is marked non-null but is null");
            }
            this.sticker = sticker;
            return this.self();
        }

        public B emoji(String emoji) {
            if (this.emojiList == null) {
                this.emojiList = new ArrayList();
            }
            this.emojiList.add(emoji);
            return this.self();
        }

        @JsonProperty(value="emoji_list")
        public B emojiList(Collection<? extends String> emojiList) {
            if (emojiList == null) {
                throw new NullPointerException("emojiList cannot be null");
            }
            if (this.emojiList == null) {
                this.emojiList = new ArrayList();
            }
            this.emojiList.addAll(emojiList);
            return this.self();
        }

        public B clearEmojiList() {
            if (this.emojiList != null) {
                this.emojiList.clear();
            }
            return this.self();
        }

        @JsonProperty(value="format")
        public B format(@NonNull String format) {
            if (format == null) {
                throw new NullPointerException("format is marked non-null but is null");
            }
            this.format = format;
            return this.self();
        }

        @JsonProperty(value="mask_position")
        public B maskPosition(MaskPosition maskPosition) {
            this.maskPosition = maskPosition;
            return this.self();
        }

        public B keyword(String keyword) {
            if (this.keywords == null) {
                this.keywords = new ArrayList();
            }
            this.keywords.add(keyword);
            return this.self();
        }

        @JsonProperty(value="keywords")
        public B keywords(Collection<? extends String> keywords) {
            if (keywords == null) {
                throw new NullPointerException("keywords cannot be null");
            }
            if (this.keywords == null) {
                this.keywords = new ArrayList();
            }
            this.keywords.addAll(keywords);
            return this.self();
        }

        public B clearKeywords() {
            if (this.keywords != null) {
                this.keywords.clear();
            }
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "InputSticker.InputStickerBuilder(sticker=" + this.sticker + ", emojiList=" + this.emojiList + ", format=" + this.format + ", maskPosition=" + this.maskPosition + ", keywords=" + this.keywords + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InputStickerBuilderImpl
    extends InputStickerBuilder<InputSticker, InputStickerBuilderImpl> {
        private InputStickerBuilderImpl() {
        }

        @Override
        protected InputStickerBuilderImpl self() {
            return this;
        }

        @Override
        public InputSticker build() {
            return new InputSticker(this);
        }
    }
}

