/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.payments;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.payments.LabeledPrice;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=ShippingOptionBuilderImpl.class)
public class ShippingOption
implements Validable,
BotApiObject {
    private static final String ID_FIELD = "id";
    private static final String TITLE_FIELD = "title";
    private static final String PRICES_FIELD = "prices";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="title")
    @NonNull
    private String title;
    @JsonProperty(value="prices")
    @NonNull
    private List<LabeledPrice> prices;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id == null || this.id.isEmpty()) {
            throw new TelegramApiValidationException("Id parameter can't be empty", this);
        }
        if (this.title == null || this.title.isEmpty()) {
            throw new TelegramApiValidationException("Title parameter can't be empty", this);
        }
        if (this.prices == null || this.prices.isEmpty()) {
            throw new TelegramApiValidationException("Prices parameter can't be empty", this);
        }
        for (LabeledPrice price : this.prices) {
            price.validate();
        }
    }

    protected ShippingOption(ShippingOptionBuilder<?, ?> b) {
        this.id = b.id;
        if (this.id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.title = b.title;
        if (this.title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        List<Object> prices = switch (b.prices == null ? 0 : b.prices.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.prices.get(0));
            default -> Collections.unmodifiableList(new ArrayList<LabeledPrice>(b.prices));
        };
        this.prices = prices;
        if (prices == null) {
            throw new NullPointerException("prices is marked non-null but is null");
        }
    }

    public static ShippingOptionBuilder<?, ?> builder() {
        return new ShippingOptionBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShippingOption)) {
            return false;
        }
        ShippingOption other = (ShippingOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<LabeledPrice> this$prices = this.getPrices();
        List<LabeledPrice> other$prices = other.getPrices();
        return !(this$prices == null ? other$prices != null : !((Object)this$prices).equals(other$prices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShippingOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<LabeledPrice> $prices = this.getPrices();
        result = result * 59 + ($prices == null ? 43 : ((Object)$prices).hashCode());
        return result;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public List<LabeledPrice> getPrices() {
        return this.prices;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="title")
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @JsonProperty(value="prices")
    public void setPrices(@NonNull List<LabeledPrice> prices) {
        if (prices == null) {
            throw new NullPointerException("prices is marked non-null but is null");
        }
        this.prices = prices;
    }

    public String toString() {
        return "ShippingOption(id=" + this.getId() + ", title=" + this.getTitle() + ", prices=" + this.getPrices() + ")";
    }

    public ShippingOption(@NonNull String id, @NonNull String title, @NonNull List<LabeledPrice> prices) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (prices == null) {
            throw new NullPointerException("prices is marked non-null but is null");
        }
        this.id = id;
        this.title = title;
        this.prices = prices;
    }

    public static abstract class ShippingOptionBuilder<C extends ShippingOption, B extends ShippingOptionBuilder<C, B>> {
        private String id;
        private String title;
        private ArrayList<LabeledPrice> prices;

        @JsonProperty(value="id")
        public B id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this.self();
        }

        @JsonProperty(value="title")
        public B title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this.self();
        }

        public B price(LabeledPrice price) {
            if (this.prices == null) {
                this.prices = new ArrayList();
            }
            this.prices.add(price);
            return this.self();
        }

        @JsonProperty(value="prices")
        public B prices(Collection<? extends LabeledPrice> prices) {
            if (prices == null) {
                throw new NullPointerException("prices cannot be null");
            }
            if (this.prices == null) {
                this.prices = new ArrayList();
            }
            this.prices.addAll(prices);
            return this.self();
        }

        public B clearPrices() {
            if (this.prices != null) {
                this.prices.clear();
            }
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "ShippingOption.ShippingOptionBuilder(id=" + this.id + ", title=" + this.title + ", prices=" + this.prices + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class ShippingOptionBuilderImpl
    extends ShippingOptionBuilder<ShippingOption, ShippingOptionBuilderImpl> {
        private ShippingOptionBuilderImpl() {
        }

        @Override
        protected ShippingOptionBuilderImpl self() {
            return this;
        }

        @Override
        public ShippingOption build() {
            return new ShippingOption(this);
        }
    }
}

