/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=InputContactMessageContentBuilderImpl.class)
public class InputContactMessageContent
implements InputMessageContent {
    private static final String PHONE_NUMBER_FIELD = "phone_number";
    private static final String FIRST_NAME_FIELD = "first_name";
    private static final String LAST_NAME_FIELD = "last_name";
    private static final String VCARD_FIELD = "vcard";
    @JsonProperty(value="phone_number")
    @NonNull
    private String phoneNumber;
    @JsonProperty(value="first_name")
    @NonNull
    private String firstName;
    @JsonProperty(value="last_name")
    private String lastName;
    @JsonProperty(value="vcard")
    private String vCard;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.phoneNumber == null || this.phoneNumber.isEmpty()) {
            throw new TelegramApiValidationException("PhoneNumber parameter can't be empty", this);
        }
        if (this.firstName == null || this.firstName.isEmpty()) {
            throw new TelegramApiValidationException("FirstName parameter can't be empty", this);
        }
    }

    protected InputContactMessageContent(InputContactMessageContentBuilder<?, ?> b) {
        this.phoneNumber = b.phoneNumber;
        if (this.phoneNumber == null) {
            throw new NullPointerException("phoneNumber is marked non-null but is null");
        }
        this.firstName = b.firstName;
        if (this.firstName == null) {
            throw new NullPointerException("firstName is marked non-null but is null");
        }
        this.lastName = b.lastName;
        this.vCard = b.vCard;
    }

    public static InputContactMessageContentBuilder<?, ?> builder() {
        return new InputContactMessageContentBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputContactMessageContent)) {
            return false;
        }
        InputContactMessageContent other = (InputContactMessageContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$phoneNumber = this.getPhoneNumber();
        String other$phoneNumber = other.getPhoneNumber();
        if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$vCard = this.getVCard();
        String other$vCard = other.getVCard();
        return !(this$vCard == null ? other$vCard != null : !this$vCard.equals(other$vCard));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputContactMessageContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $phoneNumber = this.getPhoneNumber();
        result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $vCard = this.getVCard();
        result = result * 59 + ($vCard == null ? 43 : $vCard.hashCode());
        return result;
    }

    @NonNull
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @NonNull
    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getVCard() {
        return this.vCard;
    }

    @JsonProperty(value="phone_number")
    public void setPhoneNumber(@NonNull String phoneNumber) {
        if (phoneNumber == null) {
            throw new NullPointerException("phoneNumber is marked non-null but is null");
        }
        this.phoneNumber = phoneNumber;
    }

    @JsonProperty(value="first_name")
    public void setFirstName(@NonNull String firstName) {
        if (firstName == null) {
            throw new NullPointerException("firstName is marked non-null but is null");
        }
        this.firstName = firstName;
    }

    @JsonProperty(value="last_name")
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @JsonProperty(value="vcard")
    public void setVCard(String vCard) {
        this.vCard = vCard;
    }

    public String toString() {
        return "InputContactMessageContent(phoneNumber=" + this.getPhoneNumber() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", vCard=" + this.getVCard() + ")";
    }

    public InputContactMessageContent(@NonNull String phoneNumber, @NonNull String firstName) {
        if (phoneNumber == null) {
            throw new NullPointerException("phoneNumber is marked non-null but is null");
        }
        if (firstName == null) {
            throw new NullPointerException("firstName is marked non-null but is null");
        }
        this.phoneNumber = phoneNumber;
        this.firstName = firstName;
    }

    public InputContactMessageContent(@NonNull String phoneNumber, @NonNull String firstName, String lastName, String vCard) {
        if (phoneNumber == null) {
            throw new NullPointerException("phoneNumber is marked non-null but is null");
        }
        if (firstName == null) {
            throw new NullPointerException("firstName is marked non-null but is null");
        }
        this.phoneNumber = phoneNumber;
        this.firstName = firstName;
        this.lastName = lastName;
        this.vCard = vCard;
    }

    public static abstract class InputContactMessageContentBuilder<C extends InputContactMessageContent, B extends InputContactMessageContentBuilder<C, B>> {
        private String phoneNumber;
        private String firstName;
        private String lastName;
        private String vCard;

        @JsonProperty(value="phone_number")
        public B phoneNumber(@NonNull String phoneNumber) {
            if (phoneNumber == null) {
                throw new NullPointerException("phoneNumber is marked non-null but is null");
            }
            this.phoneNumber = phoneNumber;
            return this.self();
        }

        @JsonProperty(value="first_name")
        public B firstName(@NonNull String firstName) {
            if (firstName == null) {
                throw new NullPointerException("firstName is marked non-null but is null");
            }
            this.firstName = firstName;
            return this.self();
        }

        @JsonProperty(value="last_name")
        public B lastName(String lastName) {
            this.lastName = lastName;
            return this.self();
        }

        @JsonProperty(value="vcard")
        public B vCard(String vCard) {
            this.vCard = vCard;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "InputContactMessageContent.InputContactMessageContentBuilder(phoneNumber=" + this.phoneNumber + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", vCard=" + this.vCard + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InputContactMessageContentBuilderImpl
    extends InputContactMessageContentBuilder<InputContactMessageContent, InputContactMessageContentBuilderImpl> {
        private InputContactMessageContentBuilderImpl() {
        }

        @Override
        protected InputContactMessageContentBuilderImpl self() {
            return this;
        }

        @Override
        public InputContactMessageContent build() {
            return new InputContactMessageContent(this);
        }
    }
}

