/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.updates;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=SetWebhookBuilderImpl.class)
public class SetWebhook
extends BotApiMethodBoolean {
    public static final String PATH = "setWebhook";
    public static final String URL_FIELD = "url";
    public static final String CERTIFICATE_FIELD = "certificate";
    public static final String MAXCONNECTIONS_FIELD = "max_connections";
    public static final String ALLOWEDUPDATES_FIELD = "allowed_updates";
    public static final String IPADDRESS_FIELD = "ip_address";
    public static final String DROPPENDINGUPDATES_FIELD = "drop_pending_updates";
    public static final String SECRETTOKEN_FIELD = "secret_token";
    @JsonProperty(value="url")
    @NonNull
    private String url;
    @JsonProperty(value="certificate")
    private InputFile certificate;
    @JsonProperty(value="max_connections")
    private Integer maxConnections;
    @JsonProperty(value="allowed_updates")
    private List<String> allowedUpdates;
    @JsonProperty(value="ip_address")
    private String ipAddress;
    @JsonProperty(value="drop_pending_updates")
    private Boolean dropPendingUpdates;
    @JsonProperty(value="secret_token")
    private String secretToken;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.url.isEmpty()) {
            throw new TelegramApiValidationException("URL parameter can't be empty", this);
        }
        if (this.certificate != null && !this.certificate.isNew()) {
            throw new TelegramApiValidationException("Certificate parameter must be a new file to upload", this);
        }
        if (this.secretToken != null && !this.secretToken.matches("[A-Za-z0-9_-]+")) {
            throw new TelegramApiValidationException("SecretToken parameter must only contains A-Z, a-z, 0-9, _ and -", this);
        }
    }

    protected SetWebhook(SetWebhookBuilder<?, ?> b) {
        super((BotApiMethodBoolean.BotApiMethodBooleanBuilder<?, ?>)b);
        this.url = b.url;
        if (this.url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.certificate = b.certificate;
        this.maxConnections = b.maxConnections;
        this.allowedUpdates = switch (b.allowedUpdates == null ? 0 : b.allowedUpdates.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.allowedUpdates.get(0));
            default -> Collections.unmodifiableList(new ArrayList<String>(b.allowedUpdates));
        };
        this.ipAddress = b.ipAddress;
        this.dropPendingUpdates = b.dropPendingUpdates;
        this.secretToken = b.secretToken;
    }

    public static SetWebhookBuilder<?, ?> builder() {
        return new SetWebhookBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetWebhook)) {
            return false;
        }
        SetWebhook other = (SetWebhook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxConnections = this.getMaxConnections();
        Integer other$maxConnections = other.getMaxConnections();
        if (this$maxConnections == null ? other$maxConnections != null : !((Object)this$maxConnections).equals(other$maxConnections)) {
            return false;
        }
        Boolean this$dropPendingUpdates = this.getDropPendingUpdates();
        Boolean other$dropPendingUpdates = other.getDropPendingUpdates();
        if (this$dropPendingUpdates == null ? other$dropPendingUpdates != null : !((Object)this$dropPendingUpdates).equals(other$dropPendingUpdates)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        InputFile this$certificate = this.getCertificate();
        InputFile other$certificate = other.getCertificate();
        if (this$certificate == null ? other$certificate != null : !((Object)this$certificate).equals(other$certificate)) {
            return false;
        }
        List<String> this$allowedUpdates = this.getAllowedUpdates();
        List<String> other$allowedUpdates = other.getAllowedUpdates();
        if (this$allowedUpdates == null ? other$allowedUpdates != null : !((Object)this$allowedUpdates).equals(other$allowedUpdates)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$secretToken = this.getSecretToken();
        String other$secretToken = other.getSecretToken();
        return !(this$secretToken == null ? other$secretToken != null : !this$secretToken.equals(other$secretToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetWebhook;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxConnections = this.getMaxConnections();
        result = result * 59 + ($maxConnections == null ? 43 : ((Object)$maxConnections).hashCode());
        Boolean $dropPendingUpdates = this.getDropPendingUpdates();
        result = result * 59 + ($dropPendingUpdates == null ? 43 : ((Object)$dropPendingUpdates).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        InputFile $certificate = this.getCertificate();
        result = result * 59 + ($certificate == null ? 43 : ((Object)$certificate).hashCode());
        List<String> $allowedUpdates = this.getAllowedUpdates();
        result = result * 59 + ($allowedUpdates == null ? 43 : ((Object)$allowedUpdates).hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $secretToken = this.getSecretToken();
        result = result * 59 + ($secretToken == null ? 43 : $secretToken.hashCode());
        return result;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public InputFile getCertificate() {
        return this.certificate;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public List<String> getAllowedUpdates() {
        return this.allowedUpdates;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Boolean getDropPendingUpdates() {
        return this.dropPendingUpdates;
    }

    public String getSecretToken() {
        return this.secretToken;
    }

    @JsonProperty(value="url")
    public void setUrl(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    @JsonProperty(value="certificate")
    public void setCertificate(InputFile certificate) {
        this.certificate = certificate;
    }

    @JsonProperty(value="max_connections")
    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    @JsonProperty(value="allowed_updates")
    public void setAllowedUpdates(List<String> allowedUpdates) {
        this.allowedUpdates = allowedUpdates;
    }

    @JsonProperty(value="ip_address")
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @JsonProperty(value="drop_pending_updates")
    public void setDropPendingUpdates(Boolean dropPendingUpdates) {
        this.dropPendingUpdates = dropPendingUpdates;
    }

    @JsonProperty(value="secret_token")
    public void setSecretToken(String secretToken) {
        this.secretToken = secretToken;
    }

    public String toString() {
        return "SetWebhook(url=" + this.getUrl() + ", certificate=" + this.getCertificate() + ", maxConnections=" + this.getMaxConnections() + ", allowedUpdates=" + this.getAllowedUpdates() + ", ipAddress=" + this.getIpAddress() + ", dropPendingUpdates=" + this.getDropPendingUpdates() + ", secretToken=" + this.getSecretToken() + ")";
    }

    public SetWebhook(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    public SetWebhook(@NonNull String url, InputFile certificate, Integer maxConnections, List<String> allowedUpdates, String ipAddress, Boolean dropPendingUpdates, String secretToken) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
        this.certificate = certificate;
        this.maxConnections = maxConnections;
        this.allowedUpdates = allowedUpdates;
        this.ipAddress = ipAddress;
        this.dropPendingUpdates = dropPendingUpdates;
        this.secretToken = secretToken;
    }

    public static abstract class SetWebhookBuilder<C extends SetWebhook, B extends SetWebhookBuilder<C, B>>
    extends BotApiMethodBoolean.BotApiMethodBooleanBuilder<C, B> {
        private String url;
        private InputFile certificate;
        private Integer maxConnections;
        private ArrayList<String> allowedUpdates;
        private String ipAddress;
        private Boolean dropPendingUpdates;
        private String secretToken;

        @JsonProperty(value="url")
        public B url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return (B)this.self();
        }

        @JsonProperty(value="certificate")
        public B certificate(InputFile certificate) {
            this.certificate = certificate;
            return (B)this.self();
        }

        @JsonProperty(value="max_connections")
        public B maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return (B)this.self();
        }

        public B allowedUpdate(String allowedUpdate) {
            if (this.allowedUpdates == null) {
                this.allowedUpdates = new ArrayList();
            }
            this.allowedUpdates.add(allowedUpdate);
            return (B)this.self();
        }

        @JsonProperty(value="allowed_updates")
        public B allowedUpdates(Collection<? extends String> allowedUpdates) {
            if (allowedUpdates == null) {
                throw new NullPointerException("allowedUpdates cannot be null");
            }
            if (this.allowedUpdates == null) {
                this.allowedUpdates = new ArrayList();
            }
            this.allowedUpdates.addAll(allowedUpdates);
            return (B)this.self();
        }

        public B clearAllowedUpdates() {
            if (this.allowedUpdates != null) {
                this.allowedUpdates.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="ip_address")
        public B ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return (B)this.self();
        }

        @JsonProperty(value="drop_pending_updates")
        public B dropPendingUpdates(Boolean dropPendingUpdates) {
            this.dropPendingUpdates = dropPendingUpdates;
            return (B)this.self();
        }

        @JsonProperty(value="secret_token")
        public B secretToken(String secretToken) {
            this.secretToken = secretToken;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "SetWebhook.SetWebhookBuilder(super=" + super.toString() + ", url=" + this.url + ", certificate=" + this.certificate + ", maxConnections=" + this.maxConnections + ", allowedUpdates=" + this.allowedUpdates + ", ipAddress=" + this.ipAddress + ", dropPendingUpdates=" + this.dropPendingUpdates + ", secretToken=" + this.secretToken + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class SetWebhookBuilderImpl
    extends SetWebhookBuilder<SetWebhook, SetWebhookBuilderImpl> {
        private SetWebhookBuilderImpl() {
        }

        @Override
        protected SetWebhookBuilderImpl self() {
            return this;
        }

        @Override
        public SetWebhook build() {
            return new SetWebhook(this);
        }
    }
}

