/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.LoginUrl;
import org.telegram.telegrambots.meta.api.objects.games.CallbackGame;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class InlineKeyboardButton
implements Validable,
BotApiObject {
    private static final String TEXT_FIELD = "text";
    private static final String URL_FIELD = "url";
    private static final String CALLBACK_DATA_FIELD = "callback_data";
    private static final String CALLBACK_GAME_FIELD = "callback_game";
    private static final String SWITCH_INLINE_QUERY_FIELD = "switch_inline_query";
    private static final String SWITCH_INLINE_QUERY_CURRENT_CHAT_FIELD = "switch_inline_query_current_chat";
    private static final String PAY_FIELD = "pay";
    private static final String LOGIN_URL_FIELD = "login_url";
    @JsonProperty(value="text")
    @NonNull
    private String text;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="callback_data")
    private String callbackData;
    @JsonProperty(value="callback_game")
    private CallbackGame callbackGame;
    @JsonProperty(value="switch_inline_query")
    private String switchInlineQuery;
    @JsonProperty(value="switch_inline_query_current_chat")
    private String switchInlineQueryCurrentChat;
    @JsonProperty(value="pay")
    private Boolean pay;
    @JsonProperty(value="login_url")
    private LoginUrl loginUrl;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.text == null || this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
        if (this.loginUrl != null) {
            this.loginUrl.validate();
        }
    }

    public static InlineKeyboardButtonBuilder builder() {
        return new InlineKeyboardButtonBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineKeyboardButton)) {
            return false;
        }
        InlineKeyboardButton other = (InlineKeyboardButton)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$pay = this.getPay();
        Boolean other$pay = other.getPay();
        if (this$pay == null ? other$pay != null : !((Object)this$pay).equals(other$pay)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$callbackData = this.getCallbackData();
        String other$callbackData = other.getCallbackData();
        if (this$callbackData == null ? other$callbackData != null : !this$callbackData.equals(other$callbackData)) {
            return false;
        }
        CallbackGame this$callbackGame = this.getCallbackGame();
        CallbackGame other$callbackGame = other.getCallbackGame();
        if (this$callbackGame == null ? other$callbackGame != null : !((Object)this$callbackGame).equals(other$callbackGame)) {
            return false;
        }
        String this$switchInlineQuery = this.getSwitchInlineQuery();
        String other$switchInlineQuery = other.getSwitchInlineQuery();
        if (this$switchInlineQuery == null ? other$switchInlineQuery != null : !this$switchInlineQuery.equals(other$switchInlineQuery)) {
            return false;
        }
        String this$switchInlineQueryCurrentChat = this.getSwitchInlineQueryCurrentChat();
        String other$switchInlineQueryCurrentChat = other.getSwitchInlineQueryCurrentChat();
        if (this$switchInlineQueryCurrentChat == null ? other$switchInlineQueryCurrentChat != null : !this$switchInlineQueryCurrentChat.equals(other$switchInlineQueryCurrentChat)) {
            return false;
        }
        LoginUrl this$loginUrl = this.getLoginUrl();
        LoginUrl other$loginUrl = other.getLoginUrl();
        return !(this$loginUrl == null ? other$loginUrl != null : !((Object)this$loginUrl).equals(other$loginUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineKeyboardButton;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $pay = this.getPay();
        result = result * 59 + ($pay == null ? 43 : ((Object)$pay).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $callbackData = this.getCallbackData();
        result = result * 59 + ($callbackData == null ? 43 : $callbackData.hashCode());
        CallbackGame $callbackGame = this.getCallbackGame();
        result = result * 59 + ($callbackGame == null ? 43 : ((Object)$callbackGame).hashCode());
        String $switchInlineQuery = this.getSwitchInlineQuery();
        result = result * 59 + ($switchInlineQuery == null ? 43 : $switchInlineQuery.hashCode());
        String $switchInlineQueryCurrentChat = this.getSwitchInlineQueryCurrentChat();
        result = result * 59 + ($switchInlineQueryCurrentChat == null ? 43 : $switchInlineQueryCurrentChat.hashCode());
        LoginUrl $loginUrl = this.getLoginUrl();
        result = result * 59 + ($loginUrl == null ? 43 : ((Object)$loginUrl).hashCode());
        return result;
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCallbackData() {
        return this.callbackData;
    }

    public CallbackGame getCallbackGame() {
        return this.callbackGame;
    }

    public String getSwitchInlineQuery() {
        return this.switchInlineQuery;
    }

    public String getSwitchInlineQueryCurrentChat() {
        return this.switchInlineQueryCurrentChat;
    }

    public Boolean getPay() {
        return this.pay;
    }

    public LoginUrl getLoginUrl() {
        return this.loginUrl;
    }

    @JsonProperty(value="text")
    public void setText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="callback_data")
    public void setCallbackData(String callbackData) {
        this.callbackData = callbackData;
    }

    @JsonProperty(value="callback_game")
    public void setCallbackGame(CallbackGame callbackGame) {
        this.callbackGame = callbackGame;
    }

    @JsonProperty(value="switch_inline_query")
    public void setSwitchInlineQuery(String switchInlineQuery) {
        this.switchInlineQuery = switchInlineQuery;
    }

    @JsonProperty(value="switch_inline_query_current_chat")
    public void setSwitchInlineQueryCurrentChat(String switchInlineQueryCurrentChat) {
        this.switchInlineQueryCurrentChat = switchInlineQueryCurrentChat;
    }

    @JsonProperty(value="pay")
    public void setPay(Boolean pay) {
        this.pay = pay;
    }

    @JsonProperty(value="login_url")
    public void setLoginUrl(LoginUrl loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String toString() {
        return "InlineKeyboardButton(text=" + this.getText() + ", url=" + this.getUrl() + ", callbackData=" + this.getCallbackData() + ", callbackGame=" + this.getCallbackGame() + ", switchInlineQuery=" + this.getSwitchInlineQuery() + ", switchInlineQueryCurrentChat=" + this.getSwitchInlineQueryCurrentChat() + ", pay=" + this.getPay() + ", loginUrl=" + this.getLoginUrl() + ")";
    }

    public InlineKeyboardButton() {
    }

    public InlineKeyboardButton(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    public InlineKeyboardButton(@NonNull String text, String url, String callbackData, CallbackGame callbackGame, String switchInlineQuery, String switchInlineQueryCurrentChat, Boolean pay, LoginUrl loginUrl) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
        this.url = url;
        this.callbackData = callbackData;
        this.callbackGame = callbackGame;
        this.switchInlineQuery = switchInlineQuery;
        this.switchInlineQueryCurrentChat = switchInlineQueryCurrentChat;
        this.pay = pay;
        this.loginUrl = loginUrl;
    }

    public static class InlineKeyboardButtonBuilder {
        private String text;
        private String url;
        private String callbackData;
        private CallbackGame callbackGame;
        private String switchInlineQuery;
        private String switchInlineQueryCurrentChat;
        private Boolean pay;
        private LoginUrl loginUrl;

        InlineKeyboardButtonBuilder() {
        }

        @JsonProperty(value="text")
        public InlineKeyboardButtonBuilder text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return this;
        }

        @JsonProperty(value="url")
        public InlineKeyboardButtonBuilder url(String url) {
            this.url = url;
            return this;
        }

        @JsonProperty(value="callback_data")
        public InlineKeyboardButtonBuilder callbackData(String callbackData) {
            this.callbackData = callbackData;
            return this;
        }

        @JsonProperty(value="callback_game")
        public InlineKeyboardButtonBuilder callbackGame(CallbackGame callbackGame) {
            this.callbackGame = callbackGame;
            return this;
        }

        @JsonProperty(value="switch_inline_query")
        public InlineKeyboardButtonBuilder switchInlineQuery(String switchInlineQuery) {
            this.switchInlineQuery = switchInlineQuery;
            return this;
        }

        @JsonProperty(value="switch_inline_query_current_chat")
        public InlineKeyboardButtonBuilder switchInlineQueryCurrentChat(String switchInlineQueryCurrentChat) {
            this.switchInlineQueryCurrentChat = switchInlineQueryCurrentChat;
            return this;
        }

        @JsonProperty(value="pay")
        public InlineKeyboardButtonBuilder pay(Boolean pay) {
            this.pay = pay;
            return this;
        }

        @JsonProperty(value="login_url")
        public InlineKeyboardButtonBuilder loginUrl(LoginUrl loginUrl) {
            this.loginUrl = loginUrl;
            return this;
        }

        public InlineKeyboardButton build() {
            return new InlineKeyboardButton(this.text, this.url, this.callbackData, this.callbackGame, this.switchInlineQuery, this.switchInlineQueryCurrentChat, this.pay, this.loginUrl);
        }

        public String toString() {
            return "InlineKeyboardButton.InlineKeyboardButtonBuilder(text=" + this.text + ", url=" + this.url + ", callbackData=" + this.callbackData + ", callbackGame=" + this.callbackGame + ", switchInlineQuery=" + this.switchInlineQuery + ", switchInlineQueryCurrentChat=" + this.switchInlineQueryCurrentChat + ", pay=" + this.pay + ", loginUrl=" + this.loginUrl + ")";
        }
    }
}

