/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.media.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaAnimation;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaAudio;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaDocument;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaVideo;

public class InputMediaSerializer
extends JsonSerializer<InputMedia> {
    public void serialize(InputMedia value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("media", value.getMedia());
        gen.writeStringField("type", value.getType());
        if (value.getCaption() != null) {
            gen.writeStringField("caption", value.getCaption());
        }
        if (value.getParseMode() != null) {
            gen.writeStringField("parse_mode", value.getParseMode());
        }
        if (value.getEntities() != null) {
            gen.writeArrayFieldStart("entities");
            for (MessageEntity entity : value.getEntities()) {
                gen.writeObject((Object)entity);
            }
            gen.writeEndArray();
        }
        if (value instanceof InputMediaAudio) {
            InputMediaAudio audio = (InputMediaAudio)value;
            if (audio.getThumb() != null) {
                gen.writeStringField("thumb", audio.getThumb().getAttachName());
            }
            if (audio.getDuration() != null) {
                gen.writeNumberField("duration", audio.getDuration().intValue());
            }
            if (audio.getPerformer() != null) {
                gen.writeStringField("performer", audio.getPerformer());
            }
            if (audio.getTitle() != null) {
                gen.writeStringField("title", audio.getTitle());
            }
        } else if (value instanceof InputMediaAnimation) {
            InputMediaAnimation animation = (InputMediaAnimation)value;
            if (animation.getThumb() != null) {
                gen.writeStringField("thumb", animation.getThumb().getAttachName());
            }
            if (animation.getDuration() != null) {
                gen.writeNumberField("duration", animation.getDuration().intValue());
            }
            if (animation.getHeight() != null) {
                gen.writeNumberField("height", animation.getHeight().intValue());
            }
            if (animation.getWidth() != null) {
                gen.writeNumberField("width", animation.getWidth().intValue());
            }
        } else if (value instanceof InputMediaDocument) {
            InputMediaDocument document = (InputMediaDocument)value;
            if (document.getThumb() != null) {
                gen.writeStringField("thumb", document.getThumb().getAttachName());
            }
        } else if (value instanceof InputMediaVideo) {
            InputMediaVideo video = (InputMediaVideo)value;
            if (video.getThumb() != null) {
                gen.writeStringField("thumb", video.getThumb().getAttachName());
            }
            if (video.getDuration() != null) {
                gen.writeNumberField("duration", video.getDuration().intValue());
            }
            if (video.getHeight() != null) {
                gen.writeNumberField("height", video.getHeight().intValue());
            }
            if (video.getWidth() != null) {
                gen.writeNumberField("width", video.getWidth().intValue());
            }
            if (video.getSupportsStreaming() != null) {
                gen.writeBooleanField("supports_streaming", video.getSupportsStreaming().booleanValue());
            }
        }
        gen.writeEndObject();
    }

    public void serializeWithType(InputMedia value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(value, gen, serializers);
    }
}

