/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InlineQueryResultCachedAudio
implements InlineQueryResult {
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String AUDIO_FILE_ID_FIELD = "audio_file_id";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String CAPTION_FIELD = "caption";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    @JsonProperty(value="type")
    private final String type = "audio";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="audio_file_id")
    @NonNull
    private String audioFileId;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id == null || this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.audioFileId == null || this.audioFileId.isEmpty()) {
            throw new TelegramApiValidationException("AudioFileId parameter can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public static InlineQueryResultCachedAudioBuilder builder() {
        return new InlineQueryResultCachedAudioBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultCachedAudio)) {
            return false;
        }
        InlineQueryResultCachedAudio other = (InlineQueryResultCachedAudio)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$audioFileId = this.getAudioFileId();
        String other$audioFileId = other.getAudioFileId();
        if (this$audioFileId == null ? other$audioFileId != null : !this$audioFileId.equals(other$audioFileId)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        return !(this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultCachedAudio;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $audioFileId = this.getAudioFileId();
        result = result * 59 + ($audioFileId == null ? 43 : $audioFileId.hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getAudioFileId() {
        return this.audioFileId;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="audio_file_id")
    public void setAudioFileId(@NonNull String audioFileId) {
        if (audioFileId == null) {
            throw new NullPointerException("audioFileId is marked non-null but is null");
        }
        this.audioFileId = audioFileId;
    }

    @JsonProperty(value="input_message_content")
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="caption")
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public String toString() {
        return "InlineQueryResultCachedAudio(type=" + this.getType() + ", id=" + this.getId() + ", audioFileId=" + this.getAudioFileId() + ", inputMessageContent=" + this.getInputMessageContent() + ", replyMarkup=" + this.getReplyMarkup() + ", caption=" + this.getCaption() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ")";
    }

    public InlineQueryResultCachedAudio(@NonNull String id, @NonNull String audioFileId) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (audioFileId == null) {
            throw new NullPointerException("audioFileId is marked non-null but is null");
        }
        this.id = id;
        this.audioFileId = audioFileId;
    }

    public InlineQueryResultCachedAudio() {
    }

    public InlineQueryResultCachedAudio(@NonNull String id, @NonNull String audioFileId, InputMessageContent inputMessageContent, InlineKeyboardMarkup replyMarkup, String caption, String parseMode, List<MessageEntity> captionEntities) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (audioFileId == null) {
            throw new NullPointerException("audioFileId is marked non-null but is null");
        }
        this.id = id;
        this.audioFileId = audioFileId;
        this.inputMessageContent = inputMessageContent;
        this.replyMarkup = replyMarkup;
        this.caption = caption;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
    }

    public static class InlineQueryResultCachedAudioBuilder {
        private String id;
        private String audioFileId;
        private InputMessageContent inputMessageContent;
        private InlineKeyboardMarkup replyMarkup;
        private String caption;
        private String parseMode;
        private ArrayList<MessageEntity> captionEntities;

        InlineQueryResultCachedAudioBuilder() {
        }

        @JsonProperty(value="id")
        public InlineQueryResultCachedAudioBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @JsonProperty(value="audio_file_id")
        public InlineQueryResultCachedAudioBuilder audioFileId(@NonNull String audioFileId) {
            if (audioFileId == null) {
                throw new NullPointerException("audioFileId is marked non-null but is null");
            }
            this.audioFileId = audioFileId;
            return this;
        }

        @JsonProperty(value="input_message_content")
        public InlineQueryResultCachedAudioBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this;
        }

        @JsonProperty(value="reply_markup")
        public InlineQueryResultCachedAudioBuilder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        @JsonProperty(value="caption")
        public InlineQueryResultCachedAudioBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @JsonProperty(value="parse_mode")
        public InlineQueryResultCachedAudioBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public InlineQueryResultCachedAudioBuilder captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this;
        }

        @JsonProperty(value="caption_entities")
        public InlineQueryResultCachedAudioBuilder captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this;
        }

        public InlineQueryResultCachedAudioBuilder clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this;
        }

        public InlineQueryResultCachedAudio build() {
            List<MessageEntity> captionEntities;
            switch (this.captionEntities == null ? 0 : this.captionEntities.size()) {
                case 0: {
                    captionEntities = Collections.emptyList();
                    break;
                }
                case 1: {
                    captionEntities = Collections.singletonList(this.captionEntities.get(0));
                    break;
                }
                default: {
                    captionEntities = Collections.unmodifiableList(new ArrayList<MessageEntity>(this.captionEntities));
                }
            }
            return new InlineQueryResultCachedAudio(this.id, this.audioFileId, this.inputMessageContent, this.replyMarkup, this.caption, this.parseMode, captionEntities);
        }

        public String toString() {
            return "InlineQueryResultCachedAudio.InlineQueryResultCachedAudioBuilder(id=" + this.id + ", audioFileId=" + this.audioFileId + ", inputMessageContent=" + this.inputMessageContent + ", replyMarkup=" + this.replyMarkup + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ")";
        }
    }
}

