/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.UserProfilePhotos;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class GetUserProfilePhotos
extends BotApiMethod<UserProfilePhotos> {
    public static final String PATH = "getuserprofilephotos";
    private static final String USERID_FIELD = "user_id";
    private static final String OFFSET_FIELD = "offset";
    private static final String LIMIT_FIELD = "limit";
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;
    @JsonProperty(value="offset")
    private Integer offset;
    @JsonProperty(value="limit")
    private Integer limit;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public UserProfilePhotos deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<UserProfilePhotos>>(){});
            if (result.getOk().booleanValue()) {
                return (UserProfilePhotos)result.getResult();
            }
            throw new TelegramApiRequestException("Error getting user profile photos", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId == null) {
            throw new TelegramApiValidationException("UserId parameter can't be empty", this);
        }
    }

    public static GetUserProfilePhotosBuilder builder() {
        return new GetUserProfilePhotosBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetUserProfilePhotos)) {
            return false;
        }
        GetUserProfilePhotos other = (GetUserProfilePhotos)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        return !(this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetUserProfilePhotos;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        return result;
    }

    @NonNull
    public Long getUserId() {
        return this.userId;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="offset")
    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    @JsonProperty(value="limit")
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public String toString() {
        return "GetUserProfilePhotos(userId=" + this.getUserId() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ")";
    }

    public GetUserProfilePhotos() {
    }

    public GetUserProfilePhotos(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    public GetUserProfilePhotos(@NonNull Long userId, Integer offset, Integer limit) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
        this.offset = offset;
        this.limit = limit;
    }

    public static class GetUserProfilePhotosBuilder {
        private Long userId;
        private Integer offset;
        private Integer limit;

        GetUserProfilePhotosBuilder() {
        }

        @JsonProperty(value="user_id")
        public GetUserProfilePhotosBuilder userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="offset")
        public GetUserProfilePhotosBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        @JsonProperty(value="limit")
        public GetUserProfilePhotosBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetUserProfilePhotos build() {
            return new GetUserProfilePhotos(this.userId, this.offset, this.limit);
        }

        public String toString() {
            return "GetUserProfilePhotos.GetUserProfilePhotosBuilder(userId=" + this.userId + ", offset=" + this.offset + ", limit=" + this.limit + ")";
        }
    }
}

