/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.File;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class GetFile
extends BotApiMethod<File> {
    public static final String PATH = "getFile";
    private static final String FILEID_FIELD = "file_id";
    @JsonProperty(value="file_id")
    @NonNull
    private String fileId;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.fileId == null) {
            throw new TelegramApiValidationException("FileId can't be empty", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public File deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<File>>(){});
            if (result.getOk().booleanValue()) {
                return (File)result.getResult();
            }
            throw new TelegramApiRequestException("Error getting file", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    public static GetFileBuilder builder() {
        return new GetFileBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetFile)) {
            return false;
        }
        GetFile other = (GetFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fileId = this.getFileId();
        String other$fileId = other.getFileId();
        return !(this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fileId = this.getFileId();
        result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
        return result;
    }

    @NonNull
    public String getFileId() {
        return this.fileId;
    }

    @JsonProperty(value="file_id")
    public void setFileId(@NonNull String fileId) {
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        this.fileId = fileId;
    }

    public String toString() {
        return "GetFile(fileId=" + this.getFileId() + ")";
    }

    public GetFile() {
    }

    public GetFile(@NonNull String fileId) {
        if (fileId == null) {
            throw new NullPointerException("fileId is marked non-null but is null");
        }
        this.fileId = fileId;
    }

    public static class GetFileBuilder {
        private String fileId;

        GetFileBuilder() {
        }

        @JsonProperty(value="file_id")
        public GetFileBuilder fileId(@NonNull String fileId) {
            if (fileId == null) {
                throw new NullPointerException("fileId is marked non-null but is null");
            }
            this.fileId = fileId;
            return this;
        }

        public GetFile build() {
            return new GetFile(this.fileId);
        }

        public String toString() {
            return "GetFile.GetFileBuilder(fileId=" + this.fileId + ")";
        }
    }
}

