/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class AnswerPreCheckoutQuery
extends BotApiMethod<Boolean> {
    public static final String PATH = "answerPreCheckoutQuery";
    private static final String PRE_CHECKOUT_QUERY_ID_FIELD = "pre_checkout_query_id";
    private static final String OK_FIELD = "ok";
    private static final String ERROR_MESSAGE_FIELD = "error_message";
    @JsonProperty(value="pre_checkout_query_id")
    @NonNull
    private String preCheckoutQueryId;
    @JsonProperty(value="ok")
    @NonNull
    private Boolean ok;
    @JsonProperty(value="error_message")
    private String errorMessage;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.preCheckoutQueryId == null || this.preCheckoutQueryId.isEmpty()) {
            throw new TelegramApiValidationException("PreCheckoutQueryId can't be empty", this);
        }
        if (this.ok == null) {
            throw new TelegramApiValidationException("Ok can't be null", this);
        }
        if (!this.ok.booleanValue() && (this.errorMessage == null || this.errorMessage.isEmpty())) {
            throw new TelegramApiValidationException("ErrorMessage can't be empty if not ok", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error answering pre-checkout query", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    public static AnswerPreCheckoutQueryBuilder builder() {
        return new AnswerPreCheckoutQueryBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerPreCheckoutQuery)) {
            return false;
        }
        AnswerPreCheckoutQuery other = (AnswerPreCheckoutQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$ok = this.getOk();
        Boolean other$ok = other.getOk();
        if (this$ok == null ? other$ok != null : !((Object)this$ok).equals(other$ok)) {
            return false;
        }
        String this$preCheckoutQueryId = this.getPreCheckoutQueryId();
        String other$preCheckoutQueryId = other.getPreCheckoutQueryId();
        if (this$preCheckoutQueryId == null ? other$preCheckoutQueryId != null : !this$preCheckoutQueryId.equals(other$preCheckoutQueryId)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnswerPreCheckoutQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ok = this.getOk();
        result = result * 59 + ($ok == null ? 43 : ((Object)$ok).hashCode());
        String $preCheckoutQueryId = this.getPreCheckoutQueryId();
        result = result * 59 + ($preCheckoutQueryId == null ? 43 : $preCheckoutQueryId.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    @NonNull
    public String getPreCheckoutQueryId() {
        return this.preCheckoutQueryId;
    }

    @NonNull
    public Boolean getOk() {
        return this.ok;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="pre_checkout_query_id")
    public void setPreCheckoutQueryId(@NonNull String preCheckoutQueryId) {
        if (preCheckoutQueryId == null) {
            throw new NullPointerException("preCheckoutQueryId is marked non-null but is null");
        }
        this.preCheckoutQueryId = preCheckoutQueryId;
    }

    @JsonProperty(value="ok")
    public void setOk(@NonNull Boolean ok) {
        if (ok == null) {
            throw new NullPointerException("ok is marked non-null but is null");
        }
        this.ok = ok;
    }

    @JsonProperty(value="error_message")
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String toString() {
        return "AnswerPreCheckoutQuery(preCheckoutQueryId=" + this.getPreCheckoutQueryId() + ", ok=" + this.getOk() + ", errorMessage=" + this.getErrorMessage() + ")";
    }

    public AnswerPreCheckoutQuery() {
    }

    public AnswerPreCheckoutQuery(@NonNull String preCheckoutQueryId, @NonNull Boolean ok) {
        if (preCheckoutQueryId == null) {
            throw new NullPointerException("preCheckoutQueryId is marked non-null but is null");
        }
        if (ok == null) {
            throw new NullPointerException("ok is marked non-null but is null");
        }
        this.preCheckoutQueryId = preCheckoutQueryId;
        this.ok = ok;
    }

    public AnswerPreCheckoutQuery(@NonNull String preCheckoutQueryId, @NonNull Boolean ok, String errorMessage) {
        if (preCheckoutQueryId == null) {
            throw new NullPointerException("preCheckoutQueryId is marked non-null but is null");
        }
        if (ok == null) {
            throw new NullPointerException("ok is marked non-null but is null");
        }
        this.preCheckoutQueryId = preCheckoutQueryId;
        this.ok = ok;
        this.errorMessage = errorMessage;
    }

    public static class AnswerPreCheckoutQueryBuilder {
        private String preCheckoutQueryId;
        private Boolean ok;
        private String errorMessage;

        AnswerPreCheckoutQueryBuilder() {
        }

        @JsonProperty(value="pre_checkout_query_id")
        public AnswerPreCheckoutQueryBuilder preCheckoutQueryId(@NonNull String preCheckoutQueryId) {
            if (preCheckoutQueryId == null) {
                throw new NullPointerException("preCheckoutQueryId is marked non-null but is null");
            }
            this.preCheckoutQueryId = preCheckoutQueryId;
            return this;
        }

        @JsonProperty(value="ok")
        public AnswerPreCheckoutQueryBuilder ok(@NonNull Boolean ok) {
            if (ok == null) {
                throw new NullPointerException("ok is marked non-null but is null");
            }
            this.ok = ok;
            return this;
        }

        @JsonProperty(value="error_message")
        public AnswerPreCheckoutQueryBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public AnswerPreCheckoutQuery build() {
            return new AnswerPreCheckoutQuery(this.preCheckoutQueryId, this.ok, this.errorMessage);
        }

        public String toString() {
            return "AnswerPreCheckoutQuery.AnswerPreCheckoutQueryBuilder(preCheckoutQueryId=" + this.preCheckoutQueryId + ", ok=" + this.ok + ", errorMessage=" + this.errorMessage + ")";
        }
    }
}

