/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.kernel.engine.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.bot.kernel.engine.storage.TLLastKnownSalt;
import org.telegram.bot.kernel.engine.storage.TLOldSession;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLObject;
import org.telegram.tl.TLVector;

public class TLKey
extends TLObject {
    public static final int CLASS_ID = 1250302746;
    private int dcId;
    private byte[] authKey;
    private boolean isAuthorised;
    private TLVector salts;
    private TLVector oldSessions;

    public TLKey(int dcId, byte[] authKey) {
        this.dcId = dcId;
        this.authKey = authKey;
        this.isAuthorised = false;
        this.salts = new TLVector();
        this.oldSessions = new TLVector();
    }

    public TLKey() {
    }

    public int getDcId() {
        return this.dcId;
    }

    public byte[] getAuthKey() {
        return this.authKey;
    }

    public boolean isAuthorised() {
        return this.isAuthorised;
    }

    public void setAuthorised(boolean authorised) {
        this.isAuthorised = authorised;
    }

    public TLVector<TLLastKnownSalt> getSalts() {
        return this.salts;
    }

    public TLVector<TLOldSession> getOldSessions() {
        return this.oldSessions;
    }

    @Override
    public int getClassId() {
        return 1250302746;
    }

    @Override
    public String toString() {
        return "key#4a861b1a";
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.dcId, stream);
        StreamingUtils.writeByteArray(this.authKey, stream);
        StreamingUtils.writeTLBool(this.isAuthorised, stream);
        StreamingUtils.writeTLVector(this.salts, stream);
        StreamingUtils.writeTLVector(this.oldSessions, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.dcId = StreamingUtils.readInt(stream);
        this.authKey = StreamingUtils.readBytes(256, stream);
        this.isAuthorised = StreamingUtils.readTLBool(stream);
        this.salts = StreamingUtils.readTLVector(stream, context);
        this.oldSessions = StreamingUtils.readTLVector(stream, context);
    }
}

