/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.kernel.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.telegram.bot.kernel.engine.SafeFileWriter;
import org.telegram.bot.kernel.engine.storage.TLDcInfo;
import org.telegram.bot.kernel.engine.storage.TLKey;
import org.telegram.bot.kernel.engine.storage.TLLastKnownSalt;
import org.telegram.bot.kernel.engine.storage.TLOldSession;
import org.telegram.bot.kernel.engine.storage.TLStorage;
import org.telegram.bot.services.BotLogger;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLObject;

public class TLPersistence<T extends TLObject>
extends TLContext {
    private static final String LOGTAG = "KernelPersistence";
    private Class<T> destClass;
    private T obj;
    private SafeFileWriter writer;

    TLPersistence() {
    }

    TLPersistence(String fileName, Class<T> destClass) {
        long start = System.currentTimeMillis();
        this.writer = new SafeFileWriter(fileName);
        byte[] data = this.writer.loadData();
        BotLogger.warning(LOGTAG, "Loaded state in " + (System.currentTimeMillis() - start) + " ms");
        if (data != null) {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(data);
                this.obj = this.deserializeMessage(stream);
            }
            catch (IOException e) {
                BotLogger.warning(LOGTAG, e);
            }
        }
        if (this.obj == null) {
            try {
                this.obj = (TLObject)destClass.newInstance();
            }
            catch (Exception e1) {
                throw new RuntimeException("Unable to instantiate default settings");
            }
        }
        this.afterLoaded();
    }

    @Override
    public void init() {
        this.registerClass(98092748, TLDcInfo.class);
        this.registerClass(1250302746, TLKey.class);
        this.registerClass(252005472, TLLastKnownSalt.class);
        this.registerClass(-1953022063, TLOldSession.class);
        this.registerClass(1056556212, TLStorage.class);
    }

    void afterLoaded() {
    }

    void write() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ((TLObject)this.obj).serialize(stream);
            stream.close();
            this.writer.saveData(stream.toByteArray());
        }
        catch (IOException e) {
            BotLogger.warning(LOGTAG, e);
        }
    }

    public T getObj() {
        return this.obj;
    }
}

