/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.kernel;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.telegram.api.TLConfig;
import org.telegram.api.auth.TLAuthorization;
import org.telegram.api.auth.TLSentCode;
import org.telegram.api.engine.RpcException;
import org.telegram.api.engine.storage.AbsApiState;
import org.telegram.api.functions.auth.TLRequestAuthImportBotAuthorization;
import org.telegram.api.functions.auth.TLRequestAuthLogOut;
import org.telegram.api.functions.auth.TLRequestAuthSendCode;
import org.telegram.api.functions.auth.TLRequestAuthSignIn;
import org.telegram.api.functions.auth.TLRequestAuthSignUp;
import org.telegram.api.functions.help.TLRequestHelpGetConfig;
import org.telegram.api.functions.updates.TLRequestUpdatesGetState;
import org.telegram.bot.kernel.IKernelComm;
import org.telegram.bot.kernel.engine.MemoryApiState;
import org.telegram.bot.kernel.engine.storage.TLStorage;
import org.telegram.bot.services.BotLogger;
import org.telegram.bot.structure.BotConfig;
import org.telegram.bot.structure.LoginStatus;

public class KernelAuth {
    private static final String LOGTAG = "KERNELAUTH";
    private static final int TIMEUNTILCALLINGUSER = 60000;
    private static final int ERROR303 = 303;
    private final AbsApiState apiState;
    private final IKernelComm kernelComm;
    private final BotConfig config;
    private final int apiKey;
    private final String apiHash;
    private Timer loginTimer = new Timer();

    public KernelAuth(AbsApiState apiState, BotConfig config, IKernelComm kernelComm, int apiKey, String apiHash) {
        this.kernelComm = kernelComm;
        this.apiState = apiState;
        this.config = config;
        this.apiKey = apiKey;
        this.apiHash = apiHash;
    }

    public boolean init() {
        return true;
    }

    public LoginStatus start() {
        return this.config.isBot() ? this.loginBot() : this.login();
    }

    public boolean logOut() {
        boolean result;
        try {
            if (this.getApiState().isAuthenticated()) {
                this.kernelComm.doRpcCallSync(new TLRequestAuthLogOut());
                this.getApiState().resetAuth();
                this.config.setRegistered(false);
            } else {
                this.config.setRegistered(false);
            }
            result = true;
        }
        catch (ExecutionException | RpcException e) {
            BotLogger.error(LOGTAG, e);
            result = false;
        }
        return result;
    }

    public MemoryApiState getApiState() {
        return (MemoryApiState)this.apiState;
    }

    public int getCurrentUserId() {
        return this.apiState.getUserId();
    }

    public boolean setAuthCode(String code) {
        boolean result = false;
        try {
            if (this.config.getHashCode().compareTo("") == 0) {
                result = false;
            } else {
                TLAuthorization authorization;
                if (this.config.isRegistered()) {
                    TLRequestAuthSignIn tlRequestAuthSignIn = this.getSignInRequest(code);
                    authorization = this.kernelComm.getApi().doRpcCallNonAuth(tlRequestAuthSignIn);
                } else {
                    TLRequestAuthSignUp tlRequestAuthSignUp = this.getSignUpRequest(code);
                    authorization = this.kernelComm.getApi().doRpcCallNonAuth(tlRequestAuthSignUp);
                }
                if (authorization != null) {
                    this.config.setRegistered(true);
                    this.getApiState().doAuth(authorization);
                    BotLogger.info(LOGTAG, "Activation complete as #" + ((TLStorage)this.getApiState().getObj()).getUid());
                    this.kernelComm.getApi().doRpcCall(new TLRequestUpdatesGetState());
                    BotLogger.info(LOGTAG, "Loaded initial state");
                    this.resetTimer();
                    result = true;
                }
            }
        }
        catch (IOException | TimeoutException e) {
            BotLogger.error(LOGTAG, e);
            result = false;
        }
        return result;
    }

    private LoginStatus login() {
        LoginStatus result;
        block11: {
            try {
                if (this.getApiState().isAuthenticated()) {
                    BotLogger.info(LOGTAG, "Found Auth file");
                    this.config.setRegistered(true);
                    result = LoginStatus.ALREADYLOGGED;
                    break block11;
                }
                try {
                    TLConfig config = this.kernelComm.getApi().doRpcCallNonAuth(new TLRequestHelpGetConfig());
                    BotLogger.info(LOGTAG, "Loaded DC list");
                    this.getApiState().updateSettings(config);
                }
                catch (IOException | TimeoutException e) {
                    BotLogger.error(LOGTAG, e);
                }
                BotLogger.info(LOGTAG, "Sending code to phone " + this.config.getPhoneNumber() + "...");
                TLSentCode sentCode = null;
                try {
                    TLRequestAuthSendCode tlRequestAuthSendCode = this.getSendCodeRequest();
                    sentCode = this.kernelComm.getApi().doRpcCallNonAuth(tlRequestAuthSendCode);
                    this.createNextCodeTimer(sentCode.getTimeout());
                }
                catch (RpcException e) {
                    int destDC;
                    if (e.getErrorCode() == 303 && (destDC = this.updateDCWhenLogin(e)) != -1) {
                        this.getApiState().setPrimaryDc(destDC);
                        this.kernelComm.getApi().switchToDc(destDC);
                        sentCode = this.retryLogin(destDC);
                    }
                }
                catch (TimeoutException e) {
                    BotLogger.error(LOGTAG, e);
                    sentCode = null;
                }
                if (sentCode != null) {
                    this.config.setHashCode(sentCode.getPhoneCodeHash());
                    this.config.setRegistered(sentCode.isPhoneRegistered());
                    BotLogger.info(LOGTAG, "sent Code");
                    result = LoginStatus.CODESENT;
                } else {
                    result = LoginStatus.ERRORSENDINGCODE;
                }
            }
            catch (IOException | TimeoutException ex) {
                BotLogger.error(LOGTAG, ex);
                result = LoginStatus.UNEXPECTEDERROR;
            }
        }
        return result;
    }

    private LoginStatus loginBot() {
        LoginStatus result;
        block10: {
            result = null;
            try {
                if (this.getApiState().isAuthenticated()) {
                    BotLogger.info(LOGTAG, "Found Auth file");
                    this.config.setRegistered(true);
                    result = LoginStatus.ALREADYLOGGED;
                    break block10;
                }
                try {
                    TLConfig config = this.kernelComm.getApi().doRpcCallNonAuth(new TLRequestHelpGetConfig());
                    BotLogger.info(LOGTAG, "Loaded DC list");
                    this.getApiState().updateSettings(config);
                }
                catch (IOException | TimeoutException e) {
                    BotLogger.error(LOGTAG, e);
                }
                BotLogger.info(LOGTAG, "Sending code to phone " + this.config.getPhoneNumber() + "...");
                try {
                    TLRequestAuthImportBotAuthorization botAuthorization = new TLRequestAuthImportBotAuthorization();
                    botAuthorization.setApiId(this.apiKey);
                    botAuthorization.setApiHash(this.apiHash);
                    botAuthorization.setBotAuthToken(this.config.getBotToken());
                    TLAuthorization authorization = this.kernelComm.getApi().doRpcCallNonAuth(botAuthorization);
                    if (authorization != null) {
                        this.config.setRegistered(true);
                        this.getApiState().doAuth(authorization);
                        BotLogger.info(LOGTAG, "Activation complete as #" + ((TLStorage)this.getApiState().getObj()).getUid());
                        this.kernelComm.getApi().doRpcCall(new TLRequestUpdatesGetState());
                        BotLogger.info(LOGTAG, "Loaded initial state");
                        result = LoginStatus.BOTLOGIN;
                    }
                }
                catch (RpcException e) {
                    BotLogger.severe(LOGTAG, e);
                }
                catch (TimeoutException e) {
                    BotLogger.error(LOGTAG, e);
                }
            }
            catch (IOException ex) {
                BotLogger.error(LOGTAG, ex);
                result = LoginStatus.UNEXPECTEDERROR;
            }
        }
        if (result == null) {
            result = LoginStatus.BOTLOGINERROR;
        }
        return result;
    }

    private void createNextCodeTimer(int timeout) {
        this.loginTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    TLRequestAuthSendCode tlRequestAuthSendCode = KernelAuth.this.getSendCodeRequest();
                    TLSentCode sentCode = KernelAuth.this.kernelComm.getApi().doRpcCallNonAuth(tlRequestAuthSendCode);
                    this.cancel();
                    KernelAuth.this.createNextCodeTimer(sentCode.getTimeout());
                }
                catch (Exception e) {
                    BotLogger.error(KernelAuth.LOGTAG, e);
                }
            }
        }, timeout == 0 ? 60000L : (long)timeout);
    }

    private TLRequestAuthSendCode getSendCodeRequest() {
        TLRequestAuthSendCode tlRequestAuthSendCode = new TLRequestAuthSendCode();
        tlRequestAuthSendCode.setPhoneNumber(this.config.getPhoneNumber());
        tlRequestAuthSendCode.setApiId(this.apiKey);
        tlRequestAuthSendCode.setApiHash(this.apiHash);
        return tlRequestAuthSendCode;
    }

    private int updateDCWhenLogin(RpcException e) {
        int destDC;
        if (e.getErrorTag().startsWith("NETWORK_MIGRATE_")) {
            destDC = Integer.parseInt(e.getErrorTag().substring("NETWORK_MIGRATE_".length()));
        } else if (e.getErrorTag().startsWith("PHONE_MIGRATE_")) {
            destDC = Integer.parseInt(e.getErrorTag().substring("PHONE_MIGRATE_".length()));
        } else if (e.getErrorTag().startsWith("USER_MIGRATE_")) {
            destDC = Integer.parseInt(e.getErrorTag().substring("USER_MIGRATE_".length()));
        } else {
            BotLogger.error(LOGTAG, e);
            destDC = -1;
        }
        return destDC;
    }

    private TLSentCode retryLogin(int destDC) throws IOException, TimeoutException {
        this.kernelComm.getApi().switchToDc(destDC);
        TLRequestAuthSendCode tlRequestAuthSendCode = this.getSendCodeRequest();
        TLSentCode sentCode = this.kernelComm.getApi().doRpcCallNonAuth(tlRequestAuthSendCode);
        this.resetTimer();
        this.createNextCodeTimer(sentCode.getTimeout());
        return sentCode;
    }

    private void resetTimer() {
        this.loginTimer.cancel();
        this.loginTimer = new Timer();
    }

    private TLRequestAuthSignUp getSignUpRequest(String code) {
        TLRequestAuthSignUp tlRequestAuthSignUp = new TLRequestAuthSignUp();
        tlRequestAuthSignUp.setPhoneNumber(this.config.getPhoneNumber());
        tlRequestAuthSignUp.setPhoneCodeHash(this.config.getHashCode());
        tlRequestAuthSignUp.setPhoneCode(code);
        tlRequestAuthSignUp.setFirstName("Rubenlagus");
        tlRequestAuthSignUp.setLastName("Bot");
        return tlRequestAuthSignUp;
    }

    private TLRequestAuthSignIn getSignInRequest(String code) {
        TLRequestAuthSignIn tlRequestAuthSignIn = new TLRequestAuthSignIn();
        tlRequestAuthSignIn.setPhoneNumber(this.config.getPhoneNumber());
        tlRequestAuthSignIn.setPhoneCodeHash(this.config.getHashCode());
        tlRequestAuthSignIn.setPhoneCode(code);
        return tlRequestAuthSignIn;
    }
}

