/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.factories;

import org.telegram.api.input.peer.TLAbsInputPeer;
import org.telegram.api.input.peer.TLInputPeerChannel;
import org.telegram.api.input.peer.TLInputPeerChat;
import org.telegram.api.input.peer.TLInputPeerSelf;
import org.telegram.api.input.peer.TLInputPeerUser;
import org.telegram.api.input.user.TLAbsInputUser;
import org.telegram.api.input.user.TLInputUser;
import org.telegram.api.input.user.TLInputUserSelf;
import org.telegram.bot.structure.Chat;
import org.telegram.bot.structure.IUser;

public class TLFactory {
    public static TLAbsInputUser createTLInputUser(IUser user) {
        TLAbsInputUser tlAbsInputUser;
        if (user == null) {
            tlAbsInputUser = new TLInputUserSelf();
        } else {
            TLInputUser tlInputUser = new TLInputUser();
            tlInputUser.setUserId(user.getUserId());
            tlInputUser.setAccessHash(user.getUserHash());
            tlAbsInputUser = tlInputUser;
        }
        return tlAbsInputUser;
    }

    public static TLAbsInputPeer createTLInputPeer(IUser user, Chat chat) {
        TLAbsInputPeer tlInputPeer;
        if (user == null) {
            if (chat == null) {
                tlInputPeer = new TLInputPeerSelf();
            } else if (chat.isChannel()) {
                TLInputPeerChannel inputPeerChannel = new TLInputPeerChannel();
                inputPeerChannel.setChannelId(chat.getId());
                inputPeerChannel.setAccessHash(chat.getAccessHash());
                tlInputPeer = inputPeerChannel;
            } else {
                TLInputPeerChat tlInputPeerChat = new TLInputPeerChat();
                tlInputPeerChat.setChatId(chat.getId());
                tlInputPeer = tlInputPeerChat;
            }
        } else {
            TLInputPeerUser tlInputPeerUser = new TLInputPeerUser();
            tlInputPeerUser.setUserId(user.getUserId());
            tlInputPeerUser.setAccessHash(user.getUserHash());
            tlInputPeer = tlInputPeerUser;
        }
        return tlInputPeer;
    }
}

