/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.paymentapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.api.paymentapi.TLLabeledPrice;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLObject;
import org.telegram.tl.TLVector;

public class TLInvoice
extends TLObject {
    public static final int CLASS_ID = -1022713000;
    private static final int FLAG_TEST = 1;
    private static final int FLAG_NAME_REQUESTED = 2;
    private static final int FLAG_PHONE_REQUESTED = 4;
    private static final int FLAG_EMAIL_REQUESTED = 8;
    private static final int FLAG_SHIPPING_ADDRESS_REQUESTED = 16;
    private static final int FLAG_FLEXIBLE = 32;
    private int flags;
    private String currency;
    private TLVector<TLLabeledPrice> prices;

    @Override
    public int getClassId() {
        return -1022713000;
    }

    public String getCurrency() {
        return this.currency;
    }

    public TLVector<TLLabeledPrice> getPrices() {
        return this.prices;
    }

    public boolean isTest() {
        return (this.flags & 1) != 0;
    }

    public boolean isNameRequested() {
        return (this.flags & 2) != 0;
    }

    public boolean isPhoneRequested() {
        return (this.flags & 4) != 0;
    }

    public boolean isEmailRequested() {
        return (this.flags & 8) != 0;
    }

    public boolean isShippingAddressRequeted() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isFlexible() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        StreamingUtils.writeTLString(this.currency, stream);
        StreamingUtils.writeTLVector(this.prices, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        this.currency = StreamingUtils.readTLString(stream);
        this.prices = StreamingUtils.readTLVector(stream, context, TLLabeledPrice.class);
    }

    @Override
    public String toString() {
        return "invoice#c30aa358";
    }
}

