/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.message.media;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.api.message.media.TLAbsMessageMedia;
import org.telegram.api.paymentapi.TLWebDocument;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;

public class TLMessageMediaInvoice
extends TLAbsMessageMedia {
    public static final int CLASS_ID = -2074799289;
    private static final int FLAG_PHOTO = 1;
    private static final int FLAG_SHIPPING_ADDRESS_REQUEST = 2;
    private static final int FLAG_RECEIPT_MSG_ID = 4;
    private static final int FLAG_TEST = 8;
    private int flags;
    private String title;
    private String description;
    private TLWebDocument photo;
    private int receiptMsgId;
    private String currency;
    private Long totalAmount;
    private String startParam;

    @Override
    public int getClassId() {
        return -2074799289;
    }

    public TLWebDocument getPhoto() {
        return this.photo;
    }

    public boolean hasPhoto() {
        return (this.flags & 1) != 0;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int getReceiptMsgId() {
        return this.receiptMsgId;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Long getTotalAmount() {
        return this.totalAmount;
    }

    public String getStartParam() {
        return this.startParam;
    }

    public boolean hasReceiptMsgId() {
        return (this.flags & 4) != 0;
    }

    public boolean isTest() {
        return (this.flags & 8) != 0;
    }

    public boolean hasShippingAddressRequested() {
        return (this.flags & 2) != 0;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        StreamingUtils.writeTLString(this.title, stream);
        StreamingUtils.writeTLString(this.description, stream);
        if ((this.flags & 1) != 0) {
            StreamingUtils.writeTLObject(this.photo, stream);
        }
        if ((this.flags & 4) != 0) {
            StreamingUtils.writeInt(this.receiptMsgId, stream);
        }
        StreamingUtils.writeTLString(this.currency, stream);
        StreamingUtils.writeLong(this.totalAmount, stream);
        StreamingUtils.writeTLString(this.startParam, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        this.title = StreamingUtils.readTLString(stream);
        this.description = StreamingUtils.readTLString(stream);
        if ((this.flags & 1) != 0) {
            this.photo = StreamingUtils.readTLObject(stream, context, TLWebDocument.class);
        }
        if ((this.flags & 4) != 0) {
            this.receiptMsgId = StreamingUtils.readInt(stream);
        }
        this.currency = StreamingUtils.readTLString(stream);
        this.totalAmount = StreamingUtils.readLong(stream);
        this.startParam = StreamingUtils.readTLString(stream);
    }

    @Override
    public String toString() {
        return "messageMediaInvoice#84551347";
    }
}

