/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.draft;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.api.draft.TLAbsDraftMessage;
import org.telegram.api.message.entity.TLAbsMessageEntity;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLVector;

public class TLDraftMessage
extends TLAbsDraftMessage {
    public static final int CLASS_ID = -40996577;
    private static final int FLAG_REPLY_TO_MSG_ID = 1;
    private static final int FLAG_NO_WEBPAGE = 2;
    private static final int FLAG_UNUSED_2 = 4;
    private static final int FLAG_ENTITIES = 8;
    private int flags;
    private int replyToMsgId;
    private String message;
    private TLVector<TLAbsMessageEntity> entities;
    private int date;

    @Override
    public int getClassId() {
        return -40996577;
    }

    public int getReplyToMsgId() {
        return this.replyToMsgId;
    }

    public String getMessage() {
        return this.message;
    }

    public TLVector<TLAbsMessageEntity> getEntities() {
        return this.entities;
    }

    public int getDate() {
        return this.date;
    }

    public boolean isReply() {
        return (this.flags & 1) != 0;
    }

    public boolean hasWebPreview() {
        return (this.flags & 2) == 0;
    }

    public boolean hasEntities() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        if ((this.flags & 1) != 0) {
            StreamingUtils.writeInt(this.replyToMsgId, stream);
        }
        StreamingUtils.writeTLString(this.message, stream);
        if ((this.flags & 8) != 0) {
            StreamingUtils.writeTLVector(this.entities, stream);
        }
        StreamingUtils.writeInt(this.date, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        if ((this.flags & 1) != 0) {
            this.replyToMsgId = StreamingUtils.readInt(stream);
        }
        this.message = StreamingUtils.readTLString(stream);
        if ((this.flags & 8) != 0) {
            this.entities = StreamingUtils.readTLVector(stream, context, TLAbsMessageEntity.class);
        }
        this.date = StreamingUtils.readInt(stream);
    }

    @Override
    public String toString() {
        return "draftMessage#fd8e711f";
    }
}

