/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.platform.Platform;

public class EnumDependencySupport
extends AbstractDependencyListener {
    private DependencyNode allEnums;

    @Override
    public void started(DependencyAgent agent) {
        this.allEnums = agent.createNode();
    }

    @Override
    public void classReached(DependencyAgent agent, String className) {
        ClassReader cls = agent.getClassSource().get(className);
        if (cls == null || cls.getParent() == null || !cls.getParent().equals("java.lang.Enum")) {
            return;
        }
        this.allEnums.propagate(agent.getType(className));
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        if (method.getReference().getClassName().equals(Platform.class.getName()) && method.getReference().getName().equals("getEnumConstants")) {
            this.allEnums.connect(method.getResult().getArrayItem());
            MethodReference ref = method.getReference();
            this.allEnums.addConsumer(type -> {
                ClassReader cls = agent.getClassSource().get(type.getName());
                MethodReader valuesMethod = cls.getMethod(new MethodDescriptor("values", ValueType.arrayOf(ValueType.object(cls.getName()))));
                if (valuesMethod != null) {
                    MethodDependency valuesDep = agent.linkMethod(valuesMethod.getReference());
                    valuesDep.addLocation(new CallLocation(ref));
                    valuesDep.use();
                }
            });
            method.getResult().propagate(agent.getType("[Ljava/lang/Enum;"));
            for (String cls : agent.getReachableClasses()) {
                this.classReached(agent, cls);
            }
        }
    }
}

