/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.metaprogramming.impl;

import java.util.HashMap;
import java.util.Map;
import org.teavm.cache.IncrementalDependencyRegistration;
import org.teavm.dependency.DependencyAgent;
import org.teavm.metaprogramming.Action;
import org.teavm.metaprogramming.Computation;
import org.teavm.metaprogramming.Diagnostics;
import org.teavm.metaprogramming.InvocationHandler;
import org.teavm.metaprogramming.LazyComputation;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.SourceLocation;
import org.teavm.metaprogramming.Value;
import org.teavm.metaprogramming.impl.CompositeMethodGenerator;
import org.teavm.metaprogramming.impl.Fragment;
import org.teavm.metaprogramming.impl.LazyValueImpl;
import org.teavm.metaprogramming.impl.ProxyVariableContext;
import org.teavm.metaprogramming.impl.ValueImpl;
import org.teavm.metaprogramming.impl.VariableContext;
import org.teavm.metaprogramming.impl.optimization.Optimizations;
import org.teavm.metaprogramming.impl.reflect.ReflectClassImpl;
import org.teavm.metaprogramming.impl.reflect.ReflectContext;
import org.teavm.metaprogramming.impl.reflect.ReflectFieldImpl;
import org.teavm.metaprogramming.impl.reflect.ReflectMethodImpl;
import org.teavm.metaprogramming.reflect.ReflectMethod;
import org.teavm.model.AccessLevel;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.util.TransitionExtractor;

public final class MetaprogrammingImpl {
    static String suffix;
    static Map<String, Integer> proxySuffixGenerators;
    static ClassLoader classLoader;
    static ClassReaderSource classSource;
    static ClassHierarchy hierarchy;
    static IncrementalDependencyRegistration incrementalDependencies;
    static ReflectContext reflectContext;
    static DependencyAgent agent;
    static VariableContext varContext;
    static MethodReference templateMethod;
    static CompositeMethodGenerator generator;
    static ValueType returnType;
    static boolean unsupportedCase;
    private static Diagnostics diagnostics;

    private MetaprogrammingImpl() {
    }

    public static <T> Value<T> emit(Computation<T> computation) {
        if (computation instanceof ValueImpl) {
            ValueImpl valueImpl = (ValueImpl)((Object)computation);
            Variable var = varContext.emitVariable(valueImpl, new CallLocation(templateMethod, MetaprogrammingImpl.generator.location));
            return new ValueImpl(var, varContext, valueImpl.type);
        }
        if (computation instanceof LazyValueImpl) {
            LazyValueImpl valueImpl = (LazyValueImpl)((Object)computation);
            Variable var = generator.lazy(valueImpl);
            return var != null ? new ValueImpl(var, varContext, valueImpl.type) : null;
        }
        Fragment fragment = (Fragment)((Object)computation);
        MethodReader method = hierarchy.resolve(fragment.method);
        generator.addProgram(method.getProgram(), fragment.capturedValues);
        return new ValueImpl(generator.getResultVar(), varContext, fragment.method.getReturnType());
    }

    public static void emit(Action action) {
        Fragment fragment = (Fragment)((Object)action);
        MethodReader method = hierarchy.resolve(fragment.method);
        generator.addProgram(method.getProgram(), fragment.capturedValues);
    }

    public static <T> Value<T> lazyFragment(LazyComputation<T> computation) {
        return MetaprogrammingImpl.lazyFragment(ValueType.object("java.lang.Object"), computation);
    }

    public static <T> Value<T> lazy(Computation<T> computation) {
        Fragment fragment = (Fragment)((Object)computation);
        return MetaprogrammingImpl.lazyFragment(fragment.method.getReturnType(), () -> MetaprogrammingImpl.emit(computation));
    }

    private static <T> Value<T> lazyFragment(ValueType type, LazyComputation<T> computation) {
        return new LazyValueImpl<T>(varContext, computation, type, MetaprogrammingImpl.generator.forcedLocation);
    }

    public static void exit(Computation<?> value) {
        if (value == null) {
            MetaprogrammingImpl.returnValue(null);
            return;
        }
        if (!(value instanceof Fragment)) {
            throw new IllegalStateException("Unexpected computation type: " + value.getClass().getName());
        }
        Fragment fragment = (Fragment)((Object)value);
        MethodReader method = hierarchy.resolve(fragment.method);
        generator.addProgram(method.getProgram(), fragment.capturedValues);
        MetaprogrammingImpl.generator.blockIndex = MetaprogrammingImpl.generator.returnBlockIndex;
        MetaprogrammingImpl.returnValue(MetaprogrammingImpl.unbox(generator.getResultVar()));
    }

    private static Variable unbox(Variable var) {
        if (returnType instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)returnType).getKind()) {
                case BOOLEAN: {
                    var = MetaprogrammingImpl.unbox(var, Boolean.class, Boolean.TYPE);
                    break;
                }
                case BYTE: {
                    var = MetaprogrammingImpl.unbox(var, Byte.class, Byte.TYPE);
                    break;
                }
                case SHORT: {
                    var = MetaprogrammingImpl.unbox(var, Short.class, Short.TYPE);
                    break;
                }
                case CHARACTER: {
                    var = MetaprogrammingImpl.unbox(var, Character.class, Character.TYPE);
                    break;
                }
                case INTEGER: {
                    var = MetaprogrammingImpl.unbox(var, Integer.class, Integer.TYPE);
                    break;
                }
                case LONG: {
                    var = MetaprogrammingImpl.unbox(var, Long.class, Long.TYPE);
                    break;
                }
                case FLOAT: {
                    var = MetaprogrammingImpl.unbox(var, Float.class, Float.TYPE);
                    break;
                }
                case DOUBLE: {
                    var = MetaprogrammingImpl.unbox(var, Double.class, Double.TYPE);
                }
            }
        }
        return var;
    }

    private static Variable unbox(Variable var, Class<?> boxed, Class<?> primitive) {
        InvokeInstruction insn = new InvokeInstruction();
        insn.setInstance(var);
        insn.setType(InvocationType.VIRTUAL);
        insn.setMethod(new MethodReference(boxed, primitive.getName() + "Value", primitive));
        var = MetaprogrammingImpl.generator.program.createVariable();
        insn.setReceiver(var);
        generator.add(insn);
        return var;
    }

    public static void exit() {
        MetaprogrammingImpl.exit(null);
    }

    public static void location(String fileName, int lineNumber) {
        MetaprogrammingImpl.generator.forcedLocation = new TextLocation(fileName, lineNumber);
    }

    public static void defaultLocation() {
        MetaprogrammingImpl.generator.forcedLocation = null;
    }

    public static SourceLocation getLocation() {
        TextLocation location = MetaprogrammingImpl.generator.forcedLocation;
        if (location == null) {
            location = MetaprogrammingImpl.generator.location;
        }
        if (location == null) {
            return null;
        }
        ReflectClassImpl<?> cls = reflectContext.findClass(templateMethod.getClassName());
        if (cls == null) {
            return null;
        }
        cls.resolve();
        MethodReader methodReader = cls.classReader.getMethod(templateMethod.getDescriptor());
        if (methodReader == null) {
            return null;
        }
        ReflectMethodImpl method = new ReflectMethodImpl(cls, methodReader);
        return new SourceLocation(method, location.getFileName(), location.getLine());
    }

    public static ReflectClass<?> findClass(String name) {
        return reflectContext.findClass(name);
    }

    public static <T> ReflectClass<T> findClass(Class<T> cls) {
        return reflectContext.findClass(cls);
    }

    static ReflectClass<?> findClass(ValueType type) {
        return reflectContext.getClass(type);
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static <T> ReflectClass<T[]> arrayClass(ReflectClass<T> componentType) {
        ReflectClassImpl componentTypeImpl = (ReflectClassImpl)componentType;
        return reflectContext.getClass(ValueType.arrayOf(componentTypeImpl.type));
    }

    public static ReflectClass<?> createClass(byte[] bytecode) {
        return MetaprogrammingImpl.findClass(agent.submitClassFile(bytecode).replace('/', '.'));
    }

    public static <T> Value<T> proxy(Class<T> type, InvocationHandler<T> handler) {
        return MetaprogrammingImpl.proxy(MetaprogrammingImpl.findClass(type), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Value<T> proxy(ReflectClass<T> type, InvocationHandler<T> handler) {
        ValueType innerType = ((ReflectClassImpl)type).type;
        ClassHolder cls = new ClassHolder(MetaprogrammingImpl.createProxyName(type.getName()));
        cls.setLevel(AccessLevel.PUBLIC);
        String typeName = ((ValueType.Object)innerType).getClassName();
        ClassReader typeReader = classSource.get(typeName);
        if (typeReader.hasModifier(ElementModifier.INTERFACE)) {
            cls.setParent("java.lang.Object");
            cls.getInterfaces().add(typeName);
        } else {
            cls.setParent(typeName);
        }
        ProxyVariableContext nestedVarContext = new ProxyVariableContext(varContext, cls);
        for (ReflectMethod method : type.getMethods()) {
            ReflectMethodImpl methodImpl = (ReflectMethodImpl)method;
            if (methodImpl.method.getProgram() != null && methodImpl.method.getProgram().basicBlockCount() > 0 || methodImpl.method.hasModifier(ElementModifier.NATIVE) || !methodImpl.method.hasModifier(ElementModifier.ABSTRACT)) continue;
            MethodHolder methodHolder = new MethodHolder(methodImpl.method.getDescriptor());
            methodHolder.setLevel(AccessLevel.PUBLIC);
            ValueType returnTypeBackup = returnType;
            VariableContext varContextBackup = varContext;
            CompositeMethodGenerator generatorBackup = generator;
            try {
                int i;
                returnType = methodHolder.getResultType();
                varContext = nestedVarContext;
                generator = new CompositeMethodGenerator(varContext, new Program());
                MetaprogrammingImpl.generator.forcedLocation = generatorBackup.forcedLocation;
                Program program = MetaprogrammingImpl.generator.program;
                program.createBasicBlock();
                MetaprogrammingImpl.generator.blockIndex = 0;
                BasicBlock startBlock = generator.currentBlock();
                nestedVarContext.init(startBlock);
                methodHolder.setProgram(program);
                Variable thisVar = program.createVariable();
                int argumentCount = methodImpl.method.parameterCount();
                ValueImpl[] arguments = new ValueImpl[argumentCount];
                for (i = 0; i < arguments.length; ++i) {
                    arguments[i] = new ValueImpl(program.createVariable(), nestedVarContext, methodImpl.method.parameterType(i));
                }
                for (i = 0; i < arguments.length; ++i) {
                    ValueType argType = methodImpl.method.parameterType(i);
                    Variable var = generator.box(arguments[i].innerValue, argType);
                    arguments[i] = new ValueImpl(var, nestedVarContext, argType);
                }
                MetaprogrammingImpl.generator.program.createBasicBlock();
                MetaprogrammingImpl.generator.blockIndex = 1;
                handler.invoke(new ValueImpl(thisVar, nestedVarContext, innerType), methodImpl, arguments);
                MetaprogrammingImpl.close();
                JumpInstruction jumpToStart = new JumpInstruction();
                jumpToStart.setTarget(program.basicBlockAt(startBlock.getIndex() + 1));
                startBlock.add(jumpToStart);
                new Optimizations().apply(program, new MethodReference(cls.getName(), methodHolder.getDescriptor()));
                cls.addMethod(methodHolder);
            }
            finally {
                returnType = returnTypeBackup;
                varContext = varContextBackup;
                generator = generatorBackup;
            }
        }
        ValueImpl result = new ValueImpl(nestedVarContext.createInstance(generator), varContext, innerType);
        incrementalDependencies.setNoCache(cls.getName());
        agent.submitClass(cls);
        return result;
    }

    private static String createProxyName(String className) {
        int ownSuffix = proxySuffixGenerators.getOrDefault(className, 0);
        proxySuffixGenerators.put(className, ownSuffix + 1);
        return className + "$proxy$" + suffix + "_" + ownSuffix;
    }

    private static void returnValue(Variable var) {
        ExitInstruction insn = new ExitInstruction();
        insn.setValueToReturn(var);
        generator.add(insn);
    }

    public static Diagnostics getDiagnostics() {
        return diagnostics;
    }

    public static void close() {
        Variable var;
        TransitionExtractor transitionExtractor = new TransitionExtractor();
        BasicBlock block = generator.currentBlock();
        Instruction lastInstruction = block.getLastInstruction();
        if (lastInstruction != null) {
            lastInstruction.acceptVisitor(transitionExtractor);
        }
        if (transitionExtractor.getTargets() != null) {
            return;
        }
        if (returnType instanceof ValueType.Void) {
            var = null;
        } else if (returnType instanceof ValueType.Primitive) {
            var = MetaprogrammingImpl.generator.program.createVariable();
            switch (((ValueType.Primitive)returnType).getKind()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case CHARACTER: 
                case INTEGER: {
                    IntegerConstantInstruction constantInsn = new IntegerConstantInstruction();
                    constantInsn.setReceiver(var);
                    generator.add(constantInsn);
                    break;
                }
                case LONG: {
                    LongConstantInstruction constantInsn = new LongConstantInstruction();
                    constantInsn.setReceiver(var);
                    generator.add(constantInsn);
                    break;
                }
                case FLOAT: {
                    FloatConstantInstruction constantInsn = new FloatConstantInstruction();
                    constantInsn.setReceiver(var);
                    generator.add(constantInsn);
                    break;
                }
                case DOUBLE: {
                    DoubleConstantInstruction constantInsn = new DoubleConstantInstruction();
                    constantInsn.setReceiver(var);
                    generator.add(constantInsn);
                    break;
                }
            }
        } else {
            NullConstantInstruction constantInsn = new NullConstantInstruction();
            var = MetaprogrammingImpl.generator.program.createVariable();
            constantInsn.setReceiver(var);
            generator.add(constantInsn);
        }
        MetaprogrammingImpl.returnValue(var);
    }

    public static void unsupportedCase() {
        unsupportedCase = true;
    }

    static {
        proxySuffixGenerators = new HashMap<String, Integer>();
        diagnostics = new Diagnostics(){

            @Override
            public void error(SourceLocation location, String error, Object ... params) {
                this.convertParams(params);
                agent.getDiagnostics().error(this.convertLocation(location), error, params);
            }

            @Override
            public void warning(SourceLocation location, String error, Object ... params) {
                this.convertParams(params);
                agent.getDiagnostics().warning(this.convertLocation(location), error, params);
            }

            private void convertParams(Object[] params) {
                for (int i = 0; i < params.length; ++i) {
                    if (params[i] instanceof ReflectMethodImpl) {
                        params[i] = ((ReflectMethodImpl)params[i]).method.getReference();
                        continue;
                    }
                    if (params[i] instanceof ReflectClassImpl) {
                        params[i] = ((ReflectClassImpl)params[i]).type;
                        continue;
                    }
                    if (params[i] instanceof ReflectFieldImpl) {
                        params[i] = ((ReflectFieldImpl)params[i]).field.getReference();
                        continue;
                    }
                    if (!(params[i] instanceof Class)) continue;
                    params[i] = ValueType.parse((Class)params[i]);
                }
            }

            private CallLocation convertLocation(SourceLocation location) {
                if (location == null) {
                    return null;
                }
                MethodReader method = ((ReflectMethodImpl)location.getMethod()).method;
                return location.getFileName() != null ? new CallLocation(method.getReference(), new TextLocation(location.getFileName(), location.getLineNumber())) : new CallLocation(method.getReference());
            }
        };
    }
}

