/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.common.Promise;
import org.teavm.debugging.Breakpoint;
import org.teavm.debugging.CallFrame;
import org.teavm.debugging.DebuggerListener;
import org.teavm.debugging.Value;
import org.teavm.debugging.Variable;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.DebugInformationProvider;
import org.teavm.debugging.information.DebuggerCallSite;
import org.teavm.debugging.information.DebuggerCallSiteVisitor;
import org.teavm.debugging.information.DebuggerStaticCallSite;
import org.teavm.debugging.information.DebuggerVirtualCallSite;
import org.teavm.debugging.information.GeneratedLocation;
import org.teavm.debugging.information.SourceLocation;
import org.teavm.debugging.javascript.JavaScriptBreakpoint;
import org.teavm.debugging.javascript.JavaScriptCallFrame;
import org.teavm.debugging.javascript.JavaScriptDebugger;
import org.teavm.debugging.javascript.JavaScriptDebuggerListener;
import org.teavm.debugging.javascript.JavaScriptLocation;
import org.teavm.debugging.javascript.JavaScriptVariable;
import org.teavm.model.MethodReference;

public class Debugger {
    private Set<DebuggerListener> listeners = new LinkedHashSet<DebuggerListener>();
    private JavaScriptDebugger javaScriptDebugger;
    private DebugInformationProvider debugInformationProvider;
    private List<JavaScriptBreakpoint> temporaryBreakpoints = new ArrayList<JavaScriptBreakpoint>();
    private Map<String, DebugInformation> debugInformationMap = new HashMap<String, DebugInformation>();
    private Map<String, Set<DebugInformation>> debugInformationFileMap = new HashMap<String, Set<DebugInformation>>();
    private Map<DebugInformation, String> scriptMap = new HashMap<DebugInformation, String>();
    private Map<JavaScriptBreakpoint, Breakpoint> breakpointMap = new HashMap<JavaScriptBreakpoint, Breakpoint>();
    private Set<Breakpoint> breakpoints = new LinkedHashSet<Breakpoint>();
    private Set<? extends Breakpoint> readonlyBreakpoints = Collections.unmodifiableSet(this.breakpoints);
    private CallFrame[] callStack;
    private Set<String> scriptNames = new LinkedHashSet<String>();
    private JavaScriptDebuggerListener javaScriptListener = new JavaScriptDebuggerListener(){

        @Override
        public void resumed() {
            Debugger.this.fireResumed();
        }

        @Override
        public void paused(JavaScriptBreakpoint breakpoint) {
            Debugger.this.firePaused(breakpoint);
        }

        @Override
        public void scriptAdded(String name) {
            Debugger.this.addScript(name);
        }

        @Override
        public void attached() {
            Debugger.this.fireAttached();
        }

        @Override
        public void detached() {
            Debugger.this.fireDetached();
        }

        @Override
        public void breakpointChanged(JavaScriptBreakpoint jsBreakpoint) {
            Debugger.this.fireBreakpointChanged(jsBreakpoint);
        }
    };

    public Debugger(JavaScriptDebugger javaScriptDebugger, DebugInformationProvider debugInformationProvider) {
        this.javaScriptDebugger = javaScriptDebugger;
        this.debugInformationProvider = debugInformationProvider;
        javaScriptDebugger.addListener(this.javaScriptListener);
    }

    public JavaScriptDebugger getJavaScriptDebugger() {
        return this.javaScriptDebugger;
    }

    public void addListener(DebuggerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DebuggerListener listener) {
        this.listeners.remove(listener);
    }

    public Promise<Void> suspend() {
        return this.javaScriptDebugger.suspend();
    }

    public Promise<Void> resume() {
        return this.javaScriptDebugger.resume();
    }

    public Promise<Void> stepInto() {
        return this.step(true);
    }

    public Promise<Void> stepOut() {
        return this.javaScriptDebugger.stepOut();
    }

    public Promise<Void> stepOver() {
        return this.step(false);
    }

    private Promise<Void> jsStep(boolean enterMethod) {
        return enterMethod ? this.javaScriptDebugger.stepInto() : this.javaScriptDebugger.stepOver();
    }

    private Promise<Void> step(boolean enterMethod) {
        CallFrame[] callStack = this.getCallStack();
        if (callStack == null || callStack.length == 0) {
            return this.jsStep(enterMethod);
        }
        CallFrame recentFrame = callStack[0];
        if (recentFrame.getLocation() == null || recentFrame.getLocation().getFileName() == null || recentFrame.getLocation().getLine() < 0) {
            return this.jsStep(enterMethod);
        }
        HashSet<JavaScriptLocation> successors = new HashSet<JavaScriptLocation>();
        boolean first = true;
        for (CallFrame frame : callStack) {
            boolean exits;
            String script = frame.getOriginalLocation().getScript();
            DebugInformation debugInfo = this.debugInformationMap.get(script);
            if (frame.getLocation() != null && frame.getLocation().getFileName() != null && frame.getLocation().getLine() >= 0 && debugInfo != null) {
                exits = this.addFollowing(debugInfo, frame.getLocation(), script, new HashSet<SourceLocation>(), successors);
                if (enterMethod) {
                    DebuggerCallSite[] callSites;
                    CallSiteSuccessorFinder successorFinder = new CallSiteSuccessorFinder(debugInfo, script, successors);
                    for (DebuggerCallSite callSite : callSites = debugInfo.getCallSites(frame.getLocation())) {
                        callSite.acceptVisitor(successorFinder);
                    }
                }
            } else {
                exits = true;
            }
            if (!exits) break;
            enterMethod = false;
            if (!first && frame.getLocation() != null) {
                for (GeneratedLocation location : debugInfo.getGeneratedLocations(frame.getLocation())) {
                    successors.add(new JavaScriptLocation(script, location.getLine(), location.getColumn()));
                }
            }
            first = false;
        }
        ArrayList<Promise<Void>> jsBreakpointPromises = new ArrayList<Promise<Void>>();
        for (JavaScriptLocation successor : successors) {
            jsBreakpointPromises.add(this.javaScriptDebugger.createBreakpoint(successor).thenVoid(this.temporaryBreakpoints::add));
        }
        return Promise.allVoid(jsBreakpointPromises).thenAsync(v -> this.javaScriptDebugger.resume());
    }

    private boolean addFollowing(DebugInformation debugInfo, SourceLocation location, String script, Set<SourceLocation> visited, Set<JavaScriptLocation> successors) {
        if (!visited.add(location)) {
            return false;
        }
        SourceLocation[] following = debugInfo.getFollowingLines(location);
        boolean exits = false;
        if (following != null) {
            for (SourceLocation successor : following) {
                if (successor == null) {
                    exits = true;
                    continue;
                }
                Collection<GeneratedLocation> genLocations = debugInfo.getGeneratedLocations(successor);
                if (!genLocations.isEmpty()) {
                    for (GeneratedLocation loc : genLocations) {
                        loc = debugInfo.getStatementLocation(loc);
                        successors.add(new JavaScriptLocation(script, loc.getLine(), loc.getColumn()));
                    }
                    continue;
                }
                exits |= this.addFollowing(debugInfo, successor, script, visited, successors);
            }
        }
        return exits;
    }

    private List<DebugInformation> debugInformationBySource(String sourceFile) {
        Set<DebugInformation> list = this.debugInformationFileMap.get(sourceFile);
        return list != null ? new ArrayList<DebugInformation>(list) : Collections.emptyList();
    }

    public Promise<Void> continueToLocation(SourceLocation location) {
        return this.continueToLocation(location.getFileName(), location.getLine());
    }

    public Promise<Void> continueToLocation(String fileName, int line) {
        if (!this.javaScriptDebugger.isSuspended()) {
            return Promise.VOID;
        }
        ArrayList<Promise<Void>> promises = new ArrayList<Promise<Void>>();
        for (DebugInformation debugInformation : this.debugInformationBySource(fileName)) {
            Collection<GeneratedLocation> locations = debugInformation.getGeneratedLocations(fileName, line);
            for (GeneratedLocation location : locations) {
                JavaScriptLocation jsLocation = new JavaScriptLocation(this.scriptMap.get(debugInformation), location.getLine(), location.getColumn());
                promises.add(this.javaScriptDebugger.createBreakpoint(jsLocation).thenVoid(this.temporaryBreakpoints::add));
            }
        }
        return Promise.allVoid(promises).thenAsync(v -> this.javaScriptDebugger.resume());
    }

    public boolean isSuspended() {
        return this.javaScriptDebugger.isSuspended();
    }

    public Promise<Breakpoint> createBreakpoint(String file, int line) {
        return this.createBreakpoint(new SourceLocation(file, line));
    }

    public Collection<? extends String> getSourceFiles() {
        return this.debugInformationFileMap.keySet();
    }

    public Promise<Breakpoint> createBreakpoint(SourceLocation location) {
        Breakpoint breakpoint = new Breakpoint(this, location);
        this.breakpoints.add(breakpoint);
        return this.updateInternalBreakpoints(breakpoint).then(v -> {
            this.updateBreakpointStatus(breakpoint, false);
            return breakpoint;
        });
    }

    public Set<? extends Breakpoint> getBreakpoints() {
        return this.readonlyBreakpoints;
    }

    private Promise<Void> updateInternalBreakpoints(Breakpoint breakpoint) {
        if (breakpoint.isDestroyed()) {
            return Promise.VOID;
        }
        ArrayList<Promise<Void>> promises = new ArrayList<Promise<Void>>();
        for (JavaScriptBreakpoint jsBreakpoint2 : breakpoint.jsBreakpoints) {
            this.breakpointMap.remove(jsBreakpoint2);
            promises.add(jsBreakpoint2.destroy());
        }
        ArrayList<JavaScriptBreakpoint> jsBreakpoints = new ArrayList<JavaScriptBreakpoint>();
        SourceLocation location = breakpoint.getLocation();
        for (DebugInformation debugInformation : this.debugInformationBySource(location.getFileName())) {
            Collection<GeneratedLocation> locations = debugInformation.getGeneratedLocations(location);
            for (GeneratedLocation genLocation : locations) {
                JavaScriptLocation jsLocation = new JavaScriptLocation(this.scriptMap.get(debugInformation), genLocation.getLine(), genLocation.getColumn());
                promises.add(this.javaScriptDebugger.createBreakpoint(jsLocation).thenVoid(jsBreakpoint -> {
                    jsBreakpoints.add((JavaScriptBreakpoint)jsBreakpoint);
                    this.breakpointMap.put((JavaScriptBreakpoint)jsBreakpoint, breakpoint);
                }));
            }
        }
        breakpoint.jsBreakpoints = jsBreakpoints;
        return Promise.allVoid(promises);
    }

    private DebuggerListener[] getListeners() {
        return this.listeners.toArray(new DebuggerListener[0]);
    }

    private void updateBreakpointStatus(Breakpoint breakpoint, boolean fireEvent) {
        boolean valid = false;
        for (JavaScriptBreakpoint jsBreakpoint : breakpoint.jsBreakpoints) {
            if (!jsBreakpoint.isValid()) continue;
            valid = true;
        }
        if (breakpoint.valid != valid) {
            breakpoint.valid = valid;
            if (fireEvent) {
                for (DebuggerListener listener : this.getListeners()) {
                    listener.breakpointStatusChanged(breakpoint);
                }
            }
        }
    }

    public CallFrame[] getCallStack() {
        if (!this.isSuspended()) {
            return null;
        }
        if (this.callStack == null) {
            ArrayList<CallFrame> frames = new ArrayList<CallFrame>();
            boolean wasEmpty = false;
            for (JavaScriptCallFrame jsFrame : this.javaScriptDebugger.getCallStack()) {
                MethodReference method;
                DebugInformation debugInformation = this.debugInformationMap.get(jsFrame.getLocation().getScript());
                SourceLocation loc = debugInformation != null ? debugInformation.getSourceLocation(jsFrame.getLocation().getLine(), jsFrame.getLocation().getColumn()) : null;
                boolean empty = loc == null || loc.getFileName() == null && loc.getLine() < 0;
                MethodReference methodReference = method = !empty && debugInformation != null ? debugInformation.getMethodAt(jsFrame.getLocation().getLine(), jsFrame.getLocation().getColumn()) : null;
                if (!empty || !wasEmpty) {
                    frames.add(new CallFrame(this, jsFrame, loc, method, debugInformation));
                }
                wasEmpty = empty;
            }
            this.callStack = frames.toArray(new CallFrame[0]);
        }
        return (CallFrame[])this.callStack.clone();
    }

    Promise<Map<String, Variable>> createVariables(JavaScriptCallFrame jsFrame, DebugInformation debugInformation) {
        return jsFrame.getVariables().then(jsVariables -> {
            HashMap<String, Variable> vars = new HashMap<String, Variable>();
            for (Map.Entry entry : jsVariables.entrySet()) {
                JavaScriptVariable jsVar = (JavaScriptVariable)entry.getValue();
                String[] names = this.mapVariable((String)entry.getKey(), jsFrame.getLocation());
                Value value = new Value(this, debugInformation, jsVar.getValue());
                for (String name : names) {
                    if (name == null) {
                        name = "js:" + jsVar.getName();
                    }
                    vars.put(name, new Variable(name, value));
                }
            }
            return Collections.unmodifiableMap(vars);
        });
    }

    private void addScript(String name) {
        if (!name.isEmpty()) {
            this.scriptNames.add(name);
        }
        if (this.debugInformationMap.containsKey(name)) {
            this.updateBreakpoints();
            return;
        }
        DebugInformation debugInfo = this.debugInformationProvider.getDebugInformation(name);
        if (debugInfo == null) {
            return;
        }
        this.debugInformationMap.put(name, debugInfo);
        for (String sourceFile : debugInfo.getFilesNames()) {
            Set<DebugInformation> list = this.debugInformationFileMap.get(sourceFile);
            if (list == null) {
                list = new HashSet<DebugInformation>();
                this.debugInformationFileMap.put(sourceFile, list);
            }
            list.add(debugInfo);
        }
        this.scriptMap.put(debugInfo, name);
        this.updateBreakpoints();
    }

    public Set<? extends String> getScriptNames() {
        return this.scriptNames;
    }

    private void updateBreakpoints() {
        for (Breakpoint breakpoint : this.breakpoints) {
            this.updateInternalBreakpoints(breakpoint).thenVoid(v -> this.updateBreakpointStatus(breakpoint, true));
        }
    }

    public boolean isAttached() {
        return this.javaScriptDebugger.isAttached();
    }

    public void detach() {
        this.javaScriptDebugger.detach();
    }

    void destroyBreakpoint(Breakpoint breakpoint) {
        for (JavaScriptBreakpoint jsBreakpoint : breakpoint.jsBreakpoints) {
            jsBreakpoint.destroy();
            this.breakpointMap.remove(jsBreakpoint);
        }
        breakpoint.jsBreakpoints = new ArrayList<JavaScriptBreakpoint>();
        this.breakpoints.remove(breakpoint);
    }

    private void fireResumed() {
        for (DebuggerListener listener : this.getListeners()) {
            listener.resumed();
        }
    }

    private void firePaused(JavaScriptBreakpoint breakpoint) {
        ArrayList<JavaScriptBreakpoint> temporaryBreakpoints = new ArrayList<JavaScriptBreakpoint>(this.temporaryBreakpoints);
        this.temporaryBreakpoints.clear();
        ArrayList<Promise<Void>> promises = new ArrayList<Promise<Void>>();
        for (JavaScriptBreakpoint jsBreakpoint : temporaryBreakpoints) {
            promises.add(jsBreakpoint.destroy());
        }
        this.callStack = null;
        Promise.allVoid(promises).thenVoid(v -> {
            Breakpoint javaBreakpoint = null;
            if (breakpoint != null && !temporaryBreakpoints.contains(breakpoint)) {
                javaBreakpoint = this.breakpointMap.get(breakpoint);
            }
            for (DebuggerListener listener : this.getListeners()) {
                listener.paused(javaBreakpoint);
            }
        });
    }

    private void fireAttached() {
        for (Breakpoint breakpoint : this.breakpoints) {
            this.updateInternalBreakpoints(breakpoint).thenVoid(v -> this.updateBreakpointStatus(breakpoint, false));
        }
        for (DebuggerListener listener : this.getListeners()) {
            listener.attached();
        }
    }

    private void fireDetached() {
        for (Breakpoint breakpoint : this.breakpoints) {
            this.updateBreakpointStatus(breakpoint, false);
        }
        for (DebuggerListener listener : this.getListeners()) {
            listener.detached();
        }
    }

    private void fireBreakpointChanged(JavaScriptBreakpoint jsBreakpoint) {
        Breakpoint breakpoint = this.breakpointMap.get(jsBreakpoint);
        if (breakpoint != null) {
            this.updateBreakpointStatus(breakpoint, true);
        }
    }

    String[] mapVariable(String variable, JavaScriptLocation location) {
        DebugInformation debugInfo = this.debugInformationMap.get(location.getScript());
        if (debugInfo == null) {
            return new String[0];
        }
        return debugInfo.getVariableMeaningAt(location.getLine(), location.getColumn(), variable);
    }

    String mapField(String className, String jsField) {
        for (DebugInformation debugInfo : this.debugInformationMap.values()) {
            String meaning = debugInfo.getFieldMeaning(className, jsField);
            if (meaning == null) continue;
            return meaning;
        }
        return null;
    }

    static class CallSiteSuccessorFinder
    implements DebuggerCallSiteVisitor {
        private DebugInformation debugInfo;
        private String script;
        Set<JavaScriptLocation> locations;

        CallSiteSuccessorFinder(DebugInformation debugInfo, String script, Set<JavaScriptLocation> locations) {
            this.debugInfo = debugInfo;
            this.script = script;
            this.locations = locations;
        }

        @Override
        public void visit(DebuggerVirtualCallSite callSite) {
            for (MethodReference potentialMethod : this.debugInfo.getOverridingMethods(callSite.getMethod())) {
                for (GeneratedLocation loc : this.debugInfo.getMethodEntrances(potentialMethod)) {
                    loc = this.debugInfo.getStatementLocation(loc);
                    this.locations.add(new JavaScriptLocation(this.script, loc.getLine(), loc.getColumn()));
                }
            }
        }

        @Override
        public void visit(DebuggerStaticCallSite callSite) {
            for (GeneratedLocation loc : this.debugInfo.getMethodEntrances(callSite.getMethod())) {
                loc = this.debugInfo.getStatementLocation(loc);
                this.locations.add(new JavaScriptLocation(this.script, loc.getLine(), loc.getColumn()));
            }
        }
    }
}

