/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.teavm.classlib.java.util.stream.TCollectorImpl;

public interface TCollector<T, A, R> {
    public Supplier<A> supplier();

    public BiConsumer<A, T> accumulator();

    public BinaryOperator<A> combiner();

    public Function<A, R> finisher();

    public Set<Characteristics> characteristics();

    public static <T, R> TCollector<T, R, R> of(Supplier<R> supplier, BiConsumer<R, T> accumulator, BinaryOperator<R> combiner, Characteristics ... characteristics) {
        return TCollector.of(supplier, accumulator, combiner, (A x) -> x, characteristics);
    }

    public static <T, A, R> TCollector<T, A, R> of(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Characteristics ... characteristics) {
        EnumSet<Characteristics> characteristicsSet = EnumSet.noneOf(Characteristics.class);
        characteristicsSet.addAll(Arrays.asList(characteristics));
        return new TCollectorImpl<T, A, R>(supplier, accumulator, combiner, finisher, characteristicsSet);
    }

    public static enum Characteristics {
        CONCURRENT,
        UNORDERED,
        IDENTITY_FINISH;

    }
}

