/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.text;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.teavm.classlib.java.text.TAttributedCharacterIterator;
import org.teavm.classlib.java.text.TAttributedString;
import org.teavm.classlib.java.text.TChoiceFormat;
import org.teavm.classlib.java.text.TDateFormat;
import org.teavm.classlib.java.text.TDecimalFormat;
import org.teavm.classlib.java.text.TDecimalFormatSymbols;
import org.teavm.classlib.java.text.TFieldPosition;
import org.teavm.classlib.java.text.TFormat;
import org.teavm.classlib.java.text.TNumberFormat;
import org.teavm.classlib.java.text.TParsePosition;
import org.teavm.classlib.java.text.TSimpleDateFormat;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TLocale;

public class TMessageFormat
extends TFormat {
    private TLocale locale = TLocale.getDefault();
    private transient String[] strings;
    private int[] argumentNumbers;
    private TFormat[] formats;
    private int maxOffset;
    private transient int maxArgumentIndex;

    public TMessageFormat(String template, TLocale locale) {
        this.locale = locale;
        this.applyPattern(template);
    }

    public TMessageFormat(String template) {
        this.applyPattern(template);
    }

    public void applyPattern(String template) {
        int i;
        int length = template.length();
        StringBuffer buffer = new StringBuffer();
        TParsePosition position = new TParsePosition(0);
        ArrayList<String> localStrings = new ArrayList<String>();
        int argCount = 0;
        int[] args = new int[10];
        int maxArg = -1;
        ArrayList<TFormat> localFormats = new ArrayList<TFormat>();
        while (position.getIndex() < length) {
            if (TFormat.upTo(template, position, buffer, '{')) {
                char ch;
                int arg = 0;
                int offset = position.getIndex();
                if (offset >= length) {
                    throw new IllegalArgumentException("Invalid argument number");
                }
                while ((ch = template.charAt(offset++)) != '}' && ch != ',') {
                    if (ch < '0' || ch > '9') {
                        throw new IllegalArgumentException("Invalid argument number");
                    }
                    if ((arg = arg * 10 + (ch - 48)) >= 0 && offset < length) continue;
                    throw new IllegalArgumentException("Invalid argument number");
                }
                position.setIndex(--offset);
                localFormats.add(this.parseVariable(template, position));
                if (argCount >= args.length) {
                    int[] newArgs = new int[args.length * 2];
                    System.arraycopy(args, 0, newArgs, 0, args.length);
                    args = newArgs;
                }
                args[argCount++] = arg;
                if (arg > maxArg) {
                    maxArg = arg;
                }
            }
            localStrings.add(buffer.toString());
            buffer.setLength(0);
        }
        this.strings = new String[localStrings.size()];
        for (i = 0; i < localStrings.size(); ++i) {
            this.strings[i] = (String)localStrings.get(i);
        }
        this.argumentNumbers = args;
        this.formats = new TFormat[argCount];
        for (i = 0; i < argCount; ++i) {
            this.formats[i] = (TFormat)localFormats.get(i);
        }
        this.maxOffset = argCount - 1;
        this.maxArgumentIndex = maxArg;
    }

    @Override
    public Object clone() {
        TMessageFormat clone = (TMessageFormat)super.clone();
        TFormat[] array = new TFormat[this.formats.length];
        int i = this.formats.length;
        while (--i >= 0) {
            if (this.formats[i] == null) continue;
            array[i] = (TFormat)this.formats[i].clone();
        }
        clone.formats = array;
        return clone;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TMessageFormat)) {
            return false;
        }
        TMessageFormat format = (TMessageFormat)object;
        if (this.maxOffset != format.maxOffset) {
            return false;
        }
        for (int i = 0; i <= this.maxOffset; ++i) {
            if (this.argumentNumbers[i] == format.argumentNumbers[i]) continue;
            return false;
        }
        return this.locale.equals(format.locale) && Arrays.equals(this.strings, format.strings) && Arrays.equals(this.formats, format.formats);
    }

    @Override
    public TAttributedCharacterIterator formatToCharacterIterator(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        StringBuffer buffer = new StringBuffer();
        ArrayList<FieldContainer> fields = new ArrayList<FieldContainer>();
        this.formatImpl((Object[])object, buffer, new TFieldPosition(0), fields);
        TAttributedString as = new TAttributedString(buffer.toString());
        for (FieldContainer fc : fields) {
            as.addAttribute(fc.attribute, fc.value, fc.start, fc.end);
        }
        return as.getIterator();
    }

    public final StringBuffer format(Object[] objects, StringBuffer buffer, TFieldPosition field) {
        return this.formatImpl(objects, buffer, field, null);
    }

    private StringBuffer formatImpl(Object[] objects, StringBuffer buffer, TFieldPosition position, List<FieldContainer> fields) {
        TFieldPosition passedField = new TFieldPosition(0);
        for (int i = 0; i <= this.maxOffset; ++i) {
            buffer.append(this.strings[i]);
            int begin = buffer.length();
            if (objects == null || this.argumentNumbers[i] >= objects.length) {
                buffer.append('{');
                buffer.append(this.argumentNumbers[i]);
                buffer.append('}');
                this.handleArgumentField(begin, buffer.length(), this.argumentNumbers[i], position, fields);
                continue;
            }
            Object arg = objects[this.argumentNumbers[i]];
            TFormat format = this.formats[i];
            if (format == null || arg == null) {
                if (arg instanceof Number) {
                    format = TNumberFormat.getInstance();
                } else if (arg instanceof Date) {
                    format = TDateFormat.getInstance();
                } else {
                    buffer.append(arg);
                    this.handleArgumentField(begin, buffer.length(), this.argumentNumbers[i], position, fields);
                    continue;
                }
            }
            if (format instanceof TChoiceFormat) {
                String result = format.format(arg);
                TMessageFormat mf = new TMessageFormat(result);
                mf.setLocale(this.locale);
                mf.format(objects, buffer, passedField);
                this.handleArgumentField(begin, buffer.length(), this.argumentNumbers[i], position, fields);
                this.handleformat(format, arg, begin, fields);
                continue;
            }
            format.format(arg, buffer, passedField);
            this.handleArgumentField(begin, buffer.length(), this.argumentNumbers[i], position, fields);
            this.handleformat(format, arg, begin, fields);
        }
        if (this.maxOffset + 1 < this.strings.length) {
            buffer.append(this.strings[this.maxOffset + 1]);
        }
        return buffer;
    }

    private void handleArgumentField(int begin, int end, int argnumber, TFieldPosition position, List<FieldContainer> fields) {
        if (fields != null) {
            fields.add(new FieldContainer(begin, end, Field.ARGUMENT, argnumber));
        } else if (position != null && position.getFieldAttribute() == Field.ARGUMENT && position.getEndIndex() == 0) {
            position.setBeginIndex(begin);
            position.setEndIndex(end);
        }
    }

    private void handleformat(TFormat format, Object arg, int begin, List<FieldContainer> fields) {
        if (fields != null) {
            TAttributedCharacterIterator iterator = format.formatToCharacterIterator(arg);
            while (iterator.getIndex() != iterator.getEndIndex()) {
                int start = iterator.getRunStart();
                int end = iterator.getRunLimit();
                TIterator iter = iterator.getAttributes().keySet().iterator();
                while (iter.hasNext()) {
                    TAttributedCharacterIterator.Attribute attribute = (TAttributedCharacterIterator.Attribute)iter.next();
                    Object value = iterator.getAttribute(attribute);
                    fields.add(new FieldContainer(begin + start, begin + end, attribute, value));
                }
                iterator.setIndex(end);
            }
        }
    }

    @Override
    public final StringBuffer format(Object object, StringBuffer buffer, TFieldPosition field) {
        return this.format((Object[])object, buffer, field);
    }

    public static String format(String template, Object ... objects) {
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] != null) continue;
                objects[i] = "null";
            }
        }
        return new TMessageFormat(template).format(objects, new StringBuffer(), new TFieldPosition(0)).toString();
    }

    public TFormat[] getFormats() {
        return (TFormat[])this.formats.clone();
    }

    public TFormat[] getFormatsByArgumentIndex() {
        TFormat[] answer = new TFormat[this.maxArgumentIndex + 1];
        for (int i = 0; i < this.maxOffset + 1; ++i) {
            answer[this.argumentNumbers[i]] = this.formats[i];
        }
        return answer;
    }

    public void setFormatByArgumentIndex(int argIndex, TFormat format) {
        for (int i = 0; i < this.maxOffset + 1; ++i) {
            if (this.argumentNumbers[i] != argIndex) continue;
            this.formats[i] = format;
        }
    }

    public void setFormatsByArgumentIndex(TFormat[] formats) {
        for (int j = 0; j < formats.length; ++j) {
            for (int i = 0; i < this.maxOffset + 1; ++i) {
                if (this.argumentNumbers[i] != j) continue;
                this.formats[i] = formats[j];
            }
        }
    }

    public TLocale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i <= this.maxOffset; ++i) {
            hashCode += this.argumentNumbers[i] + this.strings[i].hashCode();
            if (this.formats[i] == null) continue;
            hashCode += this.formats[i].hashCode();
        }
        if (this.maxOffset + 1 < this.strings.length) {
            hashCode += this.strings[this.maxOffset + 1].hashCode();
        }
        if (this.locale != null) {
            return hashCode + this.locale.hashCode();
        }
        return hashCode;
    }

    public Object[] parse(String string) throws ParseException {
        TParsePosition position = new TParsePosition(0);
        Object[] result = this.parse(string, position);
        if (position.getIndex() == 0) {
            throw new ParseException("MessageFormat.parseObject(String) parse failure", position.getErrorIndex());
        }
        return result;
    }

    public Object[] parse(String string, TParsePosition position) {
        if (string == null) {
            return new Object[0];
        }
        TParsePosition internalPos = new TParsePosition(0);
        int offset = position.getIndex();
        Object[] result = new Object[this.maxArgumentIndex + 1];
        for (int i = 0; i <= this.maxOffset; ++i) {
            Object parse;
            String sub = this.strings[i];
            if (!string.startsWith(sub, offset)) {
                position.setErrorIndex(offset);
                return null;
            }
            offset += sub.length();
            TFormat format = this.formats[i];
            if (format == null) {
                if (i + 1 < this.strings.length) {
                    int next = string.indexOf(this.strings[i + 1], offset);
                    if (next == -1) {
                        position.setErrorIndex(offset);
                        return null;
                    }
                    parse = string.substring(offset, next);
                    offset = next;
                } else {
                    parse = string.substring(offset);
                    offset = string.length();
                }
            } else {
                internalPos.setIndex(offset);
                parse = format.parseObject(string, internalPos);
                if (internalPos.getErrorIndex() != -1) {
                    position.setErrorIndex(offset);
                    return null;
                }
                offset = internalPos.getIndex();
            }
            result[this.argumentNumbers[i]] = parse;
        }
        if (this.maxOffset + 1 < this.strings.length) {
            String sub = this.strings[this.maxOffset + 1];
            if (!string.startsWith(sub, offset)) {
                position.setErrorIndex(offset);
                return null;
            }
            offset += sub.length();
        }
        position.setIndex(offset);
        return result;
    }

    @Override
    public Object parseObject(String string, TParsePosition position) {
        return this.parse(string, position);
    }

    private int match(String string, TParsePosition position, boolean last, String[] tokens) {
        char ch;
        int offset;
        int length = string.length();
        int token = -1;
        for (offset = position.getIndex(); offset < length && Character.isWhitespace(string.charAt(offset)); ++offset) {
        }
        int i = tokens.length;
        while (--i >= 0) {
            if (!string.regionMatches(true, offset, tokens[i], 0, tokens[i].length())) continue;
            token = i;
            break;
        }
        if (token == -1) {
            return -1;
        }
        offset += tokens[token].length();
        while (offset < length && Character.isWhitespace(string.charAt(offset))) {
            ++offset;
        }
        if (offset < length && ((ch = string.charAt(offset)) == '}' || !last && ch == ',')) {
            position.setIndex(offset + 1);
            return token;
        }
        return -1;
    }

    private TFormat parseVariable(String string, TParsePosition position) {
        char ch;
        int length = string.length();
        int offset = position.getIndex();
        if (offset >= length) {
            throw new IllegalArgumentException("Missing element format");
        }
        if ((ch = string.charAt(offset++)) != '}' && ch != ',') {
            throw new IllegalArgumentException("Missing element format");
        }
        position.setIndex(offset);
        if (ch == '}') {
            return null;
        }
        int type = this.match(string, position, false, new String[]{"time", "date", "number", "choice"});
        if (type == -1) {
            throw new IllegalArgumentException("Unknown element format");
        }
        StringBuffer buffer = new StringBuffer();
        ch = string.charAt(position.getIndex() - 1);
        switch (type) {
            case 0: 
            case 1: {
                if (ch == '}') {
                    return type == 1 ? TDateFormat.getDateInstance(2, this.locale) : TDateFormat.getTimeInstance(2, this.locale);
                }
                int dateStyle = this.match(string, position, true, new String[]{"full", "long", "medium", "short"});
                if (dateStyle == -1) {
                    TFormat.upToWithQuotes(string, position, buffer, '}', '{');
                    return new TSimpleDateFormat(buffer.toString(), this.locale);
                }
                switch (dateStyle) {
                    case 0: {
                        dateStyle = 0;
                        break;
                    }
                    case 1: {
                        dateStyle = 1;
                        break;
                    }
                    case 2: {
                        dateStyle = 2;
                        break;
                    }
                    case 3: {
                        dateStyle = 3;
                    }
                }
                return type == 1 ? TDateFormat.getDateInstance(dateStyle, this.locale) : TDateFormat.getTimeInstance(dateStyle, this.locale);
            }
            case 2: {
                if (ch == '}') {
                    return TNumberFormat.getInstance();
                }
                int numberStyle = this.match(string, position, true, new String[]{"currency", "percent", "integer"});
                if (numberStyle == -1) {
                    TMessageFormat.upToWithQuotes(string, position, buffer, '}', '{');
                    return new TDecimalFormat(buffer.toString(), new TDecimalFormatSymbols(this.locale));
                }
                switch (numberStyle) {
                    case 0: {
                        return TNumberFormat.getCurrencyInstance(this.locale);
                    }
                    case 1: {
                        return TNumberFormat.getPercentInstance(this.locale);
                    }
                }
                return TNumberFormat.getIntegerInstance(this.locale);
            }
        }
        try {
            TMessageFormat.upToWithQuotes(string, position, buffer, '}', '{');
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new TChoiceFormat(buffer.toString());
    }

    public void setFormat(int offset, TFormat format) {
        this.formats[offset] = format;
    }

    public void setFormats(TFormat[] formats) {
        int min = this.formats.length;
        if (formats.length < min) {
            min = formats.length;
        }
        for (int i = 0; i < min; ++i) {
            this.formats[i] = formats[i];
        }
    }

    public void setLocale(TLocale locale) {
        this.locale = locale;
        for (int i = 0; i <= this.maxOffset; ++i) {
            TFormat format = this.formats[i];
            if (format instanceof TDecimalFormat) {
                this.formats[i] = new TDecimalFormat(((TDecimalFormat)format).toPattern(), new TDecimalFormatSymbols(locale));
                continue;
            }
            if (!(format instanceof TSimpleDateFormat)) continue;
            this.formats[i] = new TSimpleDateFormat(((TSimpleDateFormat)format).toPattern(), locale);
        }
    }

    private String decodeDecimalFormat(StringBuffer buffer, TFormat format) {
        buffer.append(",number");
        if (!format.equals(TNumberFormat.getNumberInstance(this.locale))) {
            if (format.equals(TNumberFormat.getIntegerInstance(this.locale))) {
                buffer.append(",integer");
            } else if (format.equals(TNumberFormat.getCurrencyInstance(this.locale))) {
                buffer.append(",currency");
            } else if (format.equals(TNumberFormat.getPercentInstance(this.locale))) {
                buffer.append(",percent");
            } else {
                buffer.append(',');
                return ((TDecimalFormat)format).toPattern();
            }
        }
        return null;
    }

    private String decodeSimpleDateFormat(StringBuffer buffer, TFormat format) {
        if (format.equals(TDateFormat.getTimeInstance(2, this.locale))) {
            buffer.append(",time");
        } else if (format.equals(TDateFormat.getDateInstance(2, this.locale))) {
            buffer.append(",date");
        } else if (format.equals(TDateFormat.getTimeInstance(3, this.locale))) {
            buffer.append(",time,short");
        } else if (format.equals(TDateFormat.getDateInstance(3, this.locale))) {
            buffer.append(",date,short");
        } else if (format.equals(TDateFormat.getTimeInstance(1, this.locale))) {
            buffer.append(",time,long");
        } else if (format.equals(TDateFormat.getDateInstance(1, this.locale))) {
            buffer.append(",date,long");
        } else if (format.equals(TDateFormat.getTimeInstance(0, this.locale))) {
            buffer.append(",time,full");
        } else if (format.equals(TDateFormat.getDateInstance(0, this.locale))) {
            buffer.append(",date,full");
        } else {
            buffer.append(",date,");
            return ((TSimpleDateFormat)format).toPattern();
        }
        return null;
    }

    public String toPattern() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i <= this.maxOffset; ++i) {
            this.appendQuoted(buffer, this.strings[i]);
            buffer.append('{');
            buffer.append(this.argumentNumbers[i]);
            TFormat format = this.formats[i];
            String pattern = null;
            if (format instanceof TChoiceFormat) {
                buffer.append(",choice,");
                pattern = ((TChoiceFormat)format).toPattern();
            } else if (format instanceof TDecimalFormat) {
                pattern = this.decodeDecimalFormat(buffer, format);
            } else if (format instanceof TSimpleDateFormat) {
                pattern = this.decodeSimpleDateFormat(buffer, format);
            } else if (format != null) {
                throw new IllegalArgumentException("Unknown format");
            }
            if (pattern != null) {
                boolean quote = false;
                int index = 0;
                int length = pattern.length();
                int count = 0;
                while (index < length) {
                    int ch;
                    if ((ch = pattern.charAt(index++)) == 39) {
                        boolean bl = quote = !quote;
                    }
                    if (!quote) {
                        if (ch == 123) {
                            ++count;
                        }
                        if (ch == 125) {
                            if (count > 0) {
                                --count;
                            } else {
                                buffer.append("'}");
                                ch = 39;
                            }
                        }
                    }
                    buffer.append((char)ch);
                }
            }
            buffer.append('}');
        }
        if (this.maxOffset + 1 < this.strings.length) {
            this.appendQuoted(buffer, this.strings[this.maxOffset + 1]);
        }
        return buffer.toString();
    }

    private void appendQuoted(StringBuffer buffer, String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch == '{' || ch == '}') {
                buffer.append('\'');
                buffer.append(ch);
                buffer.append('\'');
                continue;
            }
            buffer.append(ch);
        }
    }

    public static class Field
    extends TFormat.Field {
        public static final Field ARGUMENT = new Field("message argument field");

        protected Field(String fieldName) {
            super(fieldName);
        }
    }

    static class FieldContainer {
        int start;
        int end;
        TAttributedCharacterIterator.Attribute attribute;
        Object value;

        FieldContainer(int start, int end, TAttributedCharacterIterator.Attribute attribute, Object value) {
            this.start = start;
            this.end = end;
            this.attribute = attribute;
            this.value = value;
        }
    }
}

