/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang.reflect;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class ArrayNativeGenerator
implements Generator,
DependencyPlugin {
    private static final String[] primitives = new String[]{"Byte", "Short", "Char", "Int", "Long", "Float", "Double", "Boolean"};
    private static final String[] primitiveWrappers = new String[]{"Byte", "Short", "Character", "Integer", "Long", "Float", "Double", "Boolean"};
    private static final ValueType[] primitiveTypes = new ValueType[]{ValueType.BYTE, ValueType.SHORT, ValueType.CHARACTER, ValueType.INTEGER, ValueType.LONG, ValueType.FLOAT, ValueType.DOUBLE, ValueType.BOOLEAN};
    private Set<MethodReference> reachedMethods = new HashSet<MethodReference>();

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        if (!this.reachedMethods.add(method.getReference())) {
            return;
        }
        switch (method.getReference().getName()) {
            case "getLength": {
                this.reachGetLength(agent, method);
                break;
            }
            case "newInstance": {
                method.getVariable(1).getClassValueNode().addConsumer(t -> {
                    String arrayTypeName = t.getName().startsWith("[") ? t.getName() : (t.getName().startsWith("~") ? t.getName().substring(1) : ValueType.object(t.getName()).toString());
                    if (!arrayTypeName.startsWith("[[[")) {
                        method.getResult().propagate(agent.getType("[" + arrayTypeName));
                    }
                });
                break;
            }
            case "getImpl": {
                this.reachGet(agent, method);
                break;
            }
            case "setImpl": {
                this.reachSet(agent, method);
            }
        }
    }

    @Override
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        switch (methodRef.getName()) {
            case "getLength": {
                this.generateGetLength(context, writer);
                break;
            }
            case "newInstanceImpl": {
                this.generateNewInstance(context, writer);
                break;
            }
            case "getImpl": {
                this.generateGet(context, writer);
                break;
            }
            case "setImpl": {
                this.generateSet(context, writer);
            }
        }
    }

    private void generateGetLength(GeneratorContext context, SourceWriter writer) throws IOException {
        String array = context.getParameterName(1);
        writer.append("if (" + array + " === null || " + array + ".constructor.$meta.item === undefined) {").softNewLine().indent();
        MethodReference cons = new MethodReference("java.lang.IllegalArgumentException", "<init>", ValueType.VOID);
        writer.append("$rt_throw(").appendInit(cons).append("());").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("return " + array + ".data.length;").softNewLine();
    }

    private void reachGetLength(DependencyAgent agent, MethodDependency method) {
        method.getVariable(1).addConsumer(type -> {
            if (!type.getName().startsWith("[")) {
                MethodReference cons = new MethodReference(IllegalArgumentException.class, "<init>", Void.TYPE);
                agent.linkMethod(cons).use();
            }
        });
    }

    private void generateNewInstance(GeneratorContext context, SourceWriter writer) throws IOException {
        String type = context.getParameterName(1);
        String length = context.getParameterName(2);
        writer.append("if (").append(type).append(".$meta.primitive) {").softNewLine().indent();
        for (String primitive : primitives) {
            writer.append("if (" + type + " == $rt_" + primitive.toLowerCase() + "cls()) {").indent().softNewLine();
            writer.append("return $rt_create" + primitive + "Array(" + length + ");").softNewLine();
            writer.outdent().append("}").softNewLine();
        }
        writer.outdent().append("} else {").indent().softNewLine();
        writer.append("return $rt_createArray(" + type + ", " + length + ")").softNewLine();
        writer.outdent().append("}").softNewLine();
    }

    private void generateGet(GeneratorContext context, SourceWriter writer) throws IOException {
        String array = context.getParameterName(1);
        writer.append("var item = " + array + ".data[" + context.getParameterName(2) + "];").softNewLine();
        writer.append("var type = " + array + ".constructor.$meta.item;").softNewLine();
        for (int i = 0; i < primitives.length; ++i) {
            String wrapper = "java.lang." + primitiveWrappers[i];
            MethodReference methodRef = new MethodReference(wrapper, "valueOf", primitiveTypes[i], ValueType.object(wrapper));
            ClassReader cls = context.getClassSource().get(methodRef.getClassName());
            if (cls == null || cls.getMethod(methodRef.getDescriptor()) == null) continue;
            writer.append("if (type === $rt_" + primitives[i].toLowerCase() + "cls()) {").indent().softNewLine();
            writer.append("return ").appendMethodBody(methodRef).append("(item);").softNewLine();
            writer.outdent().append("} else ");
        }
        writer.append("{").indent().softNewLine();
        writer.append("return item;").softNewLine();
        writer.outdent().append("}").softNewLine();
    }

    private void generateSet(GeneratorContext context, SourceWriter writer) throws IOException {
        String array = context.getParameterName(1);
        String item = context.getParameterName(3);
        writer.append("var type = " + array + ".constructor.$meta.item;").softNewLine();
        boolean first = true;
        for (int i = 0; i < primitives.length; ++i) {
            String wrapper = "java.lang." + primitiveWrappers[i];
            MethodReference methodRef = new MethodReference(wrapper, primitives[i].toLowerCase() + "Value", primitiveTypes[i]);
            ClassReader cls = context.getClassSource().get(methodRef.getClassName());
            if (cls == null || cls.getMethod(methodRef.getDescriptor()) == null) continue;
            if (!first) {
                writer.append(" else ");
            }
            first = false;
            writer.append("if (type === $rt_" + primitives[i].toLowerCase() + "cls()) {").indent().softNewLine();
            writer.append(item + " = ").appendMethodBody(methodRef).append("(" + item + ");").softNewLine();
            writer.outdent().append("}");
        }
        writer.softNewLine();
        writer.append(array + ".data[" + context.getParameterName(2) + "] = " + item + ";").softNewLine();
    }

    private void reachGet(DependencyAgent agent, MethodDependency method) {
        method.getVariable(1).getArrayItem().connect(method.getResult());
        method.getVariable(1).addConsumer(type -> {
            if (type.getName().startsWith("[")) {
                String typeName = type.getName().substring(1);
                for (int i = 0; i < primitiveTypes.length; ++i) {
                    if (!primitiveTypes[i].toString().equals(typeName)) continue;
                    String wrapper = "java.lang." + primitiveWrappers[i];
                    MethodReference methodRef = new MethodReference(wrapper, "valueOf", primitiveTypes[i], ValueType.object(wrapper));
                    agent.linkMethod(methodRef).use();
                    method.getResult().propagate(agent.getType("java.lang." + primitiveWrappers[i]));
                }
            }
        });
    }

    private void reachSet(DependencyAgent agent, MethodDependency method) {
        method.getVariable(3).connect(method.getVariable(1).getArrayItem());
        method.getVariable(1).addConsumer(type -> {
            if (type.getName().startsWith("[")) {
                String typeName = type.getName().substring(1);
                for (int i = 0; i < primitiveTypes.length; ++i) {
                    if (!primitiveTypes[i].toString().equals(typeName)) continue;
                    String wrapper = "java.lang." + primitiveWrappers[i];
                    MethodReference methodRef = new MethodReference(wrapper, primitives[i].toLowerCase() + "Value", primitiveTypes[i]);
                    agent.linkMethod(methodRef).use();
                }
            }
        });
    }
}

