/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.io.IOException;
import java.util.Collection;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.classlib.impl.ServiceLoaderInformation;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class ServiceLoaderJSSupport
implements Generator {
    private static final MethodDescriptor INIT_METHOD = new MethodDescriptor("<init>", Void.TYPE);

    @Override
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        ServiceLoaderInformation information = context.getService(ServiceLoaderInformation.class);
        writer.append("if (!").appendClass("java.util.ServiceLoader").append(".$$services$$) {").indent().softNewLine();
        writer.appendClass("java.util.ServiceLoader").append(".$$services$$ = true;").softNewLine();
        for (String string : information.serviceTypes()) {
            writer.appendClass(string).append(".$$serviceList$$ = [");
            Collection<? extends String> implementations = information.serviceImplementations(string);
            boolean first = true;
            for (String string2 : implementations) {
                if (!context.getClassSource().getClassNames().contains(string2)) continue;
                if (!first) {
                    writer.append(", ");
                }
                first = false;
                writer.append("[").appendClass(string2).append(", ").appendMethodBody(new MethodReference(string2, INIT_METHOD)).append("]");
            }
            writer.append("];").softNewLine();
        }
        writer.outdent().append("}").softNewLine();
        String param = context.getParameterName(1);
        writer.append("var cls = " + param + ";").softNewLine();
        writer.append("if (!cls.$$serviceList$$) {").indent().softNewLine();
        writer.append("return $rt_createArray($rt_objcls(), 0);").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("var result = $rt_createArray($rt_objcls(), cls.$$serviceList$$.length);").softNewLine();
        writer.append("for (var i = 0; i < result.data.length; ++i) {").indent().softNewLine();
        writer.append("var serviceDesc = cls.$$serviceList$$[i];").softNewLine();
        writer.append("result.data[i] = new serviceDesc[0]();").softNewLine();
        writer.append("serviceDesc[1](result.data[i]);").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("return result;").softNewLine();
    }
}

