/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import java.util.ArrayList;
import org.teavm.model.AccessLevel;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.Program;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.util.ProgramUtils;

public class KotlinHacks
implements ClassHolderTransformer {
    @Override
    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        if (cls.getName().equals("kotlin.jvm.internal.Lambda") || cls.getName().equals("kotlin.coroutines.jvm.internal.BaseContinuationImpl")) {
            this.patchContinuation(cls);
        } else if (cls.getName().equals("kotlin.jvm.internal.Reflection")) {
            this.patchReflection(cls);
        } else if (cls.getName().equals("kotlin.text.StringsKt__StringNumberConversionsJVMKt")) {
            this.patchStrings(cls, context.getHierarchy().getClassSource());
        }
    }

    private void patchContinuation(ClassHolder cls) {
        ArrayList<MethodHolder> methodsToRemove = new ArrayList<MethodHolder>();
        for (MethodHolder method : cls.getMethods()) {
            if (!method.getName().equals("toString")) continue;
            methodsToRemove.add(method);
        }
        for (MethodHolder method : methodsToRemove) {
            cls.removeMethod(method);
        }
    }

    private void patchReflection(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods()) {
            if (method.getLevel() != AccessLevel.PUBLIC || !method.hasModifier(ElementModifier.STATIC) || !method.getName().equals("renderLambdaToString") || !method.getResultType().isObject(String.class)) continue;
            Program program = new Program();
            program.createVariable();
            for (int i = 0; i < method.parameterCount(); ++i) {
                program.createVariable();
            }
            BasicBlock block = program.createBasicBlock();
            StringConstantInstruction stringConstant = new StringConstantInstruction();
            stringConstant.setReceiver(program.createVariable());
            stringConstant.setConstant("lambda");
            block.add(stringConstant);
            ExitInstruction exit = new ExitInstruction();
            exit.setValueToReturn(stringConstant.getReceiver());
            block.add(exit);
            method.setProgram(program);
        }
    }

    private void patchStrings(ClassHolder cls, ClassReaderSource source) {
        ClassReader templateClass = source.get(KotlinStrings.class.getName());
        for (MethodHolder method : cls.getMethods()) {
            MethodReader templateMethod;
            if (!method.getName().equals("toDoubleOrNull") && !method.getName().equals("toFloatOrNull") || (templateMethod = templateClass.getMethod(method.getDescriptor())) == null) continue;
            method.setProgram(ProgramUtils.copy(templateMethod.getProgram()));
        }
    }

    static class KotlinStrings {
        KotlinStrings() {
        }

        static Float toFloatOrNull(String value) {
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        static Double toDoubleOrNull(String value) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }
}

