/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import java.util.ArrayList;
import java.util.List;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.model.MethodReference;
import org.teavm.runtime.Mutator;

public class MutatorIntrinsic
implements WasmIntrinsic {
    private List<WasmInt32Constant> staticGcRootsExpressions = new ArrayList<WasmInt32Constant>();
    private List<WasmInt32Constant> classesExpressions = new ArrayList<WasmInt32Constant>();
    private List<WasmInt32Constant> classCountExpressions = new ArrayList<WasmInt32Constant>();

    public void setStaticGcRootsAddress(int address) {
        for (WasmInt32Constant constant : this.staticGcRootsExpressions) {
            constant.setValue(address);
        }
    }

    public void setClassesAddress(int address) {
        for (WasmInt32Constant constant : this.classesExpressions) {
            constant.setValue(address);
        }
    }

    public void setClassCount(int count) {
        for (WasmInt32Constant constant : this.classCountExpressions) {
            constant.setValue(count);
        }
    }

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        if (!methodReference.getClassName().equals(Mutator.class.getName())) {
            return false;
        }
        switch (methodReference.getName()) {
            case "getStaticGCRoots": 
            case "getClasses": 
            case "getClassCount": {
                return true;
            }
        }
        return false;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "getStaticGCRoots": {
                WasmInt32Constant constant = new WasmInt32Constant(0);
                this.staticGcRootsExpressions.add(constant);
                return constant;
            }
            case "getClasses": {
                WasmInt32Constant constant = new WasmInt32Constant(0);
                this.classesExpressions.add(constant);
                return constant;
            }
            case "getClassCount": {
                WasmInt32Constant constant = new WasmInt32Constant(0);
                this.classCountExpressions.add(constant);
                return constant;
            }
        }
        throw new IllegalArgumentException(invocation.getMethod().toString());
    }
}

