/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm;

import org.teavm.backend.wasm.WasmHeap;
import org.teavm.interop.Address;
import org.teavm.interop.Import;
import org.teavm.interop.StaticInit;
import org.teavm.interop.Unmanaged;
import org.teavm.runtime.RuntimeObject;

@StaticInit
@Unmanaged
public final class WasmRuntime {
    private WasmRuntime() {
    }

    public static int compare(int a, int b) {
        return WasmRuntime.gt(a, b) ? 1 : (WasmRuntime.lt(a, b) ? -1 : 0);
    }

    public static int compare(long a, long b) {
        return WasmRuntime.gt(a, b) ? 1 : (WasmRuntime.lt(a, b) ? -1 : 0);
    }

    public static int compare(float a, float b) {
        return WasmRuntime.gt(a, b) ? 1 : (WasmRuntime.lt(a, b) ? -1 : 0);
    }

    public static int compare(double a, double b) {
        return WasmRuntime.gt(a, b) ? 1 : (WasmRuntime.lt(a, b) ? -1 : 0);
    }

    public static float remainder(float a, float b) {
        return a - (float)((int)(a / b)) * b;
    }

    public static double remainder(double a, double b) {
        return a - (double)((long)(a / b)) * b;
    }

    private static native boolean lt(int var0, int var1);

    private static native boolean gt(int var0, int var1);

    private static native boolean lt(long var0, long var2);

    private static native boolean gt(long var0, long var2);

    private static native boolean lt(float var0, float var1);

    private static native boolean gt(float var0, float var1);

    private static native boolean lt(double var0, double var2);

    private static native boolean gt(double var0, double var2);

    public static Address align(Address address, int alignment) {
        int value = address.toInt();
        if (value == 0) {
            return address;
        }
        value = ((value - 1) / alignment + 1) * alignment;
        return Address.fromInt(value);
    }

    public static int align(int value, int alignment) {
        if (value == 0) {
            return value;
        }
        value = ((value - 1) / alignment + 1) * alignment;
        return value;
    }

    @Import(name="print", module="spectest")
    public static native void print(int var0);

    @Import(name="logString", module="teavm")
    public static native void printString(String var0);

    @Import(name="logInt", module="teavm")
    public static native void printInt(int var0);

    @Import(name="logOutOfMemory", module="teavm")
    public static native void printOutOfMemory();

    public static void fillZero(Address address, int count) {
        WasmRuntime.fill(address, (byte)0, count);
    }

    public static void fill(Address address, byte value, int count) {
        int value4 = value & 0xFF000000 | value & 0xFF0000 | value & 0xFF00 | value & 0xFF;
        int start = address.toInt();
        int alignedStart = start >>> 2 << 2;
        address = Address.fromInt(alignedStart);
        switch (start - alignedStart) {
            case 0: {
                address.putInt(value4);
                break;
            }
            case 1: {
                address.add(1).putByte(value);
                address.add(2).putByte(value);
                address.add(3).putByte(value);
                break;
            }
            case 2: {
                address.add(2).putByte(value);
                address.add(3).putByte(value);
                break;
            }
            case 3: {
                address.add(3).putByte(value);
            }
        }
        int end = start + count;
        int alignedEnd = end >>> 2 << 2;
        address = Address.fromInt(alignedEnd);
        switch (end - alignedEnd) {
            case 0: {
                break;
            }
            case 1: {
                address.putByte(value);
                break;
            }
            case 2: {
                address.putByte(value);
                address.add(1).putByte(value);
                break;
            }
            case 3: {
                address.putByte(value);
                address.add(1).putByte(value);
                address.add(2).putByte(value);
            }
        }
        address = Address.fromInt(alignedStart + 4);
        while (address.toInt() < alignedEnd) {
            address.putInt(value4);
            address = address.add(4);
        }
    }

    public static void moveMemoryBlock(Address source, Address target, int count) {
        if (count < 8) {
            WasmRuntime.slowMemoryMove(source, target, count);
            return;
        }
        int diff = source.toInt() - target.toInt();
        if (diff == 0) {
            return;
        }
        if ((diff & 3) != 0) {
            WasmRuntime.slowMemoryMove(source, target, count);
            return;
        }
        Address alignedSourceStart = Address.fromInt(source.toInt() >>> 2 << 2);
        Address alignedTargetStart = Address.fromInt(target.toInt() >>> 2 << 2);
        Address alignedSourceEnd = Address.fromInt(source.toInt() + count >>> 2 << 2);
        Address alignedTargetEnd = Address.fromInt(target.toInt() + count >>> 2 << 2);
        if (source.toInt() > target.toInt()) {
            switch (source.toInt() - alignedSourceStart.toInt()) {
                case 0: {
                    alignedTargetStart.putInt(alignedSourceStart.getInt());
                    break;
                }
                case 1: {
                    alignedTargetStart.add(1).putByte(alignedSourceStart.add(1).getByte());
                    alignedTargetStart.add(2).putShort(alignedSourceStart.add(2).getShort());
                    break;
                }
                case 2: {
                    alignedTargetStart.add(2).putShort(alignedSourceStart.add(2).getShort());
                    break;
                }
                case 3: {
                    alignedTargetStart.add(3).putByte(alignedSourceStart.add(3).getByte());
                }
            }
            alignedSourceStart = alignedSourceStart.add(4);
            alignedTargetStart = alignedTargetStart.add(4);
            while (alignedSourceStart.toInt() < alignedSourceEnd.toInt()) {
                alignedTargetStart.putInt(alignedSourceStart.getInt());
                alignedSourceStart = alignedSourceStart.add(4);
                alignedTargetStart = alignedTargetStart.add(4);
            }
            switch (source.toInt() + count - alignedSourceEnd.toInt()) {
                case 0: {
                    break;
                }
                case 1: {
                    alignedTargetEnd.putByte(alignedSourceEnd.getByte());
                    break;
                }
                case 2: {
                    alignedTargetEnd.putShort(alignedSourceEnd.getShort());
                    break;
                }
                case 3: {
                    alignedTargetEnd.putShort(alignedSourceEnd.getShort());
                    alignedTargetEnd.add(2).putByte(alignedSourceEnd.add(2).getByte());
                }
            }
        } else {
            switch (source.toInt() + count - alignedSourceEnd.toInt()) {
                case 0: {
                    break;
                }
                case 1: {
                    alignedTargetEnd.putByte(alignedSourceEnd.getByte());
                    break;
                }
                case 2: {
                    alignedTargetEnd.putShort(alignedSourceEnd.getShort());
                    break;
                }
                case 3: {
                    alignedTargetEnd.add(2).putByte(alignedSourceEnd.add(2).getByte());
                    alignedTargetEnd.putShort(alignedSourceEnd.getShort());
                }
            }
            while (alignedSourceEnd.toInt() > alignedSourceStart.toInt()) {
                alignedSourceEnd = alignedSourceEnd.add(-4);
                alignedTargetEnd = alignedTargetEnd.add(-4);
                alignedTargetEnd.putInt(alignedSourceEnd.getInt());
            }
            switch (source.toInt() - alignedSourceStart.toInt()) {
                case 1: {
                    alignedTargetStart.add(-2).putShort(alignedSourceStart.add(-2).getShort());
                    alignedTargetStart.add(-3).putByte(alignedSourceStart.add(-3).getByte());
                    break;
                }
                case 2: {
                    alignedTargetStart.add(-2).putShort(alignedSourceStart.add(-2).getShort());
                    break;
                }
                case 3: {
                    alignedTargetStart.add(-1).putByte(alignedSourceStart.add(-1).getByte());
                }
            }
        }
    }

    private static void slowMemoryMove(Address source, Address target, int count) {
        if (source.toInt() > target.toInt()) {
            while (count-- > 0) {
                target.putByte(source.getByte());
                target = target.add(1);
                source = source.add(1);
            }
        } else {
            source = source.add(count);
            target = target.add(count);
            while (count-- > 0) {
                target = target.add(-1);
                source = source.add(-1);
                target.putByte(source.getByte());
            }
        }
    }

    public static Address allocStack(int size) {
        Address stack = WasmHeap.stack;
        Address result = stack.add(4);
        stack = result.add((size << 2) + 4);
        stack.putInt(size);
        WasmHeap.stack = stack;
        return result;
    }

    public static Address getStackTop() {
        return WasmHeap.stack != WasmHeap.stackAddress ? WasmHeap.stack : null;
    }

    public static Address getNextStackFrame(Address stackFrame) {
        int size = stackFrame.getInt() + 2;
        Address result = stackFrame.add(-size * 4);
        if (result == WasmHeap.stackAddress) {
            result = null;
        }
        return result;
    }

    public static int getStackRootCount(Address stackFrame) {
        return stackFrame.getInt();
    }

    public static Address getStackRootPointer(Address stackFrame) {
        int size = stackFrame.getInt();
        return stackFrame.add(-size * 4);
    }

    private static Address getExceptionHandlerPtr(Address stackFrame) {
        int size = stackFrame.getInt();
        return stackFrame.add(-size * 4 - 4);
    }

    public static int getCallSiteId(Address stackFrame) {
        return WasmRuntime.getExceptionHandlerPtr(stackFrame).getInt();
    }

    public static void setExceptionHandlerId(Address stackFrame, int id) {
        WasmRuntime.getExceptionHandlerPtr(stackFrame).putInt(id);
    }

    private static int hashCode(RuntimeString string) {
        int hashCode = 0;
        int length = string.characters.length;
        Address chars = Address.ofData(string.characters);
        for (int i = 0; i < length; ++i) {
            hashCode = 31 * hashCode + chars.getChar();
            chars = chars.add(2);
        }
        return hashCode;
    }

    private static boolean equals(RuntimeString first, RuntimeString second) {
        if (first.characters.length != second.characters.length) {
            return false;
        }
        Address firstChars = Address.ofData(first.characters);
        Address secondChars = Address.ofData(second.characters);
        int length = first.characters.length;
        for (int i = 0; i < length; ++i) {
            if (firstChars.getChar() != secondChars.getChar()) {
                return false;
            }
            firstChars = firstChars.add(2);
            secondChars = secondChars.add(2);
        }
        return true;
    }

    public static String[] resourceMapKeys(Address map) {
        String[] result = new String[WasmRuntime.resourceMapSize(map)];
        WasmRuntime.fillResourceMapKeys(map, result);
        return result;
    }

    private static int resourceMapSize(Address map) {
        int result = 0;
        int sz = map.getInt();
        Address data = WasmRuntime.contentStart(map);
        for (int i = 0; i < sz; ++i) {
            if (data.getAddress() != null) {
                ++result;
            }
            data = data.add(Address.sizeOf() * 2);
        }
        return result;
    }

    private static void fillResourceMapKeys(Address map, String[] target) {
        int sz = map.getInt();
        Address data = WasmRuntime.contentStart(map);
        Address targetData = Address.ofData(target);
        for (int i = 0; i < sz; ++i) {
            Address entry = data.getAddress();
            if (entry != null) {
                targetData.putAddress(entry);
                targetData = targetData.add(Address.sizeOf());
            }
            data = data.add(Address.sizeOf());
        }
    }

    private static Address contentStart(Address resource) {
        return resource.add(Address.sizeOf());
    }

    public static Address lookupResource(Address map, String string) {
        RuntimeString runtimeString = (RuntimeString)Address.ofObject(string).toStructure();
        int hashCode = WasmRuntime.hashCode(runtimeString);
        int sz = map.getInt();
        Address content = WasmRuntime.contentStart(map);
        for (int i = 0; i < sz; ++i) {
            Address entry;
            Address key;
            int index = (hashCode + i) % sz;
            if (index < 0) {
                index += sz;
            }
            if ((key = (entry = content.add(index * Address.sizeOf() * 2)).getAddress()) == null) {
                return null;
            }
            if (!WasmRuntime.equals((RuntimeString)key.toStructure(), runtimeString)) continue;
            return entry;
        }
        return null;
    }

    static class RuntimeString
    extends RuntimeObject {
        char[] characters;

        RuntimeString() {
        }
    }
}

