/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.rendering;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.teavm.ast.ConstantExpr;
import org.teavm.ast.Expr;
import org.teavm.backend.javascript.codegen.SourceWriter;

public final class RenderingUtil {
    public static final Set<String> KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "export", "extends", "finally", "for", "function", "if", "import", "in", "instanceof", "new", "return", "super", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "yield", "NaN", "Map", "Set", "eval", "Math", "Date", "JSON", "Intl", "URL")));
    public static final String VARIABLE_START_CHARS = "abcdefghijklmnopqrstuvwxyz";
    public static final String VARIABLE_PART_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789$_";

    private RenderingUtil() {
    }

    public static String escapeName(String name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            sb.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
        }
        return sb.toString();
    }

    public static void writeString(SourceWriter writer, String s) throws IOException {
        if (s.isEmpty()) {
            writer.append("\"\"");
            return;
        }
        for (int i = 0; i < s.length(); i += 512) {
            int next = Math.min(i + 512, s.length());
            if (i > 0) {
                writer.newLine().append("+").ws();
            }
            writer.append('\"');
            block9: for (int j = i; j < next; ++j) {
                char c = s.charAt(j);
                switch (c) {
                    case '\r': {
                        writer.append("\\r");
                        continue block9;
                    }
                    case '\n': {
                        writer.append("\\n");
                        continue block9;
                    }
                    case '\t': {
                        writer.append("\\t");
                        continue block9;
                    }
                    case '\'': {
                        writer.append("\\'");
                        continue block9;
                    }
                    case '\"': {
                        writer.append("\\\"");
                        continue block9;
                    }
                    case '\\': {
                        writer.append("\\\\");
                        continue block9;
                    }
                    default: {
                        if (c < ' ') {
                            writer.append("\\u00").append(Character.forDigit(c / 16, 16)).append(Character.forDigit(c % 16, 16));
                            continue block9;
                        }
                        if (Character.isLowSurrogate(c) || Character.isHighSurrogate(c) || !Character.isDefined(c)) {
                            writer.append("\\u").append(Character.forDigit(c / 4096, 16)).append(Character.forDigit(c / 256 % 16, 16)).append(Character.forDigit(c / 16 % 16, 16)).append(Character.forDigit(c % 16, 16));
                            continue block9;
                        }
                        writer.append(c);
                    }
                }
            }
            writer.append('\"');
        }
    }

    public static String escapeString(String str) {
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block8;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        sb.append("\\u00").append(Character.forDigit(c / 16, 16)).append(Character.forDigit(c % 16, 16));
                        continue block8;
                    }
                    if (Character.isLowSurrogate(c) || Character.isHighSurrogate(c) || !Character.isDefined(c)) {
                        sb.append("\\u").append(Character.forDigit(c / 4096, 16)).append(Character.forDigit(c / 256 % 16, 16)).append(Character.forDigit(c / 16 % 16, 16)).append(Character.forDigit(c % 16, 16));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String indexToId(int index, String startChars) {
        if (index >= startChars.length()) {
            index -= startChars.length() - VARIABLE_PART_CHARS.length();
            StringBuilder sb = new StringBuilder();
            while (index >= startChars.length()) {
                sb.append(VARIABLE_PART_CHARS.charAt(index % VARIABLE_PART_CHARS.length()));
                index /= VARIABLE_PART_CHARS.length();
            }
            return sb.append(startChars.charAt(index % startChars.length())).reverse().toString();
        }
        return String.valueOf(startChars.charAt(index));
    }

    public static String indexToId(int index) {
        return RenderingUtil.indexToId(index, VARIABLE_START_CHARS);
    }

    public static boolean isSmallInteger(Expr expr) {
        if (!(expr instanceof ConstantExpr)) {
            return false;
        }
        Object constant = ((ConstantExpr)expr).getValue();
        if (!(constant instanceof Integer)) {
            return false;
        }
        int value = (Integer)constant;
        return Math.abs(value) < 262144;
    }
}

