/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.c.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teavm.backend.c.util.json.JsonAllErrorVisitor;
import org.teavm.backend.c.util.json.JsonArrayVisitor;
import org.teavm.backend.c.util.json.JsonErrorReporter;
import org.teavm.backend.c.util.json.JsonParser;
import org.teavm.backend.c.util.json.JsonPropertyVisitor;
import org.teavm.backend.c.util.json.JsonVisitingConsumer;
import org.teavm.backend.c.util.json.JsonVisitor;

public class Deobfuscator {
    private Map<Integer, CallSite> callSites = new HashMap<Integer, CallSite>();

    public Deobfuscator(Reader reader) throws IOException {
        CallSiteVisitor visitor = new CallSiteVisitor();
        new JsonParser(new JsonVisitingConsumer(new JsonArrayVisitor(visitor))).parse(reader);
        visitor.flush();
    }

    public Location[] getLocations(int callSiteId) {
        CallSite callSite = this.callSites.get(callSiteId);
        if (callSite == null) {
            return null;
        }
        Location[] result = new Location[callSite.locations.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = callSite.locations[i].clone();
        }
        return result;
    }

    public String deobfuscate(Reader text) throws IOException {
        StringBuilder result = new StringBuilder();
        String expectedPrefix = "\tat Obfuscated.obfuscated(Obfuscated.java:";
        int expectedPrefixPos = 0;
        boolean isInNumber = false;
        boolean expectingLineEnd = false;
        StringBuilder sb = new StringBuilder();
        while (true) {
            int c = text.read();
            if (expectedPrefixPos >= 0) {
                if (expectedPrefix.charAt(expectedPrefixPos) == c) {
                    if (++expectedPrefixPos != expectedPrefix.length()) continue;
                    expectedPrefixPos = -1;
                    isInNumber = true;
                    continue;
                }
                result.append(expectedPrefix, 0, expectedPrefixPos);
                expectedPrefixPos = -1;
            } else if (isInNumber) {
                if (c >= 48 && c <= 57) {
                    sb.append((char)c);
                    continue;
                }
                if (c == 41) {
                    isInNumber = false;
                    expectingLineEnd = true;
                    continue;
                }
                isInNumber = false;
                result.append(expectedPrefix).append((CharSequence)sb);
            }
            if (c == 13 || c == 10 || c < 0) {
                if (expectingLineEnd) {
                    int callSiteId = Integer.parseInt(sb.toString());
                    Location[] locations = this.getLocations(callSiteId);
                    if (locations == null) {
                        result.append(expectedPrefix).append((CharSequence)sb).append(')');
                    } else {
                        boolean first = true;
                        for (Location location : locations) {
                            if (!first) {
                                result.append('\n');
                            }
                            first = false;
                            result.append("    ");
                            result.append(location.className).append('.').append(location.methodName).append('(');
                            if (location.fileName != null & location.line >= 0) {
                                result.append(location.fileName).append(':').append(location.line);
                            } else {
                                result.append("Unknown location");
                            }
                            result.append(")");
                        }
                    }
                    sb.setLength(0);
                }
                expectingLineEnd = false;
                expectedPrefixPos = 0;
            }
            if (c < 0) break;
            result.append((char)c);
        }
        return result.toString();
    }

    public static void main(String[] args) throws IOException {
        String result;
        Deobfuscator deobfuscator;
        if (args.length != 2) {
            System.err.println("Two arguments expected (JSON table file, stack trace file)");
            System.exit(1);
        }
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(args[0]));
             InputStreamReader reader = new InputStreamReader((InputStream)input, StandardCharsets.UTF_8);){
            deobfuscator = new Deobfuscator(reader);
        }
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(args[1]));
             InputStreamReader reader = new InputStreamReader((InputStream)input, StandardCharsets.UTF_8);){
            result = deobfuscator.deobfuscate(reader);
        }
        System.out.println(result);
    }

    public static class Location
    implements Cloneable {
        public String className;
        public String methodName;
        public String fileName;
        public int line = -1;

        protected Location clone() {
            try {
                return (Location)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class CallSite {
        int id;
        Location[] locations;

        CallSite() {
        }
    }

    class CallSiteVisitor
    extends JsonAllErrorVisitor {
        CallSite callSite;
        List<Location> locations = new ArrayList<Location>();
        Location location;
        JsonPropertyVisitor propertyVisitor = new JsonPropertyVisitor(false);
        JsonPropertyVisitor locationPropertyVisitor = new JsonPropertyVisitor(false);
        JsonAllErrorVisitor locationVisitor = new JsonAllErrorVisitor(){

            @Override
            public JsonVisitor object(JsonErrorReporter reporter) {
                CallSiteVisitor.this.location = new Location();
                CallSiteVisitor.this.locations.add(CallSiteVisitor.this.location);
                return CallSiteVisitor.this.locationPropertyVisitor;
            }
        };

        CallSiteVisitor() {
            this.propertyVisitor.addProperty("id", new JsonAllErrorVisitor(){

                @Override
                public void intValue(JsonErrorReporter reporter, long value) {
                    CallSiteVisitor.this.callSite.id = (int)value;
                }
            });
            this.propertyVisitor.addProperty("locations", new JsonArrayVisitor(this.locationVisitor));
            this.locationPropertyVisitor.addProperty("file", new JsonAllErrorVisitor(){

                @Override
                public void stringValue(JsonErrorReporter reporter, String value) {
                    CallSiteVisitor.this.location.fileName = value;
                }

                @Override
                public void nullValue(JsonErrorReporter reporter) {
                    CallSiteVisitor.this.location.fileName = null;
                }
            });
            this.locationPropertyVisitor.addProperty("class", new JsonAllErrorVisitor(){

                @Override
                public void stringValue(JsonErrorReporter reporter, String value) {
                    CallSiteVisitor.this.location.className = value;
                }

                @Override
                public void nullValue(JsonErrorReporter reporter) {
                    CallSiteVisitor.this.location.className = null;
                }
            });
            this.locationPropertyVisitor.addProperty("method", new JsonAllErrorVisitor(){

                @Override
                public void stringValue(JsonErrorReporter reporter, String value) {
                    CallSiteVisitor.this.location.methodName = value;
                }

                @Override
                public void nullValue(JsonErrorReporter reporter) {
                    CallSiteVisitor.this.location.methodName = null;
                }
            });
            this.locationPropertyVisitor.addProperty("line", new JsonAllErrorVisitor(){

                @Override
                public void intValue(JsonErrorReporter reporter, long value) {
                    CallSiteVisitor.this.location.line = (int)value;
                }
            });
        }

        @Override
        public JsonVisitor object(JsonErrorReporter reporter) {
            this.flush();
            this.callSite = new CallSite();
            return this.propertyVisitor;
        }

        void flush() {
            if (this.callSite != null) {
                Deobfuscator.this.callSites.put(this.callSite.id, this.callSite);
                this.callSite.locations = this.locations.toArray(new Location[0]);
                this.locations.clear();
            }
        }
    }
}

