/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.common.GraphUtils;
import org.teavm.common.IntegerArray;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.FieldDependencyInfo;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.dependency.ValueDependencyInfo;
import org.teavm.hppc.IntHashSet;
import org.teavm.hppc.IntSet;
import org.teavm.hppc.IntStack;
import org.teavm.hppc.ObjectIntHashMap;
import org.teavm.hppc.ObjectIntMap;
import org.teavm.hppc.cursors.IntCursor;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.AbstractInstructionVisitor;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.UnwrapArrayInstruction;

public class ClassInference {
    private DependencyInfo dependencyInfo;
    private ClassHierarchy hierarchy;
    private Graph assignmentGraph;
    private Graph cloneGraph;
    private Graph arrayGraph;
    private Graph itemGraph;
    private Graph graph;
    private ValueCast[] casts;
    private int[] exceptions;
    private VirtualCallSite[] virtualCallSites;
    private int[] propagationPath;
    private int[] nodeMapping;
    private IntHashSet[] types;
    private ObjectIntMap<String> typeMap = new ObjectIntHashMap<String>();
    private List<String> typeList = new ArrayList<String>();
    private boolean changed = true;
    private boolean[] nodeChanged;
    private boolean[] formerNodeChanged;
    private static final int MAX_DEGREE = 3;
    private static final byte FRESH = 0;
    private static final byte VISITING = 1;
    private static final byte VISITED = 2;

    public ClassInference(DependencyInfo dependencyInfo, ClassHierarchy hierarchy) {
        this.dependencyInfo = dependencyInfo;
        this.hierarchy = hierarchy;
    }

    public void infer(Program program, MethodReference methodReference) {
        this.types = new IntHashSet[program.variableCount() << 3];
        this.nodeChanged = new boolean[this.types.length];
        this.formerNodeChanged = new boolean[this.nodeChanged.length];
        this.nodeMapping = new int[this.types.length];
        for (int i = 0; i < this.types.length; ++i) {
            this.nodeMapping[i] = i;
        }
        MethodDependencyInfo thisMethodDep = this.dependencyInfo.getMethod(methodReference);
        this.buildPreliminaryGraphs(program, thisMethodDep);
        block1: for (int i = 0; i <= methodReference.parameterCount(); ++i) {
            ValueDependencyInfo paramDep = thisMethodDep.getVariable(i);
            if (paramDep == null) continue;
            for (int degree = 0; degree <= 3; ++degree) {
                for (String paramType : paramDep.getTypes()) {
                    this.addType(i, degree, paramType);
                }
                if (!paramDep.hasArrayType()) continue block1;
                paramDep = paramDep.getArrayItem();
            }
        }
        this.buildPropagationGraph();
        this.collapseSCCs();
        this.buildPropagationPath();
        this.propagate(program);
        this.assignmentGraph = null;
        this.graph = null;
        this.cloneGraph = null;
        this.arrayGraph = null;
        this.itemGraph = null;
        this.casts = null;
        this.exceptions = null;
        this.virtualCallSites = null;
        this.propagationPath = null;
        this.nodeChanged = null;
    }

    public String[] classesOf(int variableIndex) {
        IntHashSet typeSet = this.types[this.nodeMapping[ClassInference.packNodeAndDegree(variableIndex, 0)]];
        if (typeSet == null) {
            return new String[0];
        }
        int[] typeIndexes = typeSet.toArray();
        String[] types = new String[typeIndexes.length];
        for (int i = 0; i < typeIndexes.length; ++i) {
            types[i] = this.typeList.get(typeIndexes[i]);
        }
        return types;
    }

    private void buildPreliminaryGraphs(Program program, MethodDependencyInfo thisMethodDep) {
        GraphBuildingVisitor visitor = new GraphBuildingVisitor(program.variableCount(), this.dependencyInfo);
        visitor.thisMethodDep = thisMethodDep;
        Iterator<BasicBlock> iterator = program.getBasicBlocks().iterator();
        while (iterator.hasNext()) {
            BasicBlock block;
            visitor.currentBlock = block = iterator.next();
            for (Phi phi : block.getPhis()) {
                visitor.visit(phi);
            }
            for (Instruction insn : block) {
                insn.acceptVisitor(visitor);
            }
            if (block.getExceptionVariable() == null) continue;
            this.getNodeTypes(ClassInference.packNodeAndDegree(block.getExceptionVariable().getIndex(), 0));
        }
        this.assignmentGraph = visitor.assignmentGraphBuilder.build();
        this.cloneGraph = visitor.cloneGraphBuilder.build();
        this.arrayGraph = visitor.arrayGraphBuilder.build();
        this.itemGraph = visitor.itemGraphBuilder.build();
        this.casts = visitor.casts.toArray(new ValueCast[0]);
        this.exceptions = visitor.exceptions.getAll();
        this.virtualCallSites = visitor.virtualCallSites.toArray(new VirtualCallSite[0]);
    }

    private void buildPropagationGraph() {
        IntStack stack = new IntStack();
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] == null) continue;
            stack.push(i);
        }
        boolean[] visited = new boolean[this.types.length];
        GraphBuilder graphBuilder = new GraphBuilder(this.types.length);
        while (!stack.isEmpty()) {
            Object object;
            int entry = stack.pop();
            if (visited[entry]) continue;
            visited[entry] = true;
            int degree = ClassInference.extractDegree(entry);
            int variable = ClassInference.extractNode(entry);
            IntHashSet nextEntries = new IntHashSet();
            for (Object successor : this.assignmentGraph.outgoingEdges(variable)) {
                nextEntries.add(ClassInference.packNodeAndDegree(successor, degree));
            }
            for (Object successor : this.cloneGraph.outgoingEdges(variable)) {
                nextEntries.add(ClassInference.packNodeAndDegree(successor, degree));
            }
            if (degree > 0) {
                for (int predecessor : this.assignmentGraph.incomingEdges(variable)) {
                    nextEntries.add(ClassInference.packNodeAndDegree(predecessor, degree));
                }
                object = this.itemGraph.outgoingEdges(variable);
                int n = ((Object)object).length;
                for (int i = 0; i < n; ++i) {
                    Object successor;
                    successor = object[i];
                    nextEntries.add(ClassInference.packNodeAndDegree(successor, degree - 1));
                }
            }
            for (Object successor : this.arrayGraph.outgoingEdges(variable)) {
                nextEntries.add(ClassInference.packNodeAndDegree(successor, degree + 1));
            }
            object = nextEntries.iterator();
            while (object.hasNext()) {
                IntCursor next = (IntCursor)object.next();
                graphBuilder.addEdge(entry, next.value);
                if (visited[next.value]) continue;
                stack.push(next.value);
            }
        }
        this.graph = graphBuilder.build();
    }

    private void collapseSCCs() {
        int[][] sccs = GraphUtils.findStronglyConnectedComponents(this.graph);
        if (sccs.length == 0) {
            return;
        }
        for (int[] scc : sccs) {
            for (int i2 = 1; i2 < scc.length; ++i2) {
                this.nodeMapping[scc[i2]] = scc[0];
            }
        }
        boolean[] nodeChangedBackup = (boolean[])this.nodeChanged.clone();
        IntHashSet[] typesBackup = (IntHashSet[])this.types.clone();
        Arrays.fill(this.nodeChanged, false);
        Arrays.fill(this.types, null);
        GraphBuilder graphBuilder = new GraphBuilder(this.graph.size());
        for (int i = 0; i < this.graph.size(); ++i) {
            int[] i2 = this.graph.outgoingEdges(i);
            int n = i2.length;
            for (int j = 0; j < n; ++j) {
                int from = this.nodeMapping[i];
                int j2 = i2[j];
                int to = this.nodeMapping[j2];
                if (from == to) continue;
                graphBuilder.addEdge(from, to);
            }
            int node = this.nodeMapping[i];
            if (typesBackup[i] != null) {
                this.getNodeTypes(node).addAll(typesBackup[i]);
            }
            if (!nodeChangedBackup[i]) continue;
            this.nodeChanged[node] = true;
        }
        this.graph = graphBuilder.build();
    }

    private void buildPropagationPath() {
        byte[] state = new byte[this.types.length];
        int[] path = new int[this.types.length];
        int pathSize = 0;
        IntStack stack = new IntStack();
        for (int i = 0; i < this.graph.size(); ++i) {
            if (this.graph.incomingEdgesCount(i) != 0 || this.types[i] == null) continue;
            stack.push(i);
        }
        while (!stack.isEmpty()) {
            int node = stack.pop();
            if (state[node] == 0) {
                state[node] = 1;
                stack.push(node);
                for (int successor : this.graph.outgoingEdges(node)) {
                    if (state[successor] != 0) continue;
                    stack.push(successor);
                }
                continue;
            }
            if (state[node] != 1) continue;
            path[pathSize++] = node;
            state[node] = 2;
        }
        this.propagationPath = Arrays.copyOf(path, pathSize);
    }

    private void propagate(Program program) {
        this.changed = false;
        while (true) {
            System.arraycopy(this.nodeChanged, 0, this.formerNodeChanged, 0, this.nodeChanged.length);
            Arrays.fill(this.nodeChanged, false);
            this.propagateAlongDAG();
            boolean outerChanged = this.changed;
            do {
                this.changed = false;
                this.propagateAlongCasts();
                this.propagateAlongVirtualCalls(program);
                this.propagateAlongExceptions(program);
                if (!this.changed) continue;
                outerChanged = true;
            } while (this.changed);
            if (!outerChanged) break;
            this.changed = false;
        }
    }

    private void propagateAlongDAG() {
        for (int i = this.propagationPath.length - 1; i >= 0; --i) {
            int node = this.propagationPath[i];
            boolean predecessorsChanged = false;
            for (int predecessor : this.graph.incomingEdges(node)) {
                if (!this.formerNodeChanged[predecessor] && !this.nodeChanged[predecessor]) continue;
                predecessorsChanged = true;
                break;
            }
            if (!predecessorsChanged) continue;
            IntHashSet nodeTypes = this.getNodeTypes(node);
            for (int predecessor : this.graph.incomingEdges(node)) {
                if (!this.formerNodeChanged[predecessor] && !this.nodeChanged[predecessor] || nodeTypes.addAll(this.types[predecessor]) <= 0) continue;
                this.nodeChanged[node] = true;
                this.changed = true;
            }
        }
    }

    private void propagateAlongCasts() {
        for (ValueCast cast : this.casts) {
            int fromNode = this.nodeMapping[ClassInference.packNodeAndDegree(cast.fromVariable, 0)];
            if (!this.formerNodeChanged[fromNode] && !this.nodeChanged[fromNode]) continue;
            int toNode = this.nodeMapping[ClassInference.packNodeAndDegree(cast.toVariable, 0)];
            IntHashSet targetTypes = this.getNodeTypes(toNode);
            for (IntCursor cursor : this.types[fromNode]) {
                ValueType type;
                if (targetTypes.contains(cursor.value)) continue;
                String className = this.typeList.get(cursor.value);
                if (className.startsWith("[")) {
                    type = ValueType.parseIfPossible(className);
                    if (type == null) {
                        type = ValueType.arrayOf(ValueType.object("java.lang.Object"));
                    }
                } else {
                    type = ValueType.object(className);
                }
                if (!this.hierarchy.isSuperType(cast.targetType, type, false)) continue;
                this.changed = true;
                this.nodeChanged[toNode] = true;
                targetTypes.add(cursor.value);
            }
        }
    }

    private void propagateAlongVirtualCalls(Program program) {
        ClassReaderSource classSource = this.dependencyInfo.getClassSource();
        for (VirtualCallSite callSite : this.virtualCallSites) {
            int instanceNode = this.nodeMapping[ClassInference.packNodeAndDegree(callSite.instance, 0)];
            if (!this.formerNodeChanged[instanceNode] && !this.nodeChanged[instanceNode]) continue;
            for (IntCursor type : this.types[instanceNode]) {
                MethodDependencyInfo methodDep;
                MethodReference resolvedMethodRef;
                String className;
                MethodReference rawMethod;
                MethodReader resolvedMethod;
                if (!callSite.knownClasses.add(type.value) || (resolvedMethod = classSource.resolveImplementation(rawMethod = new MethodReference(className = this.typeList.get(type.value), callSite.method.getDescriptor()))) == null || !callSite.resolvedMethods.add(resolvedMethodRef = resolvedMethod.getReference()) || (methodDep = this.dependencyInfo.getMethod(resolvedMethodRef)) == null) continue;
                if (callSite.receiver >= 0) {
                    this.readValue(methodDep.getResult(), program.variableAt(callSite.receiver));
                }
                for (int i = 0; i < callSite.arguments.length; ++i) {
                    this.writeValue(methodDep.getVariable(i + 1), program.variableAt(callSite.arguments[i]));
                }
                for (String thrownTypeName : methodDep.getThrown().getTypes()) {
                    this.propagateException(thrownTypeName, program.basicBlockAt(callSite.block));
                }
            }
        }
    }

    private void propagateAlongExceptions(Program program) {
        for (int i = 0; i < this.exceptions.length; i += 2) {
            int variable = this.nodeMapping[ClassInference.packNodeAndDegree(this.exceptions[i], 0)];
            if (!this.formerNodeChanged[variable] && !this.nodeChanged[variable]) continue;
            BasicBlock block = program.basicBlockAt(this.exceptions[i + 1]);
            for (IntCursor type : this.types[variable]) {
                String typeName = this.typeList.get(type.value);
                this.propagateException(typeName, block);
            }
        }
    }

    private void propagateException(String thrownTypeName, BasicBlock block) {
        for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
            String expectedType = tryCatch.getExceptionType();
            if (expectedType != null && !this.hierarchy.isSuperType(expectedType, thrownTypeName, false)) continue;
            if (tryCatch.getHandler().getExceptionVariable() == null) break;
            int exceptionNode = ClassInference.packNodeAndDegree(tryCatch.getHandler().getExceptionVariable().getIndex(), 0);
            exceptionNode = this.nodeMapping[exceptionNode];
            int thrownType = this.getTypeByName(thrownTypeName);
            if (!this.getNodeTypes(exceptionNode).add(thrownType)) break;
            this.nodeChanged[exceptionNode] = true;
            this.changed = true;
            break;
        }
    }

    IntHashSet getNodeTypes(int node) {
        IntHashSet result = this.types[node];
        if (result == null) {
            this.types[node] = result = new IntHashSet();
        }
        return result;
    }

    int getTypeByName(String typeName) {
        int type = this.typeMap.getOrDefault(typeName, -1);
        if (type < 0) {
            type = this.typeList.size();
            this.typeMap.put(typeName, type);
            this.typeList.add(typeName);
        }
        return type;
    }

    void readValue(ValueDependencyInfo valueDep, Variable receiver) {
        boolean hasArrayType;
        int depth = 0;
        do {
            for (String type : valueDep.getTypes()) {
                this.addType(receiver.getIndex(), depth, type);
            }
            hasArrayType = valueDep.hasArrayType();
            valueDep = valueDep.getArrayItem();
        } while (hasArrayType && ++depth <= 3);
    }

    void writeValue(ValueDependencyInfo valueDep, Variable source) {
        int depth = 0;
        while (valueDep.hasArrayType() && depth < 3) {
            ++depth;
            valueDep = valueDep.getArrayItem();
            for (String type : valueDep.getTypes()) {
                this.addType(source.getIndex(), depth, type);
            }
        }
    }

    void addType(int variable, int degree, String typeName) {
        int entry = this.nodeMapping[ClassInference.packNodeAndDegree(variable, degree)];
        if (this.getNodeTypes(entry).add(this.getTypeByName(typeName))) {
            this.nodeChanged[entry] = true;
            this.changed = true;
        }
    }

    static int extractNode(int nodeAndDegree) {
        return nodeAndDegree >>> 3;
    }

    static int extractDegree(int nodeAndDegree) {
        return nodeAndDegree & 7;
    }

    static int packNodeAndDegree(int node, int degree) {
        return node << 3 | degree;
    }

    static long packTwoIntegers(int a, int b) {
        return (long)a << 32 | (long)b;
    }

    static int unpackFirst(long pair) {
        return (int)(pair >>> 32);
    }

    static int unpackSecond(long pair) {
        return (int)pair;
    }

    static final class ValueCast {
        final int fromVariable;
        final int toVariable;
        final ValueType targetType;

        ValueCast(int fromVariable, int toVariable, ValueType targetType) {
            this.fromVariable = fromVariable;
            this.toVariable = toVariable;
            this.targetType = targetType;
        }
    }

    static class VirtualCallSite {
        int instance;
        IntSet knownClasses = new IntHashSet();
        Set<MethodReference> resolvedMethods = new HashSet<MethodReference>();
        MethodReference method;
        int[] arguments;
        int receiver;
        int block;

        VirtualCallSite() {
        }
    }

    class GraphBuildingVisitor
    extends AbstractInstructionVisitor {
        DependencyInfo dependencyInfo;
        GraphBuilder assignmentGraphBuilder;
        GraphBuilder cloneGraphBuilder;
        GraphBuilder arrayGraphBuilder;
        GraphBuilder itemGraphBuilder;
        MethodDependencyInfo thisMethodDep;
        List<ValueCast> casts = new ArrayList<ValueCast>();
        IntegerArray exceptions = new IntegerArray(2);
        List<VirtualCallSite> virtualCallSites = new ArrayList<VirtualCallSite>();
        BasicBlock currentBlock;

        GraphBuildingVisitor(int variableCount, DependencyInfo dependencyInfo) {
            this.dependencyInfo = dependencyInfo;
            this.assignmentGraphBuilder = new GraphBuilder(variableCount);
            this.cloneGraphBuilder = new GraphBuilder(variableCount);
            this.arrayGraphBuilder = new GraphBuilder(variableCount);
            this.itemGraphBuilder = new GraphBuilder(variableCount);
        }

        public void visit(Phi phi) {
            for (Incoming incoming : phi.getIncomings()) {
                this.assignmentGraphBuilder.addEdge(incoming.getValue().getIndex(), phi.getReceiver().getIndex());
            }
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            ClassInference.this.addType(insn.getReceiver().getIndex(), 0, "java.lang.Class");
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            ClassInference.this.addType(insn.getReceiver().getIndex(), 0, "java.lang.String");
        }

        @Override
        public void visit(AssignInstruction insn) {
            this.assignmentGraphBuilder.addEdge(insn.getAssignee().getIndex(), insn.getReceiver().getIndex());
        }

        @Override
        public void visit(CastInstruction insn) {
            this.casts.add(new ValueCast(insn.getValue().getIndex(), insn.getReceiver().getIndex(), insn.getTargetType()));
            ClassInference.this.getNodeTypes(ClassInference.packNodeAndDegree(insn.getReceiver().getIndex(), 0));
        }

        @Override
        public void visit(RaiseInstruction insn) {
            this.exceptions.add(insn.getException().getIndex());
            this.exceptions.add(this.currentBlock.getIndex());
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            ClassInference.this.addType(insn.getReceiver().getIndex(), 0, ValueType.arrayOf(insn.getItemType()).toString());
        }

        @Override
        public void visit(ConstructInstruction insn) {
            ClassInference.this.addType(insn.getReceiver().getIndex(), 0, insn.getType());
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            ValueType type = insn.getItemType();
            for (int i = 0; i < insn.getDimensions().size(); ++i) {
                type = ValueType.arrayOf(type);
            }
            ClassInference.this.addType(insn.getReceiver().getIndex(), 0, type.toString());
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            FieldDependencyInfo fieldDep = this.dependencyInfo.getField(insn.getField());
            ValueDependencyInfo valueDep = fieldDep.getValue();
            ClassInference.this.readValue(valueDep, insn.getReceiver());
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            FieldDependencyInfo fieldDep = this.dependencyInfo.getField(insn.getField());
            ValueDependencyInfo valueDep = fieldDep.getValue();
            ClassInference.this.writeValue(valueDep, insn.getValue());
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            this.cloneGraphBuilder.addEdge(insn.getArray().getIndex(), insn.getReceiver().getIndex());
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
            this.assignmentGraphBuilder.addEdge(insn.getArray().getIndex(), insn.getReceiver().getIndex());
        }

        @Override
        public void visit(GetElementInstruction insn) {
            this.itemGraphBuilder.addEdge(insn.getArray().getIndex(), insn.getReceiver().getIndex());
        }

        @Override
        public void visit(PutElementInstruction insn) {
            this.arrayGraphBuilder.addEdge(insn.getValue().getIndex(), insn.getArray().getIndex());
        }

        @Override
        public void visit(ExitInstruction insn) {
            if (insn.getValueToReturn() != null) {
                ValueDependencyInfo resultDependency = this.thisMethodDep.getResult();
                for (int resultDegree = 0; resultDependency.hasArrayType() && resultDegree <= 3; ++resultDegree) {
                    resultDependency = resultDependency.getArrayItem();
                    for (String paramType : resultDependency.getTypes()) {
                        ClassInference.this.addType(insn.getValueToReturn().getIndex(), resultDegree, paramType);
                    }
                }
            }
        }

        @Override
        public void visit(InvokeInstruction insn) {
            if (insn.getType() == InvocationType.VIRTUAL) {
                int instance = insn.getInstance().getIndex();
                VirtualCallSite callSite = new VirtualCallSite();
                callSite.instance = instance;
                callSite.method = insn.getMethod();
                callSite.arguments = new int[insn.getArguments().size()];
                for (int i = 0; i < insn.getArguments().size(); ++i) {
                    callSite.arguments[i] = insn.getArguments().get(i).getIndex();
                    for (int j = 0; j <= 3; ++j) {
                        ClassInference.this.getNodeTypes(ClassInference.packNodeAndDegree(callSite.arguments[i], j));
                    }
                }
                callSite.receiver = insn.getReceiver() != null ? insn.getReceiver().getIndex() : -1;
                callSite.block = this.currentBlock.getIndex();
                this.virtualCallSites.add(callSite);
                if (insn.getReceiver() != null) {
                    for (int j = 0; j <= 3; ++j) {
                        ClassInference.this.getNodeTypes(ClassInference.packNodeAndDegree(callSite.receiver, j));
                    }
                }
                return;
            }
            MethodDependencyInfo methodDep = this.dependencyInfo.getMethod(insn.getMethod());
            if (methodDep != null) {
                if (insn.getReceiver() != null) {
                    ClassInference.this.readValue(methodDep.getResult(), insn.getReceiver());
                }
                for (int i = 0; i < insn.getArguments().size(); ++i) {
                    ClassInference.this.writeValue(methodDep.getVariable(i + 1), insn.getArguments().get(i));
                }
                for (String type : methodDep.getThrown().getTypes()) {
                    ClassInference.this.propagateException(type, this.currentBlock);
                }
            }
        }
    }
}

