/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import org.teavm.hppc.BitMixer;
import org.teavm.hppc.HashOrderMixing;
import org.teavm.hppc.LongIntHashMap;

public class LongIntScatterMap
extends LongIntHashMap {
    public LongIntScatterMap() {
        this(4);
    }

    public LongIntScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongIntScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(long key) {
        return BitMixer.mixPhi(key);
    }

    public static LongIntScatterMap from(long[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongIntScatterMap map = new LongIntScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

